/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model;

import java.math.BigDecimal;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.Prescaler;
import org.eclipse.app4mc.amalthea.model.Quartz;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;

public class OMCore {
    private final Core coreRef;
    private long instructionsPerSecond = -1L;

    public OMCore(Core coreRef) {
        this.coreRef = coreRef;
    }

    public Core getCoreRef() {
        return this.coreRef;
    }

    public long getInstructionsPerSecond() {
        if (this.instructionsPerSecond >= 0L) {
            return this.instructionsPerSecond;
        }
        Prescaler prescaler = this.coreRef.getPrescaler();
        if (prescaler == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, Core '" + this.coreRef.getName() + "' has an invalid or missing reference to its Prescaler.", null);
            return -1L;
        }
        double clockRatio = prescaler.getClockRatio();
        if (clockRatio <= 0.0) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the referred Prescaler of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute clockRatio.", null);
            return -1L;
        }
        Quartz quartz = prescaler.getQuartz();
        if (quartz == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the referred Prescaler of Core '" + this.coreRef.getName() + "' has an invalid or missing reference to Quartz.", null);
            return -1L;
        }
        BigDecimal frequencyQuartz = AmaltheaServices.convertToHz((Frequency)quartz.getFrequency());
        long frequency = frequencyQuartz.longValue();
        if (frequency <= 0L) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the referred Quartz of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute frequency.", null);
            return -1L;
        }
        CoreType type = this.coreRef.getCoreType();
        if (type == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, Core '" + this.coreRef.getName() + "' has an invalid or missing reference to its CoreType.", null);
            return -1L;
        }
        int instructionsPerCycle = type.getInstructionsPerCycle();
        if (instructionsPerCycle <= 0) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the referred CoreType of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute instructionsPerCycle.", null);
            return -1L;
        }
        this.instructionsPerSecond = (long)((double)frequency * clockRatio * (double)instructionsPerCycle);
        return this.instructionsPerSecond;
    }

    public String toString() {
        return this.coreRef.getUniqueName();
    }
}

