/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model;

import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ProbabiltitySwitch;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.openmapping.model.OMRunnable;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;

public class OMTask {
    private final Task taskRef;
    private OMTask predecessor = null;
    private long iInstructionCount = -1L;
    private long iRunnableCount = -1L;

    public OMTask(Task taskRef) {
        this.taskRef = taskRef;
    }

    public OMTask(Task taskRef, OMTask predecessor) {
        this.taskRef = taskRef;
        this.predecessor = predecessor;
    }

    public Task getTaskRef() {
        return this.taskRef;
    }

    public OMTask getPredecessor() {
        return this.predecessor;
    }

    public long getInstructionCount() {
        if (0L > this.iInstructionCount) {
            this.fetchRunnableAndInstructionCount();
        }
        return this.iInstructionCount;
    }

    public long getRunnableCount() {
        if (0L > this.iRunnableCount) {
            this.fetchRunnableAndInstructionCount();
        }
        return this.iRunnableCount;
    }

    private void fetchRunnableAndInstructionCount() {
        CallGraph callGraph = this.taskRef.getCallGraph();
        if (callGraph == null) {
            UniversalHandler.getInstance().log("Invalid Software Model, Task '" + this.taskRef.getName() + "' has an invalid or missing containment to its CallGraph.", null);
            return;
        }
        if (callGraph.getGraphEntries().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid Software Model, The CallGraph of Task '" + this.taskRef.getName() + "' is empty", null);
            return;
        }
        ++this.iRunnableCount;
        this.iInstructionCount = this.processCallGraph(callGraph);
    }

    private long processCallGraph(CallGraph callGraph) {
        long tmpInstr = 0L;
        for (GraphEntryBase graphEntry : callGraph.getGraphEntries()) {
            if (graphEntry instanceof CallSequence) {
                tmpInstr += this.processCallSequence((CallSequence)graphEntry);
                continue;
            }
            if (graphEntry instanceof ModeSwitch) {
                UniversalHandler.getInstance().log("GraphEntry specialisation LabelSwitch is not supported. Skipping...", null, 2);
                continue;
            }
            if (graphEntry instanceof ProbabiltitySwitch) {
                UniversalHandler.getInstance().log("GraphEntry specialisation ProbabiltitySwitch is not supported. Skipping...", null, 2);
                continue;
            }
            UniversalHandler.getInstance().log("Unkown GraphEntry specialisation. Skipping...", null);
        }
        return tmpInstr;
    }

    private long processCallSequence(CallSequence callSeq) {
        long tmpInstr = 0L;
        if (callSeq.getCalls().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid Software Model, CallSequence must not be empty. Skipping...", null);
            return tmpInstr;
        }
        for (CallSequenceItem callSeqEntry : callSeq.getCalls()) {
            if (callSeqEntry instanceof TaskRunnableCall) {
                tmpInstr += this.processTaskRunnableCall((TaskRunnableCall)callSeqEntry);
                continue;
            }
            UniversalHandler.getInstance().logWarn("Unkown CallSequenceItem specialisation. Skipping...");
        }
        return tmpInstr;
    }

    private long processTaskRunnableCall(TaskRunnableCall taskRunnableCall) {
        Runnable runnable = taskRunnableCall.getRunnable();
        if (runnable == null) {
            UniversalHandler.getInstance().log("Invalid Software Model, reference to Runnable must not be empty. Skipping...", null);
            return 0L;
        }
        ++this.iRunnableCount;
        OMRunnable r = new OMRunnable(runnable);
        return r.getInstructionCount();
    }

    public String toString() {
        return this.taskRef.getUniqueName();
    }

    /*
     * Exception decompiling
     */
    public double calcRecursionFactor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl80 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl80 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

