/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.preferencePages;

import org.eclipse.app4mc.multicore.openmapping.OpenMappingPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class OpenMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button checkEnableLogCon;
    private Button radioOutputDefault;
    private Button radioOutputRel;
    private Button radioOutputAbs;
    private Button btnSelectOutput;
    private Text txtOutputLocation;
    private Label lOptionalOutputs;
    private Button checkGenerateMPS;
    private Label lMaxGap;
    private Label lMaxItAbort;
    private Label lMaxItSuffice;
    private Label lMaxTimeAbort;
    private Label lMaxTimeSuffice;
    private Text txtMaxGap;
    private Text txtMaxItAbort;
    private Text txtMaxItSuffice;
    private Text txtMaxTimeAbort;
    private Text txtMaxTimeSuffice;
    private Label lGapHint;
    private Label lSolverHint;
    private Button radioAlgorithm1;
    private Button radioAlgorithm2;
    private Button radioAlgorithm3;
    private Button radioAlgorithm4;

    public OpenMappingPreferencePage() {
    }

    public OpenMappingPreferencePage(String title) {
        super(title);
    }

    public OpenMappingPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(OpenMappingPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(final Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        GridLayout layout2row = new GridLayout(2, false);
        Group groupLog = new Group(parent, 16);
        groupLog.setText("Logging");
        groupLog.setLayoutData((Object)new GridData(768));
        groupLog.setLayout((Layout)layout);
        this.checkEnableLogCon = new Button((Composite)groupLog, 32);
        this.checkEnableLogCon.setText("Enable verbose logging to console");
        Group groupOutput = new Group(parent, 16);
        groupOutput.setText("Select output location");
        groupOutput.setLayoutData((Object)new GridData(768));
        groupOutput.setLayout((Layout)layout);
        this.radioOutputDefault = new Button((Composite)groupOutput, 16);
        this.radioOutputDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenMappingPreferencePage.this.getTextOutputLocation().setEnabled(false);
                OpenMappingPreferencePage.this.getBtnOutputLocation().setEnabled(false);
            }
        });
        this.radioOutputDefault.setText("Default location ({ProjectRoot}/output/)");
        this.radioOutputRel = new Button((Composite)groupOutput, 16);
        this.radioOutputRel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenMappingPreferencePage.this.getTextOutputLocation().setEnabled(true);
                OpenMappingPreferencePage.this.getBtnOutputLocation().setEnabled(false);
            }
        });
        this.radioOutputRel.setText("Custom location (relative to project root)");
        this.radioOutputAbs = new Button((Composite)groupOutput, 16);
        this.radioOutputAbs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenMappingPreferencePage.this.getTextOutputLocation().setEnabled(true);
                OpenMappingPreferencePage.this.getBtnOutputLocation().setEnabled(true);
            }
        });
        this.radioOutputAbs.setText("Custom location (absolute path)");
        this.txtOutputLocation = new Text((Composite)groupOutput, 2048);
        this.txtOutputLocation.setLayoutData((Object)new GridData(768));
        this.btnSelectOutput = new Button((Composite)groupOutput, 0);
        this.btnSelectOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = parent.getShell();
                DirectoryDialog dirDialog = new DirectoryDialog(shell);
                dirDialog.setText("Select the output directory");
                String sOutputLocation = dirDialog.open();
                if (sOutputLocation != null) {
                    OpenMappingPreferencePage.this.getTextOutputLocation().setText(sOutputLocation);
                }
            }
        });
        this.btnSelectOutput.setText("Select");
        Group groupAlgorithm = new Group(parent, 16);
        groupAlgorithm.setText("Select mapping algorithm");
        groupAlgorithm.setLayoutData((Object)new GridData(768));
        groupAlgorithm.setLayout((Layout)layout);
        this.radioAlgorithm1 = new Button((Composite)groupAlgorithm, 16);
        this.radioAlgorithm1.setText("Load balancing for DFG");
        this.radioAlgorithm2 = new Button((Composite)groupAlgorithm, 16);
        this.radioAlgorithm2.setText("ILP based load balancing");
        this.radioAlgorithm3 = new Button((Composite)groupAlgorithm, 16);
        this.radioAlgorithm3.setText("Energy efficient mapping (Experimental!)");
        this.radioAlgorithm4 = new Button((Composite)groupAlgorithm, 16);
        this.radioAlgorithm4.setText("GA based load balancing");
        Group groupSolverSettings = new Group(parent, 16);
        groupSolverSettings.setText("Solver Settings");
        groupSolverSettings.setLayoutData((Object)new GridData(768));
        groupSolverSettings.setLayout((Layout)layout2row);
        this.lOptionalOutputs = new Label((Composite)groupSolverSettings, 0);
        this.lOptionalOutputs.setText("Optional outputs");
        this.checkGenerateMPS = new Button((Composite)groupSolverSettings, 32);
        this.checkGenerateMPS.setText("Generate MPS file of ILP problem");
        this.lMaxGap = new Label((Composite)groupSolverSettings, 0);
        this.lMaxGap.setText("Max. Gap");
        this.txtMaxGap = new Text((Composite)groupSolverSettings, 2048);
        this.txtMaxGap.setLayoutData((Object)new GridData(768));
        new Label((Composite)groupSolverSettings, 0);
        this.lGapHint = new Label((Composite)groupSolverSettings, 0);
        this.lGapHint.setText("Valid values: 0.0 (best accuracy) - 1.0 (worst accuracy)");
        this.lMaxItAbort = new Label((Composite)groupSolverSettings, 0);
        this.lMaxItAbort.setText("Max. Iterations (Abort)");
        this.txtMaxItAbort = new Text((Composite)groupSolverSettings, 2048);
        this.txtMaxItAbort.setLayoutData((Object)new GridData(768));
        this.lMaxTimeAbort = new Label((Composite)groupSolverSettings, 0);
        this.lMaxTimeAbort.setText("Max. Time (Abort)");
        this.txtMaxTimeAbort = new Text((Composite)groupSolverSettings, 2048);
        this.txtMaxTimeAbort.setLayoutData((Object)new GridData(768));
        this.lMaxItSuffice = new Label((Composite)groupSolverSettings, 0);
        this.lMaxItSuffice.setText("Max. Iterations (Suffice)");
        this.txtMaxItSuffice = new Text((Composite)groupSolverSettings, 2048);
        this.txtMaxItSuffice.setLayoutData((Object)new GridData(768));
        this.lMaxTimeSuffice = new Label((Composite)groupSolverSettings, 0);
        this.lMaxTimeSuffice.setText("Max. Time (Suffice)");
        this.txtMaxTimeSuffice = new Text((Composite)groupSolverSettings, 2048);
        this.txtMaxTimeSuffice.setLayoutData((Object)new GridData(768));
        new Label((Composite)groupSolverSettings, 0);
        this.lSolverHint = new Label((Composite)groupSolverSettings, 0);
        this.lSolverHint.setText("Hint: Entering 0 will disable the constraint (i.e. set the value to INT_MAX).");
        this.initValues();
        return parent;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initDefaults();
    }

    public boolean performOk() {
        return this.storePreferences();
    }

    private boolean storePreferences() {
        boolean success = true;
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.app4mc.multicore.openmapping.logToConsole", this.checkEnableLogCon.getSelection());
        int d = 0;
        if (this.radioOutputDefault.getSelection()) {
            d = 0;
        } else if (this.radioOutputRel.getSelection()) {
            d = 1;
        } else if (this.radioOutputAbs.getSelection()) {
            d = 2;
        }
        store.setValue("org.eclipse.app4mc.multicore.openmapping.outputLocation", d);
        store.setValue("org.eclipse.app4mc.multicore.openmapping.outputLocationString", this.txtOutputLocation.getText());
        int c = 0;
        if (this.radioAlgorithm1.getSelection()) {
            c = 0;
        } else if (this.radioAlgorithm2.getSelection()) {
            c = 1;
        } else if (this.radioAlgorithm3.getSelection()) {
            c = 2;
        } else if (this.radioAlgorithm4.getSelection()) {
            c = 3;
        }
        store.setValue("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm", c);
        store.setValue("org.eclipse.app4mc.multicore.openmapping.generateMpsFile", this.checkGenerateMPS.getSelection());
        try {
            double fMaxGap = Double.parseDouble(this.txtMaxGap.getText());
            int iMaxItAbort = Integer.parseInt(this.txtMaxItAbort.getText());
            int iMaxTimeAbort = Integer.parseInt(this.txtMaxTimeAbort.getText());
            int iMaxItSuffice = Integer.parseInt(this.txtMaxItSuffice.getText());
            int iMaxTimeSuffice = Integer.parseInt(this.txtMaxTimeSuffice.getText());
            if (fMaxGap < 0.0 || fMaxGap > 1.0) {
                throw new NumberFormatException("Max. Gap must have a double value between 0.0 and 1.0");
            }
            if (iMaxItAbort < 0 || iMaxTimeAbort < 0 || iMaxItSuffice < 0 || iMaxTimeSuffice < 0) {
                throw new NumberFormatException("Max. Iterations and Max. Time must have values between 0 and 2147483647");
            }
            store.setValue("org.eclipse.app4mc.multicore.openmapping.MaxGap", fMaxGap);
            store.setValue("org.eclipse.app4mc.multicore.openmapping.MaxItAbort", iMaxItAbort);
            store.setValue("org.eclipse.app4mc.multicore.openmapping.MaxTimeAbort", iMaxTimeAbort);
            store.setValue("org.eclipse.app4mc.multicore.openmapping.MaxItSuffice", iMaxItSuffice);
            store.setValue("org.eclipse.app4mc.multicore.openmapping.MaxTimeSuffice", iMaxTimeSuffice);
        }
        catch (NumberFormatException e) {
            success = false;
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Incorrect values in Solver Settings section:\n" + e.getMessage()));
        }
        return success;
    }

    private void initDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.checkEnableLogCon.setSelection(store.getDefaultBoolean("org.eclipse.app4mc.multicore.openmapping.logToConsole"));
        this.radioOutputDefault.setSelection(false);
        this.radioOutputRel.setSelection(false);
        this.radioOutputAbs.setSelection(false);
        int radioOutputChoice = store.getDefaultInt("org.eclipse.app4mc.multicore.openmapping.outputLocation");
        switch (radioOutputChoice) {
            case 0: {
                this.radioOutputDefault.setSelection(true);
                this.txtOutputLocation.setEnabled(false);
                this.btnSelectOutput.setEnabled(false);
                break;
            }
            case 1: {
                this.radioOutputRel.setSelection(true);
                this.txtOutputLocation.setEnabled(true);
                this.btnSelectOutput.setEnabled(false);
                break;
            }
            case 2: {
                this.radioOutputAbs.setSelection(true);
                this.txtOutputLocation.setEnabled(true);
                this.btnSelectOutput.setEnabled(true);
                break;
            }
        }
        this.txtOutputLocation.setText(store.getDefaultString("org.eclipse.app4mc.multicore.openmapping.outputLocationString"));
        this.radioAlgorithm1.setSelection(false);
        this.radioAlgorithm2.setSelection(false);
        this.radioAlgorithm3.setSelection(false);
        this.radioAlgorithm4.setSelection(false);
        int radioAlgorithmChoice = store.getDefaultInt("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm");
        switch (radioAlgorithmChoice) {
            case 0: {
                this.radioAlgorithm1.setSelection(true);
                break;
            }
            case 1: {
                this.radioAlgorithm2.setSelection(true);
                break;
            }
            case 2: {
                this.radioAlgorithm3.setSelection(true);
                break;
            }
            case 3: {
                this.radioAlgorithm4.setSelection(true);
                break;
            }
        }
        this.checkGenerateMPS.setSelection(store.getDefaultBoolean("org.eclipse.app4mc.multicore.openmapping.generateMpsFile"));
        this.txtMaxGap.setText("" + store.getDefaultDouble("org.eclipse.app4mc.multicore.openmapping.MaxGap"));
        this.txtMaxItAbort.setText("" + store.getDefaultInt("org.eclipse.app4mc.multicore.openmapping.MaxItAbort"));
        this.txtMaxTimeAbort.setText("" + store.getDefaultInt("org.eclipse.app4mc.multicore.openmapping.MaxTimeAbort"));
        this.txtMaxItSuffice.setText("" + store.getDefaultInt("org.eclipse.app4mc.multicore.openmapping.MaxItSuffice"));
        this.txtMaxTimeSuffice.setText("" + store.getDefaultInt("org.eclipse.app4mc.multicore.openmapping.MaxTimeSuffice"));
    }

    private void initValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.checkEnableLogCon.setSelection(store.getBoolean("org.eclipse.app4mc.multicore.openmapping.logToConsole"));
        this.radioOutputDefault.setSelection(false);
        this.radioOutputRel.setSelection(false);
        this.radioOutputAbs.setSelection(false);
        int radioOutputChoice = store.getInt("org.eclipse.app4mc.multicore.openmapping.outputLocation");
        switch (radioOutputChoice) {
            case 0: {
                this.radioOutputDefault.setSelection(true);
                this.txtOutputLocation.setEnabled(false);
                this.btnSelectOutput.setEnabled(false);
                break;
            }
            case 1: {
                this.radioOutputRel.setSelection(true);
                this.txtOutputLocation.setEnabled(true);
                this.btnSelectOutput.setEnabled(false);
                break;
            }
            case 2: {
                this.radioOutputAbs.setSelection(true);
                this.txtOutputLocation.setEnabled(true);
                this.btnSelectOutput.setEnabled(true);
                break;
            }
        }
        this.txtOutputLocation.setText(store.getString("org.eclipse.app4mc.multicore.openmapping.outputLocationString"));
        int radioAlgorithmChoice = store.getInt("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm");
        switch (radioAlgorithmChoice) {
            case 0: {
                this.radioAlgorithm1.setSelection(true);
                break;
            }
            case 1: {
                this.radioAlgorithm2.setSelection(true);
                break;
            }
            case 2: {
                this.radioAlgorithm3.setSelection(true);
                break;
            }
            case 3: {
                this.radioAlgorithm4.setSelection(true);
                break;
            }
        }
        this.checkGenerateMPS.setSelection(store.getBoolean("org.eclipse.app4mc.multicore.openmapping.generateMpsFile"));
        this.txtMaxGap.setText("" + store.getDouble("org.eclipse.app4mc.multicore.openmapping.MaxGap"));
        this.txtMaxItAbort.setText("" + store.getInt("org.eclipse.app4mc.multicore.openmapping.MaxItAbort"));
        this.txtMaxTimeAbort.setText("" + store.getInt("org.eclipse.app4mc.multicore.openmapping.MaxTimeAbort"));
        this.txtMaxItSuffice.setText("" + store.getInt("org.eclipse.app4mc.multicore.openmapping.MaxItSuffice"));
        this.txtMaxTimeSuffice.setText("" + store.getInt("org.eclipse.app4mc.multicore.openmapping.MaxTimeSuffice"));
    }

    public Text getTextOutputLocation() {
        return this.txtOutputLocation;
    }

    public Button getBtnOutputLocation() {
        return this.btnSelectOutput;
    }
}

