/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.sharedlibs;

import org.apache.log4j.Logger;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ConsoleOutputHandler {
    private final String name;
    private final MessageConsole console;
    private MessageConsoleStream outStream;
    private final Logger log = Logger.getLogger((String)"org.eclipse.app4mc.multicore.openmapping");

    public ConsoleOutputHandler(String name) {
        this.name = name;
        this.console = this.fetchConsole();
        if (this.console != null) {
            this.outStream = this.console.newMessageStream();
        }
    }

    private MessageConsole fetchConsole() {
        try {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            IConsole[] allConsoles = conMan.getConsoles();
            int i = 0;
            while (i < allConsoles.length) {
                if (this.name.equals(allConsoles[i].getName())) {
                    return (MessageConsole)allConsoles[i];
                }
                ++i;
            }
            MessageConsole newConsole = new MessageConsole(this.name, null);
            conMan.addConsoles(new IConsole[]{newConsole});
            return newConsole;
        }
        catch (NullPointerException nullPointerException) {
            this.log.info((Object)"No Eclipse console available, using default output!");
            return null;
        }
    }

    public void append(String text) {
        if (this.outStream != null) {
            this.outStream.print(text);
        } else {
            this.log.info((Object)text);
        }
    }

    public void appendln(String text) {
        if (this.outStream != null) {
            this.outStream.println(text);
        } else {
            this.log.info((Object)text);
        }
    }

    public void clear() {
        if (this.console != null) {
            this.console.clearConsole();
        }
    }

    public void focus() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            try {
                IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                view.display((IConsole)this.console);
                view.setScrollLock(false);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        catch (NullPointerException nullPointerException) {
            this.log.debug((Object)"focus: No Eclipse workbench available, nothing to do!");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.log.debug((Object)"focus: No Eclipse workbench available, nothing to do!");
        }
    }
}

