/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.sharedlibs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.ComponentsModel;
import org.eclipse.app4mc.amalthea.model.ConfigModel;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.EventModel;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.sphinx.AmaltheaResourceFactory;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class UniversalHandler {
    private boolean verboseOutputEnable = false;
    private String pluginId = "ERR_PLUGINID_UNSET";
    private ILog iLog;
    private Logger aLog;
    private CommonElements commonElements;
    private SWModel swModel;
    private HWModel hwModel;
    private ConstraintsModel conModel;
    private OSModel osModel;
    private StimuliModel stiModel;
    private MappingModel mmModel;
    private PropertyConstraintsModel pcModel;
    private EventModel evModel;
    private ConfigModel confModel;
    private ComponentsModel comModel;
    private final Map<String, EObject> cache = new HashMap<String, EObject>();
    private final Map<URI, Resource> cache2 = new HashMap<URI, Resource>();

    public static UniversalHandler getInstance() {
        return UniversalHandlerHolder.UH_INSTANCE;
    }

    UniversalHandler() {
        try {
            AmaltheaPackage.eINSTANCE.eClass();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readModels(URI uri, boolean copyModel) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("amxmi", new AmaltheaResourceFactory());
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
        try {
            Resource res = resSet.createResource(uri);
            res.load(null);
            Object content = copyModel ? copier.copyAll((Collection)res.getContents()) : res.getContents();
            this.setModel((Collection<EObject>)content);
        }
        catch (IOException | WrappedException e) {
            e.printStackTrace();
        }
        if (copyModel) {
            copier.copyReferences();
        }
    }

    public void writeModel(URI uri, EObject model) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("amxmi", new AmaltheaResourceFactory());
        resSet.setURIResourceMap(this.cache2);
        Resource resource = resSet.createResource(uri);
        ((ResourceImpl)resource).setIntrinsicIDToEObjectMap(this.cache);
        IFile outFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toString()));
        File parentFolder = new File(outFile.getParent().getFullPath().toOSString());
        parentFolder.mkdirs();
        try {
            resource.getContents().add((Object)model);
            resource.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeModel(URI uri, ArrayList<EObject> models) {
        Amalthea containerModel = AmaltheaFactory.eINSTANCE.createAmalthea();
        for (EObject model : models) {
            if (model instanceof CommonElements) {
                containerModel.setCommonElements((CommonElements)model);
                continue;
            }
            if (model instanceof SWModel) {
                containerModel.setSwModel((SWModel)model);
                continue;
            }
            if (model instanceof HWModel) {
                containerModel.setHwModel((HWModel)model);
                continue;
            }
            if (model instanceof ConstraintsModel) {
                containerModel.setConstraintsModel((ConstraintsModel)model);
                continue;
            }
            if (model instanceof MappingModel) {
                containerModel.setMappingModel((MappingModel)model);
                continue;
            }
            if (model instanceof StimuliModel) {
                containerModel.setStimuliModel((StimuliModel)model);
                continue;
            }
            if (model instanceof OSModel) {
                containerModel.setOsModel((OSModel)model);
                continue;
            }
            if (model instanceof PropertyConstraintsModel) {
                containerModel.setPropertyConstraintsModel((PropertyConstraintsModel)model);
                continue;
            }
            if (model instanceof EventModel) {
                containerModel.setEventModel((EventModel)model);
                continue;
            }
            if (model instanceof ComponentsModel) {
                containerModel.setComponentsModel((ComponentsModel)model);
                continue;
            }
            if (!(model instanceof ConfigModel)) continue;
            containerModel.setConfigModel((ConfigModel)model);
        }
        this.writeModel(uri, (EObject)containerModel);
    }

    public void logCon(String message) {
        if (this.verboseOutputEnable) {
            System.out.println(message);
        }
    }

    public void log(String message) {
        this.log(message, null, 1);
    }

    public void logWarn(String message) {
        this.log(message, null, 2);
    }

    public void log(String message, Exception e) {
        this.log(message, e, 4);
    }

    public void log(String message, Exception e, int severity) {
        this.logCon(message);
        if (this.getLog() == null) {
            if (this.aLog == null) {
                this.aLog = Logger.getLogger((String)this.pluginId);
            }
            switch (severity) {
                case 0: 
                case 1: 
                case 2: {
                    this.aLog.info((Object)message);
                    break;
                }
                case 4: 
                case 8: {
                    this.aLog.error((Object)message);
                }
            }
            if (e != null) {
                this.aLog.error((Object)("Exception: " + e));
            }
        } else {
            this.getLog().log((IStatus)new Status(severity, this.getPluginId(), 0, message, (Throwable)e));
        }
    }

    private Object getSelection(ExecutionEvent event) {
        IStructuredSelection ssel = (IStructuredSelection)HandlerUtil.getActiveSite((ExecutionEvent)event).getSelectionProvider().getSelection();
        if (ssel == null) {
            return null;
        }
        return ssel.getFirstElement();
    }

    public IFile getSelectedFile(ExecutionEvent event) {
        Object selection = this.getSelection(event);
        if (selection instanceof IFile) {
            IFile file = (IFile)selection;
            this.logCon("Selected file: " + file.getFullPath());
            return file;
        }
        return null;
    }

    public URI getProjectDir(ExecutionEvent event) {
        Object selection = this.getSelection(event);
        if (!(selection instanceof IResource)) {
            return null;
        }
        IResource file = (IResource)selection;
        String projectDir = file.getProject().getLocationURI().toString();
        this.logCon("Project Directory: " + projectDir);
        return URI.createURI((String)projectDir);
    }

    public void enableVerboseOutput() {
        this.verboseOutputEnable = true;
    }

    public void setPluginId(String pluginId) {
        this.aLog = Logger.getLogger((String)pluginId);
        this.pluginId = pluginId;
    }

    public void setLog(ILog log) {
        if (log != null) {
            this.iLog = log;
        }
    }

    private String getPluginId() {
        return this.pluginId;
    }

    private ILog getLog() {
        return this.iLog;
    }

    private void setModel(Collection<EObject> content) {
        if (content == null) {
            return;
        }
        for (EObject model : content) {
            if (model instanceof CommonElements) {
                this.commonElements = (CommonElements)model;
                continue;
            }
            if (model instanceof SWModel) {
                this.swModel = (SWModel)model;
                continue;
            }
            if (model instanceof HWModel) {
                this.hwModel = (HWModel)model;
                continue;
            }
            if (model instanceof ConstraintsModel) {
                this.conModel = (ConstraintsModel)model;
                continue;
            }
            if (model instanceof MappingModel) {
                this.mmModel = (MappingModel)model;
                continue;
            }
            if (model instanceof StimuliModel) {
                this.stiModel = (StimuliModel)model;
                continue;
            }
            if (model instanceof OSModel) {
                this.osModel = (OSModel)model;
                continue;
            }
            if (model instanceof PropertyConstraintsModel) {
                this.pcModel = (PropertyConstraintsModel)model;
                continue;
            }
            if (model instanceof EventModel) {
                this.evModel = (EventModel)model;
                continue;
            }
            if (model instanceof ConfigModel) {
                this.confModel = (ConfigModel)model;
                continue;
            }
            if (model instanceof ComponentsModel) {
                this.comModel = (ComponentsModel)model;
                continue;
            }
            if (!(model instanceof Amalthea)) continue;
            this.setModel((Collection<EObject>)((Amalthea)model).eContents());
        }
    }

    public CommonElements getCommonElements() {
        return this.commonElements;
    }

    public SWModel getSwModel() {
        return this.swModel;
    }

    public HWModel getHwModel() {
        return this.hwModel;
    }

    public ConstraintsModel getConstraintsModel() {
        return this.conModel;
    }

    public OSModel getOsModel() {
        return this.osModel;
    }

    public StimuliModel getStimuliModel() {
        return this.stiModel;
    }

    public MappingModel getMappingModel() {
        return this.mmModel;
    }

    public PropertyConstraintsModel getPropertyConstraintsModel() {
        return this.pcModel;
    }

    public EventModel getEvModel() {
        return this.evModel;
    }

    public ConfigModel getConfModel() {
        return this.confModel;
    }

    public ComponentsModel getComModel() {
        return this.comModel;
    }

    public void dropCache() {
        this.commonElements = null;
        this.swModel = null;
        this.hwModel = null;
        this.conModel = null;
        this.osModel = null;
        this.stiModel = null;
        this.mmModel = null;
        this.pcModel = null;
        this.evModel = null;
        this.comModel = null;
        this.confModel = null;
    }

    private static class UniversalHandlerHolder {
        public static final UniversalHandler UH_INSTANCE = new UniversalHandler();

        private UniversalHandlerHolder() {
        }
    }
}

