/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.visualizer;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.eclipse.app4mc.multicore.openmapping.model.OMAllocation;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMMapping;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;

public class OMVisualizer {
    private final OMMapping mapping;
    private final Map<OMCore, CoreElement> allCores = new HashMap<OMCore, CoreElement>();

    public OMVisualizer(OMMapping mapping) {
        this.mapping = mapping;
    }

    public String getASCIIChart() {
        if (this.allCores.size() <= 0) {
            this.fillCache();
        }
        OptionalLong lMaxComputationTime = this.allCores.values().parallelStream().mapToLong(CoreElement::getComputationTime).max();
        assert (lMaxComputationTime != null);
        String output = "+---------------------------------------+-------------------------------------------------+-----------------+------------------------+\n";
        output = String.valueOf(output) + "| Core              (#Tasks/#Runnables) | Utilization                        (Percentage) | Cycles          | Time (round to 5 fig.) |\n";
        output = String.valueOf(output) + "+---------------------------------------+-------------------------------------------------+-----------------+------------------------+\n";
        for (Map.Entry<OMCore, CoreElement> e : this.allCores.entrySet()) {
            String name = String.format("%-26s", e.getKey().getCoreRef().getUniqueName());
            String tasks = String.format("%3d", e.getValue().getTaskList().size());
            String runnables = String.format("%4d", e.getValue().getScheduledRunnableCount());
            String utilization = this.drawUtilizationBar(e.getValue().getComputationTime(), lMaxComputationTime.getAsLong());
            String cycles = String.format("%-,15d", e.getValue().getScheduledInstructionCount());
            String percentage = String.format("(%3d%%)", (int)(100.0 / (double)lMaxComputationTime.getAsLong() * (double)e.getValue().getComputationTime()));
            String compurationTime = String.format("%,19.5f \ufffds", (double)e.getValue().getComputationTime() / 1000000.0);
            output = String.valueOf(output) + String.format("| %s (%s/%s) | %s %s | %s | %s |\n", name, tasks, runnables, utilization, percentage, cycles, compurationTime);
        }
        output = String.valueOf(output) + "+---------------------------------------+-------------------------------------------------+-----------------+------------------------+\n";
        return output;
    }

    private String drawUtilizationBar(long lComputationTime, long lMaxComputationTime) {
        double curUtilPercentage = 1.0 / (double)lMaxComputationTime * (double)lComputationTime;
        int curUtilAbs = (int)(curUtilPercentage * 40.0);
        String output = "";
        int i = 0;
        while (i < 40) {
            output = i <= curUtilAbs ? String.valueOf(output) + "X" : String.valueOf(output) + " ";
            ++i;
        }
        return output;
    }

    private void fillCache() {
        assert (this.mapping.getAllocationList().size() > 0);
        for (OMAllocation allocation : this.mapping.getAllocationList()) {
            CoreElement c;
            OMCore core = allocation.getCore();
            OMTask task = allocation.getTask();
            if (!this.allCores.containsKey(core)) {
                c = new CoreElement(allocation.getCore());
                c.addTask(task);
                this.allCores.put(core, c);
                continue;
            }
            c = this.allCores.get(core);
            c.addTask(task);
        }
    }

    private class CoreElement {
        final OMCore coreRef;
        List<OMTask> tasks = new LinkedList<OMTask>();
        long iScheduledInstructionCount = -1L;
        long iScheduledRunnableCount = -1L;
        long iComputationTime = -1L;

        CoreElement(OMCore core) {
            this.coreRef = core;
        }

        public void addTask(OMTask task) {
            this.tasks.add(task);
        }

        public List<OMTask> getTaskList() {
            return this.tasks;
        }

        public long getScheduledInstructionCount() {
            if (0L > this.iScheduledInstructionCount) {
                this.iScheduledInstructionCount = (long)Math.ceil(this.tasks.parallelStream().mapToDouble(t -> (double)t.getInstructionCount() / t.calcRecursionFactor()).sum());
            }
            return this.iScheduledInstructionCount;
        }

        public long getScheduledRunnableCount() {
            if (0L > this.iScheduledRunnableCount) {
                this.iScheduledRunnableCount = this.tasks.parallelStream().mapToLong(OMTask::getRunnableCount).sum();
            }
            return this.iScheduledRunnableCount;
        }

        public long getComputationTime() {
            if (0L > this.iComputationTime) {
                BigInteger ips = BigInteger.valueOf(this.getCoreRef().getInstructionsPerSecond());
                BigInteger ins = BigInteger.valueOf(this.getScheduledInstructionCount());
                BigInteger psps = BigInteger.valueOf(1000000000000L);
                BigInteger computationTime = psps.multiply(ins).divide(ips);
                this.iComputationTime = computationTime.longValueExact();
            }
            return this.iComputationTime;
        }

        public OMCore getCoreRef() {
            return this.coreRef;
        }
    }
}

