/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.workflow;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.amalthea.workflow.core.exception.ConfigurationException;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ga.lb.GABasedLoadBalancing;
import org.eclipse.app4mc.multicore.openmapping.algorithms.heuristic.lb.LoadBalancingDFG;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.EnergyMinimization;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.lb.ILPBasedLoadBalancing;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;

public class GenerateMapping
extends WorkflowComponent {
    private static final String MAPPING_DFG = "dfg";
    private static final String MAPPING_ILP_LB = "ilp_lb";
    private static final String MAPPING_ILP_ENERGY = "ilp_energy";
    private static final String MAPPING_GA_LB = "ga_lb";
    private String resultSlot = "mapping";
    private String mappingAlg;
    private boolean enableLog = false;

    protected void runInternal(Context ctx) {
        assert (this.getAmaltheaModel(ctx).getHwModel() != null && this.getAmaltheaModel(ctx).getSwModel() != null);
        if (this.isEnableLog()) {
            UniversalHandler.getInstance().enableVerboseOutput();
        }
        AbstractMappingAlgorithm mappingAlg = null;
        if (this.getMappingAlg().equals(MAPPING_DFG)) {
            this.log.info((Object)"Using DFG Algorithm...");
            mappingAlg = new LoadBalancingDFG();
        } else if (this.getMappingAlg().equals(MAPPING_ILP_LB)) {
            this.log.info((Object)"Using ILP Load Balancing Algorithm...");
            mappingAlg = new ILPBasedLoadBalancing();
        } else if (this.getMappingAlg().equals(MAPPING_ILP_ENERGY)) {
            this.log.info((Object)"Using ILP Energy Minimization Algorithm...");
            mappingAlg = new EnergyMinimization();
        } else if (this.getMappingAlg().equals(MAPPING_GA_LB)) {
            this.log.info((Object)"Using GA Load Balancing Algorithm...");
            mappingAlg = new GABasedLoadBalancing();
        }
        Amalthea modelCopy = this.getAmaltheaModelCopy(ctx);
        if (modelCopy.getConstraintsModel() != null) {
            mappingAlg.setConnstraintsModel(modelCopy.getConstraintsModel());
        }
        mappingAlg.setHwModel(modelCopy.getHwModel());
        mappingAlg.setSwModel(modelCopy.getSwModel());
        mappingAlg.calculateMapping();
        assert (mappingAlg.getOsModel() != null && mappingAlg.getMappingModel() != null);
        modelCopy.setOsModel(mappingAlg.getOsModel());
        modelCopy.setMappingModel(mappingAlg.getMappingModel());
        this.log.info((Object)("Setting result model in slot: " + this.getResultSlot()));
        ctx.set(this.getResultSlot(), (Object)modelCopy);
    }

    protected void checkInternal() throws ConfigurationException {
        if (this.getMappingAlg() == null || this.getMappingAlg().isEmpty() || !this.getMappingAlg().equals(MAPPING_DFG) && !this.getMappingAlg().equals(MAPPING_ILP_LB) && !this.getMappingAlg().equals(MAPPING_ILP_ENERGY) && !this.getMappingAlg().equals(MAPPING_GA_LB)) {
            throw new ConfigurationException("No proper mapping algorithm defined! Please define one of the following values: dfg,ilp_lb,ilp_energy,ga_lb");
        }
    }

    public String getResultSlot() {
        return this.resultSlot;
    }

    public void setResultSlot(String resultSlot) {
        this.resultSlot = resultSlot;
    }

    public String getMappingAlg() {
        return this.mappingAlg;
    }

    public void setMappingAlg(String mappingAlg) {
        this.mappingAlg = mappingAlg;
    }

    public boolean isEnableLog() {
        return this.enableLog;
    }

    public void setEnableLog(boolean enableLog) {
        this.enableLog = enableLog;
    }
}

