/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.algorithms.GGP;
import org.eclipse.app4mc.multicore.partitioning.algorithms.Helper;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartLog;
import org.eclipse.app4mc.multicore.partitioning.algorithms.Path;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.alg.cycle.SzwarcfiterLauerSimpleCycles;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;

public class CriticalPath {
    private final DirectedAcyclicGraph<Runnable, RunnableSequencingConstraint> graph;
    private final SWModel swm;
    private final ConstraintsModel cm;
    private Path cp;
    private final Map<Runnable, tf> cache = new HashMap<Runnable, tf>();
    private final HashMap<Runnable, Long> rtl = new HashMap();
    private final HashMap<Runnable, Long> srtl = new HashMap();

    public CriticalPath(SWModel swm, ConstraintsModel cm) {
        this.swm = swm;
        this.cm = cm;
        this.graph = this.createJGraphT();
        this.rtlinit();
    }

    private DirectedAcyclicGraph<Runnable, RunnableSequencingConstraint> createJGraphT() {
        DirectedAcyclicGraph test = new DirectedAcyclicGraph(null);
        for (Runnable r : this.swm.getRunnables()) {
            test.addVertex((Object)r);
        }
        for (RunnableSequencingConstraint rsc : this.cm.getRunnableSequencingConstraints()) {
            try {
                test.addDagEdge((Object)((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)), (Object)((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)), (Object)rsc);
            }
            catch (DirectedAcyclicGraph.CycleFoundException cycleFoundException) {}
        }
        return test;
    }

    public tf getTF(Runnable r) {
        return this.cache.get(r);
    }

    public EList<Runnable> getCP() {
        Path cpt;
        if (this.swm.getProcessPrototypes().size() == 0) {
            AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
            ProcessPrototype pp = swf.createProcessPrototype();
            for (Runnable r : this.swm.getRunnables()) {
                TaskRunnableCall trc = swf.createTaskRunnableCall();
                trc.setRunnable(r);
                pp.getRunnableCalls().add((Object)trc);
            }
            this.swm.getProcessPrototypes().add((Object)pp);
        }
        this.cp = cpt = this.getCrPa();
        this.updateCacheTFs();
        return this.sortRunnables(cpt.getRunnablesL());
    }

    private EList<Runnable> sortRunnables(EList<Runnable> rl) {
        Collections.sort(rl, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                return (int)CriticalPath.this.getTF((Runnable)o1).eit - (int)CriticalPath.this.getTF((Runnable)o2).eit;
            }
        });
        return rl;
    }

    public String getPathString(EList<Runnable> p) {
        String str = "";
        for (Runnable r : p) {
            str = String.valueOf(str) + r.getName() + "(" + this.getTFString(r) + ") ";
        }
        return str;
    }

    private String getTFString(Runnable r) {
        tf TF = this.cache.get(r);
        return String.valueOf(TF.eit) + " " + TF.lit;
    }

    /*
     * WARNING - void declaration
     */
    private Path getCrPa() {
        void var5_9;
        SzwarcfiterLauerSimpleCycles slsc = new SzwarcfiterLauerSimpleCycles();
        slsc.setGraph(this.graph);
        CycleDetector cd = new CycleDetector(this.graph);
        if (cd.detectCycles()) {
            PartLog.getInstance().log("THERE ARE STILL CYCLES", null);
            return null;
        }
        LinkedList<Object> sinks = new LinkedList();
        sinks = new GGP(this.swm, this.cm, this.graph).getSinks();
        HashMap<Runnable, Long> rts = new HashMap<Runnable, Long>();
        for (Runnable runnable : sinks) {
            rts.put(runnable, this.getLongestPreceedingRT(runnable));
        }
        Object var5_8 = null;
        long max = 0L;
        for (Runnable r : rts.keySet()) {
            if ((Long)rts.get(r) <= max) continue;
            max = (Long)rts.get(r);
            Runnable runnable = r;
        }
        assert (var5_9 != null);
        Path cpt = new Path();
        this.cp = cpt = this.getPrecedingCriticalPath((Runnable)var5_9);
        this.cp.updateRunTime();
        return cpt;
    }

    private Path getPrecedingCriticalPath(Runnable cps) {
        Path p = new Path();
        p.getRunnables().add(cps);
        long time = this.rtl.get(cps) - new Helper().getInstructions(cps);
        while (time > 0L) {
            Set iel = this.graph.incomingEdgesOf((Object)cps);
            long temp = time;
            for (RunnableSequencingConstraint rsc : iel) {
                Runnable source = (Runnable)this.graph.getEdgeSource((Object)rsc);
                if (this.rtl.get(source) != time) continue;
                p.getRunnables().add(source);
                cps = source;
                time -= new Helper().getInstructions(cps);
                break;
            }
            if (temp != time) continue;
            PartLog.getInstance().log("no preceeding runnable found. TIME " + time, null);
            break;
        }
        return p;
    }

    public long getPathLength(EList<Runnable> rl) {
        long length = 0L;
        for (Runnable r : rl) {
            length += new Helper().getInstructions(r);
        }
        return length;
    }

    public long getPathLength() {
        long length = 0L;
        for (Runnable r : this.cp.getRunnablesL()) {
            length += new Helper().getInstructions(r);
        }
        return length;
    }

    private void updateCacheTFs() {
        this.initSrtl();
        for (Runnable run : this.swm.getRunnables()) {
            tf TF = new tf(0L, 0L);
            TF.eit = this.rtl.get(run) - new Helper().getInstructions(run);
            TF.lit = this.cp.runtime - this.getLongestSuceedingRT(run);
            this.cache.put(run, TF);
        }
    }

    private void rtlinit() {
        for (Runnable r : this.swm.getRunnables()) {
            this.rtl.put(r, 0L);
        }
    }

    public long getLongestPreceedingRT(Runnable r) {
        assert (this.graph != null);
        long rt = 0L;
        if (this.graph.incomingEdgesOf((Object)r).size() == 0) {
            rt = new Helper().getInstructions(r);
            this.rtl.put(r, rt);
            return rt;
        }
        Iterator i = this.graph.incomingEdgesOf((Object)r).iterator();
        HashSet<Long> rts = new HashSet<Long>();
        while (i.hasNext()) {
            RunnableSequencingConstraint rscTemp = (RunnableSequencingConstraint)i.next();
            Runnable source = (Runnable)this.graph.getEdgeSource((Object)rscTemp);
            if (new Helper().getPPfromR(r, this.swm) != null && new Helper().getPPfromR(source, this.swm) != null && new Helper().getPPfromR(r, this.swm).equals(new Helper().getPPfromR(source, this.swm))) {
                if (this.rtl.get(source) == 0L) {
                    rts.add(this.getLongestPreceedingRT(source));
                    continue;
                }
                rts.add(this.rtl.get(source));
                continue;
            }
            if (new Helper().getPPfromR(r, this.swm) != null && new Helper().getPPfromR(source, this.swm) != null) continue;
            PartLog.getInstance().log("No ProcessPrototype for Runnable " + r.getName() + " or " + source.getName(), null);
        }
        Iterator iterator = rts.iterator();
        while (iterator.hasNext()) {
            long rtc = (Long)iterator.next();
            if (rt >= rtc) continue;
            rt = rtc;
        }
        long rtt = rt + new Helper().getInstructions(r);
        this.rtl.put(r, rtt);
        return rtt;
    }

    private void initSrtl() {
        for (Runnable r : this.swm.getRunnables()) {
            this.srtl.put(r, 0L);
        }
    }

    private long getLongestSuceedingRT(Runnable r) {
        long rt = 0L;
        if (this.graph.outgoingEdgesOf((Object)r).size() == 0) {
            rt = new Helper().getInstructions(r);
            this.srtl.put(r, rt);
            return rt;
        }
        Iterator i = this.graph.outgoingEdgesOf((Object)r).iterator();
        HashSet<Long> outgoingEdges = new HashSet<Long>();
        while (i.hasNext()) {
            RunnableSequencingConstraint rscTemp = (RunnableSequencingConstraint)i.next();
            Runnable target = (Runnable)this.graph.getEdgeTarget((Object)rscTemp);
            if (new Helper().getPPfromR(r, this.swm) == null || new Helper().getPPfromR(target, this.swm) == null || !new Helper().getPPfromR(r, this.swm).equals(new Helper().getPPfromR(target, this.swm))) continue;
            if (this.srtl.get(target) == 0L) {
                outgoingEdges.add(this.getLongestSuceedingRT(target));
                continue;
            }
            outgoingEdges.add(this.srtl.get(target));
        }
        Iterator iterator = outgoingEdges.iterator();
        while (iterator.hasNext()) {
            long rtc = (Long)iterator.next();
            if (rt >= rtc) continue;
            rt = rtc;
        }
        long rtt = rt + new Helper().getInstructions(r);
        this.srtl.put(r, rtt);
        return rtt;
    }

    public DirectedAcyclicGraph<Runnable, RunnableSequencingConstraint> getGraph() {
        return this.graph;
    }

    public Map<Runnable, tf> getCache() {
        return this.cache;
    }

    class tf {
        long eit = 0L;
        long lit = 0L;

        public tf(long eit, long lit) {
            this.eit = eit;
            this.lit = lit;
        }
    }
}

