/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceType;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.algorithms.Cycle;
import org.eclipse.app4mc.multicore.partitioning.algorithms.Helper;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.alg.cycle.TarjanSimpleCycles;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DirectedSubgraph;

public class CycleElimination {
    private final SWModel swm;
    private final ConstraintsModel cm;
    private boolean minimialEdgeElim = false;
    private boolean efficientEdgeInCycle = false;

    public CycleElimination(SWModel swm, ConstraintsModel cm) {
        this.swm = swm;
        this.cm = cm;
    }

    public SWModel getSwm() {
        return this.swm;
    }

    public ConstraintsModel getCm() {
        return this.cm;
    }

    public boolean containsCycles() {
        DirectedGraph<Runnable, RunnableSequencingConstraint> graph = this.createJGraphT();
        CycleDetector cd = new CycleDetector(graph);
        return cd.detectCycles();
    }

    public DirectedGraph<Runnable, RunnableSequencingConstraint> createJGraphT() {
        if (this.swm.getRunnables() == null || this.cm.getRunnableSequencingConstraints() == null) {
            return null;
        }
        DefaultDirectedWeightedGraph test = new DefaultDirectedWeightedGraph(RunnableSequencingConstraint.class);
        for (Runnable r : this.swm.getRunnables()) {
            test.addVertex((Object)r);
        }
        for (RunnableSequencingConstraint rsc : this.cm.getRunnableSequencingConstraints()) {
            if (((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0) == null || ((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0) == null) continue;
            test.addEdge((Object)((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)), (Object)((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)), (Object)rsc);
        }
        return test;
    }

    public void setparams(boolean efficientEdgeInCycle, boolean minimalEdgeDis) {
        this.setEfficientEdgeInCycle(efficientEdgeInCycle);
        this.setMinimialEdgeElim(minimalEdgeDis);
    }

    public void setparams(IPreferenceStore s) {
        this.setEfficientEdgeInCycle(s.getBoolean("boolEffEdge"));
        this.setMinimialEdgeElim(s.getBoolean("boolMinEdges"));
    }

    private List<DirectedSubgraph<Runnable, RunnableSequencingConstraint>> convertSimpleCycleToSubGraph(List<List<Runnable>> scycles, DirectedGraph<Runnable, RunnableSequencingConstraint> graph) {
        BasicEList cycles = new BasicEList();
        for (List<Runnable> cycle : scycles) {
            HashSet<RunnableSequencingConstraint> edgeSubset = new HashSet<RunnableSequencingConstraint>();
            int i = 0;
            while (i < cycle.size()) {
                if (i == cycle.size() - 1) {
                    edgeSubset.add((RunnableSequencingConstraint)graph.getEdge((Object)cycle.get(i), (Object)cycle.get(0)));
                } else {
                    edgeSubset.add((RunnableSequencingConstraint)graph.getEdge((Object)cycle.get(i), (Object)cycle.get(i + 1)));
                }
                ++i;
            }
            HashSet<Runnable> vertexSet = new HashSet<Runnable>();
            for (Runnable r : cycle) {
                vertexSet.add(r);
            }
            DirectedSubgraph dsg = new DirectedSubgraph(graph, vertexSet, edgeSubset);
            cycles.add(dsg);
        }
        return cycles;
    }

    private List<DirectedSubgraph<Runnable, RunnableSequencingConstraint>> removeRSC(DirectedGraph<Runnable, RunnableSequencingConstraint> graph, List<DirectedSubgraph<Runnable, RunnableSequencingConstraint>> cycles, RunnableSequencingConstraint rsc) {
        PartLog.getInstance().log("RSC to be converted to AccessPrecedence: " + ((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)).getName() + "-->" + ((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)).getName());
        this.convertRSCToAP(rsc);
        graph.removeEdge((Object)rsc);
        TarjanSimpleCycles tsc = new TarjanSimpleCycles(graph);
        cycles = this.convertSimpleCycleToSubGraph(tsc.findSimpleCycles(), graph);
        if (cycles.size() == 0) {
            return null;
        }
        BasicEList deleteMe = new BasicEList();
        for (DirectedSubgraph<Runnable, RunnableSequencingConstraint> directedSubgraph : cycles) {
            if (directedSubgraph.vertexSet().size() != 1 && directedSubgraph.vertexSet().size() != 0) continue;
            deleteMe.add(directedSubgraph);
        }
        for (DirectedSubgraph directedSubgraph : deleteMe) {
            cycles.remove(directedSubgraph);
        }
        return cycles;
    }

    private void convertRSCToAP(RunnableSequencingConstraint rsc) {
        AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
        AccessPrecedenceSpec ap = swf.createAccessPrecedenceSpec();
        ap.setLabel(new Helper().getCommonLabel((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0), (Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)));
        ap.setOrigin((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0));
        ap.setTarget((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0));
        ap.setOrderType(AccessPrecedenceType.IGNORE_WR);
        if (this.swm.getProcessPrototypes().size() > 0) {
            HashSet<AccessPrecedenceSpec> aps = new HashSet<AccessPrecedenceSpec>();
            aps.add(ap);
            new Helper().assignAPs(aps);
        } else {
            PartLog.getInstance().log("No ProcessPrototype for cycle dissolution - creating ProcessPrototype with all runnables");
            ProcessPrototype pp = swf.createProcessPrototype();
            pp.setName("allRunnables");
            for (Runnable r : this.swm.getRunnables()) {
                TaskRunnableCall trc = swf.createTaskRunnableCall();
                trc.setRunnable(r);
                pp.getRunnableCalls().add((Object)trc);
            }
            pp.getAccessPrecedenceSpec().add((Object)ap);
            this.swm.getProcessPrototypes().add((Object)pp);
        }
        this.cm.getRunnableSequencingConstraints().remove((Object)rsc);
    }

    /*
     * Unable to fully structure code
     */
    private RunnableSequencingConstraint getMostEfficientRemoveEdge(List<DirectedSubgraph<Runnable, RunnableSequencingConstraint>> cycles) {
        block9: {
            block10: {
                bc = this.getBiggestCycle(cycles);
                source = this.getBiggestPrecedingRunnable(bc);
                sourcert = new Helper().getPreceedingRunTimeCycle(this.cm, source);
                source2 = this.getBiggestSuccessingRunnable(bc);
                source2rt = new Helper().getSucceedingRunTimeCycle(this.cm, source2);
                preceding = true;
                if (source2rt > sourcert) {
                    preceding = false;
                    source = source2;
                    sourcert = source2rt;
                } else {
                    source2 = source;
                    source2rt = sourcert;
                }
                cycleRestWeight = 0L;
                for (Runnable rt : bc.vertexSet()) {
                    if (rt == source) continue;
                    cycleRestWeight += new Helper().getInstructions(rt);
                }
                removeMe = (RunnableSequencingConstraint)this.cm.getRunnableSequencingConstraints().get(0);
                if (cycleRestWeight >= sourcert - new Helper().getInstructions(source)) break block10;
                if (!preceding) ** GOTO lbl29
                while (bc.incomingEdgesOf((Object)source).size() == 1 && ((ProcessRunnableGroup)((RunnableSequencingConstraint)bc.incomingEdgesOf((Object)source).toArray()[0]).getRunnableGroups().get(0)).getRunnables().get(0) != source2) {
                    removeMe = (RunnableSequencingConstraint)bc.incomingEdgesOf((Object)source).toArray()[0];
                    source = (Runnable)((ProcessRunnableGroup)removeMe.getRunnableGroups().get(0)).getRunnables().get(0);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    removeMe = (RunnableSequencingConstraint)bc.outgoingEdgesOf((Object)source).toArray()[0];
                    source = (Runnable)((ProcessRunnableGroup)removeMe.getRunnableGroups().get(1)).getRunnables().get(0);
lbl29:
                    // 2 sources

                    ** while (bc.outgoingEdgesOf((Object)source).size() == 1 && ((ProcessRunnableGroup)((RunnableSequencingConstraint)bc.outgoingEdgesOf((Object)source).toArray()[0]).getRunnableGroups().get((int)1)).getRunnables().get((int)0) != source2)
                }
lbl30:
                // 1 sources

                break block9;
            }
            PartLog.getInstance().log("Cycle branch length: " + Long.toString(cycleRestWeight /= 2L));
            branchLength = 0L;
            removeMe = (RunnableSequencingConstraint)bc.outgoingEdgesOf((Object)source).toArray()[0];
            while (branchLength < cycleRestWeight) {
                target = (Runnable)bc.getEdgeTarget((Object)((RunnableSequencingConstraint)bc.outgoingEdgesOf((Object)source).toArray()[0]));
                branchLengthA = branchLength + new Helper().getInstructions(target);
                if (branchLengthA == cycleRestWeight) {
                    removeMe = (RunnableSequencingConstraint)bc.outgoingEdgesOf((Object)target).toArray()[0];
                    break;
                }
                if (branchLengthA < cycleRestWeight) {
                    branchLength = branchLengthA;
                    source = target;
                    continue;
                }
                if (branchLengthA <= cycleRestWeight) continue;
                distCycleRestWeighta = branchLengthA - cycleRestWeight;
                distCycleRestWeightb = cycleRestWeight - branchLength;
                if (distCycleRestWeighta > distCycleRestWeightb) {
                    return (RunnableSequencingConstraint)bc.outgoingEdgesOf((Object)source).toArray()[0];
                }
                return (RunnableSequencingConstraint)bc.outgoingEdgesOf((Object)target).toArray()[0];
            }
        }
        return removeMe;
    }

    private DirectedSubgraph<Runnable, RunnableSequencingConstraint> getBiggestCycle(List<DirectedSubgraph<Runnable, RunnableSequencingConstraint>> cycles) {
        long bcw = 0L;
        DirectedSubgraph<Runnable, RunnableSequencingConstraint> bc = null;
        for (DirectedSubgraph<Runnable, RunnableSequencingConstraint> dsg : cycles) {
            long cw = this.getCycleWeight(dsg);
            if (cw > bcw) {
                bcw = cw;
                bc = dsg;
                continue;
            }
            if (cw != bcw) continue;
            long icw1 = this.getBiggestPrecedingRuntime(bc);
            long icw2 = this.getBiggestPrecedingRuntime(dsg);
            if (icw2 <= icw1) continue;
            bcw = cw;
            bc = dsg;
        }
        return bc;
    }

    private long getBiggestPrecedingRuntime(DirectedSubgraph<Runnable, RunnableSequencingConstraint> bc) {
        long bpr = 0L;
        for (Runnable r : bc.vertexSet()) {
            long pr = new Helper().getPreceedingRunTimeCycle(this.cm, r);
            if (pr <= bpr) continue;
            bpr = pr;
        }
        return bpr;
    }

    private Runnable getBiggestPrecedingRunnable(DirectedSubgraph<Runnable, RunnableSequencingConstraint> bc) {
        long bpr = 0L;
        Runnable rr = null;
        for (Runnable r : bc.vertexSet()) {
            long pr = new Helper().getPreceedingRunTimeCycle(this.cm, r);
            if (pr <= bpr) continue;
            bpr = pr;
            rr = r;
        }
        return rr;
    }

    private Runnable getBiggestSuccessingRunnable(DirectedSubgraph<Runnable, RunnableSequencingConstraint> bc) {
        long bpr = 0L;
        Runnable rr = null;
        for (Runnable r : bc.vertexSet()) {
            long pr = new Helper().getSucceedingRunTimeCycle(this.cm, r);
            if (pr <= bpr) continue;
            bpr = pr;
            rr = r;
        }
        return rr;
    }

    private RunnableSequencingConstraint getMostCommonEdges(List<DirectedSubgraph<Runnable, RunnableSequencingConstraint>> cycles) {
        if (cycles.size() == 1) {
            return this.getMostEfficientRemoveEdge(cycles);
        }
        HashMap<RunnableSequencingConstraint, Integer> mceReps = new HashMap<RunnableSequencingConstraint, Integer>();
        for (RunnableSequencingConstraint rsc : this.cm.getRunnableSequencingConstraints()) {
            mceReps.put(rsc, 0);
        }
        for (DirectedSubgraph<Runnable, RunnableSequencingConstraint> dsg : cycles) {
            for (RunnableSequencingConstraint rsc : dsg.edgeSet()) {
                mceReps.put(rsc, (Integer)mceReps.get(rsc) + 1);
            }
        }
        int reps = 0;
        RunnableSequencingConstraint mce = null;
        Iterator it = mceReps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            if ((Integer)pair.getValue() > reps) {
                reps = (Integer)pair.getValue();
                mce = (RunnableSequencingConstraint)pair.getKey();
            }
            it.remove();
        }
        if (reps == 1) {
            return null;
        }
        return mce;
    }

    private long getCycleWeight(DirectedSubgraph<Runnable, RunnableSequencingConstraint> dsg) {
        long cw = 0L;
        for (Runnable r : dsg.vertexSet()) {
            cw += new Helper().getInstructions(r);
        }
        return cw;
    }

    public void setEfficientEdgeInCycle(boolean efficientEdgeInCycle) {
        this.efficientEdgeInCycle = efficientEdgeInCycle;
    }

    public void setMinimialEdgeElim(boolean minimialEdgeElim) {
        this.minimialEdgeElim = minimialEdgeElim;
    }

    public boolean isMinimialEdgeElim() {
        return this.minimialEdgeElim;
    }

    public boolean isEfficientEdgeInCycle() {
        return this.efficientEdgeInCycle;
    }

    public IStatus run(IProgressMonitor monitor) {
        DirectedGraph<Runnable, RunnableSequencingConstraint> graph = this.createJGraphT();
        if (graph == null) {
            PartLog.getInstance().log("No Constraints model!", null);
            return Status.CANCEL_STATUS;
        }
        PartLog.getInstance().setLogName("Cycle Elimination");
        if (!this.minimialEdgeElim) {
            Cycle<Runnable, RunnableSequencingConstraint> mc = new Cycle<Runnable, RunnableSequencingConstraint>(graph);
            if (monitor == null) {
                mc.findSimpleCycles();
                for (RunnableSequencingConstraint rsc : mc.getRemovedEdges()) {
                    this.convertRSCToAP(rsc);
                }
            } else {
                monitor.beginTask("Cycle Elimination", mc.getRemovedEdges().size());
                mc.findSimpleCycles();
                for (RunnableSequencingConstraint rsc : mc.getRemovedEdges()) {
                    monitor.worked(1);
                    this.convertRSCToAP(rsc);
                }
                monitor.done();
            }
            return Status.OK_STATUS;
        }
        TarjanSimpleCycles tsc = new TarjanSimpleCycles();
        tsc.setGraph(graph);
        List scycles = tsc.findSimpleCycles();
        List<DirectedSubgraph<Runnable, RunnableSequencingConstraint>> cycles = this.convertSimpleCycleToSubGraph(scycles, graph);
        StringBuffer sb = new StringBuffer();
        sb.append("SimpleCycles: ");
        for (List rl : scycles) {
            sb.append("\n" + scycles.indexOf(rl) + ":(");
            for (Runnable r : rl) {
                sb.append(String.valueOf(r.getName()) + ", ");
            }
            sb.append(")");
        }
        PartLog.getInstance().log(sb.toString());
        RunnableSequencingConstraint re = null;
        monitor.beginTask("Cycle elimintation", cycles.size());
        while (cycles != null && cycles.size() > 0) {
            monitor.worked(1);
            if (this.minimialEdgeElim) {
                re = this.getMostCommonEdges(cycles);
                if (re == null) {
                    re = this.efficientEdgeInCycle ? this.getMostEfficientRemoveEdge(cycles) : (RunnableSequencingConstraint)cycles.get(0).edgeSet().iterator().next();
                }
            } else {
                re = this.efficientEdgeInCycle ? this.getMostEfficientRemoveEdge(cycles) : (RunnableSequencingConstraint)cycles.get(0).edgeSet().iterator().next();
            }
            if (re != null) {
                cycles = this.removeRSC(graph, cycles, re);
                continue;
            }
            PartLog.getInstance().log("Cycle elimination could not find remove edge!", null);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

