/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collection;
import org.eclipse.app4mc.amalthea.model.AffinityConstraint;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableGroup;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CheckActivations;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CheckLabels;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CycleElimination;
import org.eclipse.app4mc.multicore.partitioning.algorithms.GGP;
import org.eclipse.app4mc.multicore.partitioning.algorithms.Helper;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.preference.IPreferenceStore;

public class PrePartitioning {
    private final boolean enableLog = true;
    private boolean activationGroups = false;
    private boolean ggp = false;
    private boolean efficientEdgeInCycle = false;
    private boolean minimalEdgeDis = false;

    public PrePartitioning(IPreferenceStore store) {
        this.setActivationGroups(store.getBoolean("boolActivation"));
        this.setEfficientEdgeInCycle(store.getBoolean("boolEffEdge"));
        this.setGgp(store.getBoolean("boolGGP"));
        this.setMinimalEdgeDis(store.getBoolean("boolMinEdges"));
    }

    public PrePartitioning(boolean ag, boolean ggp, boolean effEdges, boolean minimalEdges) {
        this.setActivationGroups(ag);
        this.setEfficientEdgeInCycle(effEdges);
        this.setGgp(ggp);
        this.setMinimalEdgeDis(minimalEdges);
    }

    public boolean isEfficientEdgeInCycle() {
        return this.efficientEdgeInCycle;
    }

    public boolean isMinimalEdgeDis() {
        return this.minimalEdgeDis;
    }

    public void setMinimalEdgeDis(boolean minimalEdgeDis) {
        this.minimalEdgeDis = minimalEdgeDis;
    }

    public void setEfficientEdgeInCycle(boolean effCycleElim) {
        this.efficientEdgeInCycle = effCycleElim;
    }

    public Amalthea performPrePartitioning(Amalthea modelCopy, IProgressMonitor monitor) {
        if (this.isEnableLog()) {
            PartLog.getInstance().setLogName("PrePartitioning");
        }
        if (modelCopy.getSwModel() == null) {
            PartLog.getInstance().log("No SW Model found. Stopping Prepartitioning", null);
            return null;
        }
        modelCopy = this.mergeRunnablesFromAffntyCnstrnts(modelCopy);
        if (this.activationGroups) {
            PartLog.getInstance().setLogName("Activation Analysis");
            PartLog.getInstance().log("Starting Activations Analysis");
            assert (modelCopy.getSwModel() != null && modelCopy.getStimuliModel() != null);
            if (modelCopy.getStimuliModel() != null && modelCopy.getSwModel().getActivations() == null) {
                for (Stimulus s : modelCopy.getStimuliModel().getStimuli()) {
                    AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
                    PeriodicActivation pa = swf.createPeriodicActivation();
                    pa.setName(s.getName());
                    modelCopy.getSwModel().getActivations().add((Object)pa);
                }
            }
            CheckActivations ca = new CheckActivations();
            if (modelCopy.getStimuliModel() != null) {
                ca.createPPs(modelCopy.getSwModel(), modelCopy.getStimuliModel(), monitor);
            } else if (modelCopy.getStimuliModel() == null && modelCopy.getSwModel().getActivations() != null) {
                ca.createPPs(modelCopy.getSwModel(), monitor);
            } else {
                PartLog.getInstance().log("Neither stimulation model nor activation within swmodel found. No activation analaysis possible", null);
            }
            assert (ca.getSwmo() != null);
            if (ca.getSwmo() == null || ca.getSwmo().getRunnables().size() < 1) {
                PartLog.getInstance().log("No Runnables at Activation Analysis.", null);
            } else {
                modelCopy.setSwModel(ca.getSwmo());
                modelCopy.setStimuliModel(ca.getStimu());
                PartLog.getInstance().log("Activation Analysis finished. Created ProcessPrototypes: " + ca.getSwmo().getProcessPrototypes().size());
            }
        }
        if (modelCopy.getConstraintsModel() == null || modelCopy.getConstraintsModel().getRunnableSequencingConstraints().size() == 0) {
            CheckLabels cl = new CheckLabels();
            cl.setSwm(modelCopy.getSwModel());
            if (modelCopy.getConstraintsModel() != null) {
                modelCopy.getConstraintsModel().getAffinityConstraints().clear();
                cl.setCMModel(modelCopy.getConstraintsModel());
            }
            cl.run(monitor);
            if (cl.getCMModel() == null || cl.getCMModel().getRunnableSequencingConstraints().size() < 1) {
                PartLog.getInstance().log("No Constraintsmodel / Runnable Sequencing Constraints created! Stopping Prepartitioning.", null);
                return null;
            }
            modelCopy.setConstraintsModel(cl.getCMModel());
            PartLog.getInstance().log("Graph creation (constraint model) finished.");
        } else {
            PartLog.getInstance().log("ConstraintsModel already existing.");
        }
        assert (modelCopy.getSwModel() != null);
        assert (modelCopy.getConstraintsModel().getRunnableSequencingConstraints() != null);
        CycleElimination ce = new CycleElimination(modelCopy.getSwModel(), modelCopy.getConstraintsModel());
        ce.setparams(this.efficientEdgeInCycle, this.minimalEdgeDis);
        while (!ce.run(monitor).isOK()) {
        }
        assert (ce.getSwm() != null && ce.getCm() != null);
        if (ce.getSwm() == null) {
            PartLog.getInstance().log("No swmodel available after CycleElimination. Stopping Prepartitioning.", null);
            return null;
        }
        modelCopy.setSwModel(ce.getSwm());
        modelCopy.setConstraintsModel(ce.getCm());
        PartLog.getInstance().log("Cycle elimination finished.");
        if (this.ggp) {
            PartLog.getInstance().setLogName("GG Partitioning");
            PartLog.getInstance().log("Starting to generate ProcessPrototypes for each independent graph (GGP).");
            GGP ggp = new GGP(modelCopy.getSwModel(), modelCopy.getConstraintsModel());
            ggp.build();
            assert (ggp.getCm() != null && ggp.getSwm() != null);
            if (ggp.getCm() == null || ggp.getCm() == null) {
                PartLog.getInstance().log("GGP did not result in swmodel / constraints model. Stopping Prepartitioning.", null);
                return null;
            }
            modelCopy.setSwModel(ggp.getSwm());
            modelCopy.setConstraintsModel(ggp.getCm());
            PartLog.getInstance().log("GGP finished. Created ProcessPrototypes: " + ggp.getSwm().getProcessPrototypes().size());
        }
        for (ProcessPrototype pp : modelCopy.getSwModel().getProcessPrototypes()) {
            StringBuffer sb = new StringBuffer();
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                sb.append(String.valueOf(trc.getRunnable().getName()) + ", ");
            }
            PartLog.getInstance().log(String.valueOf(pp.getName()) + ": " + sb.toString());
        }
        PartLog.getInstance().logSimple("PrePartitioning finished.");
        return modelCopy;
    }

    private Amalthea mergeRunnablesFromAffntyCnstrnts(Amalthea modelCopy) {
        if (modelCopy.getConstraintsModel() != null && modelCopy.getConstraintsModel().getAffinityConstraints() != null && modelCopy.getConstraintsModel().getAffinityConstraints().size() > 0) {
            PartLog.getInstance().log("Found AffinityConstraints, Creating CumulatedRunnables");
            AmaltheaFactory af = AmaltheaFactory.eINSTANCE;
            EList acs = modelCopy.getConstraintsModel().getAffinityConstraints();
            for (AffinityConstraint ac : acs) {
                if (!(ac instanceof RunnablePairingConstraint)) continue;
                RunnablePairingConstraint rpc = (RunnablePairingConstraint)ac;
                Runnable r = af.createRunnable();
                r.setName("CumulatedRunnable" + modelCopy.getConstraintsModel().getAffinityConstraints().indexOf((Object)ac));
                RunnableGroup rg = rpc.getGroup();
                RunnableEntityGroup reg = (RunnableEntityGroup)rg;
                long instrCum = 0L;
                for (Runnable run : reg.getRunnables()) {
                    instrCum += new Helper().getInstructions(run);
                    BasicEList ril = new BasicEList();
                    for (RunnableItem ri : run.getRunnableItems()) {
                        if (ri instanceof InstructionsConstant || ri instanceof InstructionsDeviation) continue;
                        ril.add((Object)ri);
                    }
                    r.getRunnableItems().addAll((Collection)ril);
                    r.setActivation(run.getActivation());
                }
                InstructionsConstant ic = af.createInstructionsConstant();
                ic.setValue(instrCum);
                RunnableInstructions runInst = af.createRunnableInstructions();
                runInst.setDefault((Instructions)ic);
                r.getRunnableItems().add((Object)runInst);
                modelCopy.getSwModel().getRunnables().add((Object)r);
                for (Task t : modelCopy.getSwModel().getTasks()) {
                    for (GraphEntryBase geb : t.getCallGraph().getGraphEntries()) {
                        if (!(geb instanceof CallSequence)) continue;
                        BasicEList rtrcs = new BasicEList();
                        CallSequence cs = (CallSequence)geb;
                        for (CallSequenceItem csi : cs.getCalls()) {
                            if (!(csi instanceof TaskRunnableCall)) continue;
                            TaskRunnableCall trc = (TaskRunnableCall)csi;
                            if (!reg.getRunnables().contains((Object)trc.getRunnable())) continue;
                            rtrcs.add((Object)trc);
                        }
                        cs.getCalls().removeAll((Collection)rtrcs);
                    }
                }
                modelCopy.getSwModel().getRunnables().removeAll((Collection)reg.getRunnables());
            }
        }
        return modelCopy;
    }

    private boolean isEnableLog() {
        return true;
    }

    public boolean getActivationGroups() {
        return this.activationGroups;
    }

    public void setActivationGroups(boolean ActivationGroups) {
        this.activationGroups = ActivationGroups;
    }

    public boolean isGgp() {
        return this.ggp;
    }

    public void setGgp(boolean ggp) {
        this.ggp = ggp;
    }
}

