/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.handlers;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CycleElimination;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartLog;
import org.eclipse.app4mc.multicore.partitioning.algorithms.TopologicalCalculation;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class WriteAppletHandler
extends AbstractHandler {
    private ConstraintsModel cm;
    private SWModel swm;
    final int xdistance = 275;
    final int ydistance = 75;
    String className = "";

    public WriteAppletHandler(SWModel swm, ConstraintsModel cm) {
        this.swm = swm;
        this.cm = cm;
    }

    public WriteAppletHandler() {
    }

    public void write(SWModel swmi, ConstraintsModel cmi, String file) {
        this.swm = swmi;
        this.cm = cmi;
        PartLog.getInstance().setEnableTargetConsoleLog(true);
        PartLog.getInstance().setEnableSourceConsoleLog(true);
        PartLog.getInstance().setLogName("Applet Writer");
        StringBuffer output = new StringBuffer();
        this.className = "applet";
        if (file == null) {
            this.className = "applet";
            file = "applet.java";
        } else if (file.endsWith(".amxmi")) {
            this.className = (file = file.replace(".amxmi", "_Applet.java")).contains("\\") ? file.substring(file.lastIndexOf(92) + 1, file.lastIndexOf(".")) : file.substring(0, file.lastIndexOf("."));
        } else if (!file.endsWith(".amxmi")) {
            PartLog.getInstance().log("Applet can only be generated for .amxmi files", null);
            return;
        }
        PartLog.getInstance().log("File: " + file + " Classname: " + this.className);
        try {
            output.append(this.initString());
            CycleElimination ce = new CycleElimination(this.swm, this.cm);
            if (ce.containsCycles()) {
                ce.run(null);
            }
            if (this.cm.getRunnableSequencingConstraints().size() < 1 || this.swm.getRunnables().size() < 1) {
                PartLog.getInstance().log("No Runnables or Sequencing Constraints present. ABORTING", null);
                return;
            }
            for (Runnable r : this.swm.getRunnables()) {
                try {
                    output.append("\t\tg.addVertex(\"" + r.getName() + "\");\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            output.append("\n");
            for (RunnableSequencingConstraint rsc : this.cm.getRunnableSequencingConstraints()) {
                try {
                    output.append("\t\tg.addEdge(\"" + ((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)).getName() + "\",\"" + ((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)).getName() + "\");\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int size = 0;
            try {
                Runnable fr = new TopologicalCalculation(this.swm, this.cm).getFarthestNode(Integer.MAX_VALUE);
                size = new TopologicalCalculation(this.swm, this.cm).calcNodesToSink(fr);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return;
            }
            int[] x = new int[size + 1];
            int i = 0;
            while (i < size) {
                x[i] = 0;
                ++i;
            }
            if (this.swm.getProcessPrototypes().size() <= 1) {
                for (Runnable r : this.swm.getRunnables()) {
                    try {
                        int temp = size - new TopologicalCalculation(this.swm, this.cm).calcNodesToSink(r);
                        output.append("\t\tpositionVertexAt(\"" + r.getName() + "\", " + Integer.toString(x[temp] * 275) + ", " + Integer.toString(temp * 75) + ");\n");
                        int n = temp;
                        x[n] = x[n] + 1;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                int xpos = 0;
                for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
                    int ypos = 0;
                    for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                        output.append("\t\tpositionVertexAt(\"" + trc.getRunnable().getName() + "\", " + Integer.toString(xpos * 275) + ", " + Integer.toString(ypos * 75) + ");\n");
                        ++ypos;
                    }
                    ++xpos;
                }
            }
            output.append("\n } \n ");
            output.append(this.endString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            BufferedWriter w = new BufferedWriter(new FileWriter(file));
            w.write(output.toString());
            ((Writer)w).close();
            PartLog.getInstance().log("Applet written: " + file + " (please refresh Project / Model Explorer)");
        }
        catch (IOException e) {
            PartLog.getInstance().log("Writing file aborted: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String endString() {
        String str = "";
        str = "\tprivate void adjustDisplaySettings(final JGraph jg) {\n\t\tjg.setPreferredSize(DEFAULT_SIZE);\n\n\t\tColor c = DEFAULT_BG_COLOR;\n\t\tString colorStr = null;\n\n\t\ttry {\n\t\t\tcolorStr = getParameter(\"bgcolor\");\n\t\t}\n\t\tcatch (final Exception e) {\n\t\t}\n\n\t\tif (colorStr != null) {\n\t\t\tc = Color.decode(colorStr);\n\t\t}\n\n\t\tjg.setBackground(c);\n\t}\n\n\n\tprivate void positionVertexAt(final Object vertex, final int x, final int y) {\n\t\tfinal DefaultGraphCell cell = this.m_jgAdapter.getVertexCell(vertex);\n\t\tfinal Map attr = cell.getAttributes();\n\t\tfinal Rectangle2D b = GraphConstants.getBounds(attr);\n\t\tb.setRect(x, y, 250, b.getHeight());\n\t\tGraphConstants.setBounds(attr, b);\n\n\t\tfinal Map cellAttr = new HashMap();\n\t\tcellAttr.put(cell, attr);\n\t\tthis.m_jgAdapter.edit(cellAttr, null, null, null);\n\t}\n}";
        return str;
    }

    private String initString() {
        int maxRcount = 0;
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            if (pp.getRunnableCalls().size() <= maxRcount) continue;
            maxRcount = pp.getRunnableCalls().size();
        }
        String str = "package MyPackage;\n\nimport java.awt.Color;\nimport java.awt.Dimension;\nimport java.awt.geom.Rectangle2D;\nimport java.util.HashMap;\nimport java.util.Map;\n\nimport javax.swing.JApplet;\nimport javax.swing.JScrollPane;\n\nimport org.jgraph.JGraph;\nimport org.jgraph.graph.DefaultGraphCell;\nimport org.jgraph.graph.GraphConstants;\nimport org.jgrapht.ListenableGraph;\nimport org.jgrapht.ext.JGraphModelAdapter;\nimport org.jgrapht.graph.DefaultEdge;\nimport org.jgrapht.graph.ListenableDirectedGraph;\n\npublic class " + this.className + " extends JApplet {\n" + "\tprivate static final Color DEFAULT_BG_COLOR = Color.decode(\"#FAFBFF\");\n" + "\tprivate static final Dimension DEFAULT_SIZE = new Dimension(" + this.swm.getProcessPrototypes().size() * 275 + ", " + maxRcount * 75 + ");\n" + "\tprivate JGraphModelAdapter m_jgAdapter;\n" + "\n" + "\t@Override\n" + "\tpublic void init() {\n" + "\t\t// create a JGraphT graph\n" + "\t\tfinal ListenableGraph g = new ListenableDirectedGraph(DefaultEdge.class);\n" + "\t\t// create a visualization using JGraph, via an adapter\n" + "\t\tthis.m_jgAdapter = new JGraphModelAdapter(g);\n" + "\t\tfinal JGraph jgraph = new JGraph(this.m_jgAdapter);\n" + "\t\tadjustDisplaySettings(jgraph);\n" + "\t\tgetContentPane().add(jgraph);\n" + "\t\tJScrollPane sp = new JScrollPane(jgraph);\n" + "\t\tsp.setPreferredSize(DEFAULT_SIZE);\n" + "\t\tgetContentPane().add( sp);\n" + "\t\tresize(new Dimension(1000,800));\n";
        return str;
    }

    public ConstraintsModel getCm() {
        return this.cm;
    }

    public void setCm(ConstraintsModel cm) {
        this.cm = cm;
    }

    public SWModel getSwm() {
        return this.swm;
    }

    public void setSwm(SWModel swm) {
        this.swm = swm;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PartLog.getInstance().setLogName("Applet Writer");
        PartLog.getInstance().setEnableSourceConsoleLog(true);
        PartLog.getInstance().setEnableTargetConsoleLog(true);
        PartLog.getInstance().log("Starting to generate an applet...");
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Object adapter;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object element = structuredSelection.getFirstElement();
            if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(IFile.class)) instanceof IFile) {
                element = adapter;
            }
            if (element instanceof IFile) {
                try {
                    IFile file = (IFile)element;
                    try {
                        this.perform(file);
                    }
                    catch (Exception exception) {
                        PartLog.getInstance().log("File " + file.getFullPath().toString() + " can not be visualized. File must provide label analysis!");
                    }
                }
                catch (Exception e) {
                    PartLog.getInstance().log("Error during writing Applet");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private void perform(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        UniversalHandler.getInstance().dropCache();
        UniversalHandler.getInstance().readModels(uri, false);
        this.swm = UniversalHandler.getInstance().getSwModel();
        this.cm = UniversalHandler.getInstance().getConstraintsModel();
        if (this.swm == null || this.swm.getRunnables().isEmpty()) {
            PartLog.getInstance().log("Failed: Applet generation requires valid software model.\n");
            return;
        }
        if (this.cm == null || this.cm.getRunnableSequencingConstraints().isEmpty()) {
            PartLog.getInstance().log("Failed: Applet generation requires valid constraints model.\n");
            return;
        }
        try {
            this.write(this.swm, this.cm, file.getRawLocation().toOSString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

