/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.workflow;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CreateTAInput;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartLog;

public class ContraintsAlternative
extends WorkflowComponent {
    private final String resultSlot = "constraintsAlternative";
    private final boolean enableLog = false;

    protected void runInternal(Context ctx) {
        Amalthea modelCopy = this.getAmaltheaModelCopy(ctx);
        assert (modelCopy.getSwModel() != null && modelCopy.getConstraintsModel() != null);
        if (modelCopy.getSwModel() == null || modelCopy.getConstraintsModel() == null) {
            PartLog.getInstance().log("No available SWmodel or Constraints model for generating the alternative constraints model. Stopping.", null);
            return;
        }
        if (this.isEnableLog()) {
            PartLog.getInstance().setEnableSourceConsoleLog(true);
        }
        CreateTAInput ctai = new CreateTAInput();
        ctai.setCm(modelCopy.getConstraintsModel());
        ctai.combineSimilarRSCs();
        modelCopy.setConstraintsModel(ctai.getCm());
        PartLog.getInstance().log("Setting result model in slot: " + this.getResultSlot());
        ctx.set(this.getResultSlot(), (Object)modelCopy);
        PartLog.getInstance().logSimple("Alternative constraints model generation finished.");
    }

    private String getResultSlot() {
        return "constraintsAlternative";
    }

    private boolean isEnableLog() {
        return false;
    }
}

