/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.workflow;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartLog;
import org.eclipse.app4mc.multicore.partitioning.handlers.WriteAppletHandler;

public class GenerateApplet
extends WorkflowComponent {
    private final boolean enableLog = false;
    private String outputDir;

    protected void runInternal(Context ctx) {
        Amalthea modelCopy = this.getAmaltheaModelCopy(ctx);
        assert (modelCopy.getSwModel() != null && modelCopy.getConstraintsModel() != null);
        PartLog.getInstance().setLogName("Applet generation");
        if (modelCopy.getSwModel().getRunnables().size() < 1 || modelCopy.getConstraintsModel().getRunnableSequencingConstraints().size() < 1) {
            PartLog.getInstance().log("Applet Input is not correct. No Runnables / Sequencing Constraints available!!", null);
            return;
        }
        if (this.isEnableLog()) {
            PartLog.getInstance().setEnableSourceConsoleLog(true);
        }
        WriteAppletHandler wa = new WriteAppletHandler();
        wa.write(modelCopy.getSwModel(), modelCopy.getConstraintsModel(), this.outputDir);
        if (this.outputDir == null) {
            this.outputDir = "-Project folder-";
        }
        PartLog.getInstance().log("No result slot needed for Applet generation. Applet has been saved at " + this.outputDir + ".");
        PartLog.getInstance().logSimple("Applet generation finished");
    }

    private boolean isEnableLog() {
        return false;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }
}

