/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.workflow;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.amalthea.workflow.core.exception.ConfigurationException;
import org.eclipse.app4mc.multicore.openmapping.sharedlibs.UniversalHandler;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CPP;
import org.eclipse.app4mc.multicore.partitioning.algorithms.ESSP;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartLog;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PerformPartitioning;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class GeneratePartitioning
extends WorkflowComponent {
    private static final String PARTITIONING_CPP = "cpp";
    private static final String PARTITIONING_ESSP = "essp";
    private final String resultSlot = "partitioning";
    private String partitioningAlg;
    private String numberOfPartitions;
    private boolean globalCP = true;
    private String modelLoc = "";
    private final boolean enableLog = false;

    public void setModelLoc(String modelLoc) {
        this.modelLoc = modelLoc;
    }

    public void setglobalCP(boolean GlobalCP) {
        this.globalCP = GlobalCP;
    }

    protected void runInternal(Context ctx) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        PartLog.getInstance().log("Starting Partitioning...");
        Amalthea modelCopy = this.getAmaltheaModelCopy(ctx);
        assert (modelCopy.getSwModel() != null && modelCopy.getConstraintsModel() != null);
        if (this.isEnableLog()) {
            PartLog.getInstance().setEnableSourceConsoleLog(true);
        }
        if (modelCopy.getSwModel().getProcessPrototypes().size() == 0) {
            modelCopy.setSwModel(this.createPPs(modelCopy.getSwModel()));
        }
        if (this.partitioningAlg.equals(PARTITIONING_ESSP)) {
            PartLog.getInstance().setLogName("ESS Partitioning");
            PartLog.getInstance().log("Starting ESS Partitioning");
            if (this.numberOfPartitions == null || Integer.parseInt(this.numberOfPartitions) < 1) {
                PartLog.getInstance().log("Number of Partitions required for ESS Partitioning! (>0)", null);
                return;
            }
            int inumberOfPartitions = Integer.parseInt(this.numberOfPartitions);
            assert (1 < inumberOfPartitions);
            ESSP essp = new ESSP(modelCopy.getSwModel(), modelCopy.getConstraintsModel(), inumberOfPartitions);
            essp.build((IProgressMonitor)monitor);
            if (essp.swm.getRunnables().size() < 1 || essp.cm.getRunnableSequencingConstraints().size() < 1) {
                PartLog.getInstance().log("ESS Partitioning did not work correctly. No Runnables / Sequencing Constraints available!!", null);
                return;
            }
            if (essp.swm.getProcessPrototypes().size() < Integer.parseInt(this.numberOfPartitions)) {
                PartLog.getInstance().log("ESSP could not generate " + Integer.parseInt(this.numberOfPartitions) + " partitions since the softwaremodel's graph does not feature enough parallel runnables. " + essp.swm.getProcessPrototypes().size() + " partitions could be generated.");
            }
            modelCopy.setConstraintsModel(essp.cm);
            modelCopy.setSwModel(essp.swm);
        } else if (this.partitioningAlg.equals(PARTITIONING_CPP)) {
            PartLog.getInstance().setLogName("CP Partitioning");
            PartLog.getInstance().log("Starting CP Partitioning. Runnables: " + modelCopy.getSwModel().getRunnables().size() + "; RSCs: " + modelCopy.getConstraintsModel().getRunnableSequencingConstraints().size());
            CPP cpp = new CPP(modelCopy.getSwModel(), modelCopy.getConstraintsModel());
            cpp.bglobalCP = this.globalCP;
            cpp.build((IProgressMonitor)monitor);
            if (cpp.swm.getRunnables().size() < 1 || cpp.cm.getRunnableSequencingConstraints().size() < 1) {
                PartLog.getInstance().log("CP Partitioning did not work correctly. No Runnables / Sequencing Constraints available!! RSCs: " + cpp.cm.getRunnableSequencingConstraints().size(), null);
                return;
            }
            modelCopy.setConstraintsModel(cpp.cm);
            modelCopy.setSwModel(cpp.swm);
        }
        UniversalHandler uh = UniversalHandler.getInstance();
        Path path = new Path(this.modelLoc);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        PartLog.getInstance().log(file.getFullPath().toString());
        modelCopy = new PerformPartitioning().retainAffntyCnstrnts(file, uh, modelCopy, (IProgressMonitor)monitor);
        PartLog.getInstance().log("Setting result model in slot: " + this.getResultSlot());
        ctx.set(this.getResultSlot(), (Object)modelCopy);
        PartLog.getInstance().logSimple(String.valueOf(this.partitioningAlg) + " Partitioning finished.");
    }

    protected void checkInternal() throws ConfigurationException {
        if (this.getPartitioningAlg() == null || this.getPartitioningAlg().isEmpty()) {
            throw new ConfigurationException("No proper partitioning defined! Please define one of the following values: numberOfPartitions, globalCP, partitioningAlg");
        }
    }

    public String getPartitioningAlg() {
        return this.partitioningAlg;
    }

    public void setPartitioningAlg(String partitioningAlg) {
        this.partitioningAlg = partitioningAlg;
    }

    public String getResultSlot() {
        return "partitioning";
    }

    public boolean isEnableLog() {
        return false;
    }

    public String getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public void setNumberOfPartitions(String numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }

    private SWModel createPPs(SWModel swm) {
        AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
        ProcessPrototype pp = swf.createProcessPrototype();
        pp.setActivation(((Runnable)swm.getRunnables().get(0)).getActivation());
        pp.setName("PPTemp");
        for (Runnable r : swm.getRunnables()) {
            TaskRunnableCall trc = swf.createTaskRunnableCall();
            trc.setRunnable(r);
            pp.getRunnableCalls().add((Object)trc);
        }
        swm.getProcessPrototypes().add((Object)pp);
        return swm;
    }
}

