/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.workflow;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartLog;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PrePartitioning;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class PrePartitioningWrkflw
extends WorkflowComponent {
    private final String resultSlot = "prePartitioning";
    private boolean aa = false;
    private boolean ggp = false;
    private boolean effEdge = false;
    private boolean minimEdge = false;

    protected void runInternal(Context ctx) {
        Amalthea amodels = this.getAmaltheaModelCopy(ctx);
        PartLog.getInstance().setEnableTargetConsoleLog(true);
        PartLog.getInstance().setLogName("PrePartWorkflow");
        PrePartitioning prePart = new PrePartitioning(this.isAa(), this.isGgp(), this.isMinimEdge(), this.isEffEdge());
        amodels = prePart.performPrePartitioning(amodels, (IProgressMonitor)new NullProgressMonitor());
        if (amodels == null) {
            PartLog.getInstance().log("Prepartitioning failed", null);
            return;
        }
        if (amodels.getSwModel().getProcessPrototypes().size() > 0) {
            for (ProcessPrototype pp : amodels.getSwModel().getProcessPrototypes()) {
                StringBuffer sb = new StringBuffer();
                for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                    sb.append(String.valueOf(trc.getRunnable().getName()) + ", ");
                }
            }
        }
        PartLog.getInstance().log("Setting result model in slot: " + this.getResultSlot());
        ctx.set(this.getResultSlot(), (Object)amodels);
    }

    private String getResultSlot() {
        return "prePartitioning";
    }

    public boolean isAa() {
        return this.aa;
    }

    public boolean isGgp() {
        return this.ggp;
    }

    public boolean isEffEdge() {
        return this.effEdge;
    }

    public boolean isMinimEdge() {
        return this.minimEdge;
    }

    public void setAa(boolean aa) {
        this.aa = aa;
    }

    public void setGgp(boolean ggp) {
        this.ggp = ggp;
    }

    public void setEffEdge(boolean effEdge) {
        this.effEdge = effEdge;
    }

    public void setMinimEdge(boolean minimEdge) {
        this.minimEdge = minimEdge;
    }
}

