/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.dialog;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelMigrationJob;
import org.eclipse.app4mc.amalthea.converters.ui.providers.MigrationInputDataProvider;
import org.eclipse.app4mc.amalthea.converters.ui.providers.StyledLabelProvider;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationSettings;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ModelMigrationDialog
extends Dialog {
    private MigrationSettings migrationSettings;
    private Text txtInputModelVersion;
    private Text txtOutputDirectory;
    private TableViewer tableViewer;
    private Label lblOutputDirectory;
    private Combo mig_model_version_combo;
    private Button cancelMigrationButton;
    private Button migrateModelsButton;
    private String outputDirectoryLocation;
    final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    private FileAppender fileAppender;

    public ModelMigrationDialog(Shell parentShell, MigrationSettings migrationSettings) {
        super(parentShell);
        this.setMigrationSettings(migrationSettings);
        if (this.getMigrationSettings() == null) {
            this.setMigrationSettings(new MigrationSettings());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("AMALTHEA Model Migration");
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("AMALTHEA Model Migration");
        Composite shlAmalthea = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)shlAmalthea.getLayout();
        gridLayout.numColumns = 1;
        Group grpInitialModel = new Group(shlAmalthea, 0);
        grpInitialModel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        grpInitialModel.setText("AMALTHEA Models");
        grpInitialModel.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout(5, false));
        this.tableViewer = new TableViewer((Composite)grpInitialModel, 66304);
        final Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData tableViewerGridData = new GridData(4, 4, true, true, 5, 1);
        tableViewerGridData.widthHint = 400;
        tableViewerGridData.heightHint = 100;
        table.setLayoutData((Object)tableViewerGridData);
        table.getHorizontalBar().setEnabled(true);
        this.createTableViewerColumn(this.tableViewer, "Relative file paths");
        MigrationInputDataProvider provider = new MigrationInputDataProvider(new StyledLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)provider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.getMigrationSettings().getMigModelFiles().sort(new Comparator<MigrationInputFile>(){

            @Override
            public int compare(MigrationInputFile o1, MigrationInputFile o2) {
                if (o1.isSelectedFile()) {
                    return -1;
                }
                return 1;
            }
        });
        this.tableViewer.setInput(this.getMigrationSettings().getMigModelFiles());
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableColumn[] columns = table.getColumns();
                int columnWidth = table.getClientArea().width / columns.length;
                int index = 0;
                while (index < columns.length) {
                    columns[index].setWidth(columnWidth + 200);
                    ++index;
                }
            }
        });
        Label lblInputModelsIdentificationInfo = new Label((Composite)grpInitialModel, 0);
        lblInputModelsIdentificationInfo.setText("* Blue color: Selected Model files. Black color: Model scope files");
        lblInputModelsIdentificationInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 5, 1));
        Label lblModelVersion = new Label((Composite)grpInitialModel, 0);
        lblModelVersion.setText("Model Version : ");
        this.txtInputModelVersion = new Text((Composite)grpInitialModel, 2048);
        this.txtInputModelVersion.setEnabled(false);
        this.txtInputModelVersion.setBackground(Display.getCurrent().getSystemColor(1));
        this.txtInputModelVersion.setEditable(false);
        this.txtInputModelVersion.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.txtInputModelVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String version = ModelMigrationDialog.this.getTxtInputModelVersion().getText();
                if (version != null) {
                    if (version.equals("itea.103")) {
                        ModelMigrationDialog.this.getMig_model_version_combo().setItems(new String[]{"0.8.0", "0.7.2", "0.7.1", "0.7.0", "itea.111", "itea.110"});
                    } else if (version.equals("itea.110")) {
                        ModelMigrationDialog.this.getMig_model_version_combo().setItems(new String[]{"0.8.0", "0.7.2", "0.7.1", "0.7.0", "itea.111"});
                    } else if (version.equals("itea.111")) {
                        ModelMigrationDialog.this.getMig_model_version_combo().setItems(new String[]{"0.8.0", "0.7.2", "0.7.1", "0.7.0"});
                    } else if (version.equals("0.7.0")) {
                        ModelMigrationDialog.this.getMig_model_version_combo().setItems(new String[]{"0.8.0", "0.7.2", "0.7.1"});
                    } else if (version.equals("0.7.1")) {
                        ModelMigrationDialog.this.getMig_model_version_combo().setItems(new String[]{"0.8.0", "0.7.2"});
                    } else if (version.equals("0.7.2")) {
                        ModelMigrationDialog.this.getMig_model_version_combo().setItems(new String[]{"0.8.0"});
                    } else if (version.equals("0.8.0")) {
                        ModelMigrationDialog.this.getMig_model_version_combo().setItems(new String[]{""});
                        ModelMigrationDialog.this.getMig_model_version_combo().setEnabled(false);
                        ModelMigrationDialog.this.getMig_model_version_combo().setEnabled(false);
                    }
                    ModelMigrationDialog.this.getMig_model_version_combo().select(0);
                }
            }
        });
        this.addEmptyLabels(grpInitialModel);
        Group grpMigrationModels = new Group(shlAmalthea, 0);
        grpMigrationModels.setText("Migration details");
        grpMigrationModels.setLayout((org.eclipse.swt.widgets.Layout)new FormLayout());
        grpMigrationModels.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        Composite mig_model_version_composite = new Composite((Composite)grpMigrationModels, 0);
        FormData fd_mig_model_version_composite = new FormData();
        fd_mig_model_version_composite.top = new FormAttachment(0, 16);
        fd_mig_model_version_composite.left = new FormAttachment(0, 7);
        mig_model_version_composite.setLayoutData((Object)fd_mig_model_version_composite);
        Label mig_model_version_text = new Label(mig_model_version_composite, 0);
        mig_model_version_text.setBounds(0, 0, 84, 15);
        mig_model_version_text.setText("Model Version");
        this.mig_model_version_combo = new Combo(mig_model_version_composite, 8);
        this.mig_model_version_combo.setBounds(150, 0, 91, 23);
        this.mig_model_version_combo.select(0);
        final Composite mig_folder_selection_composite = new Composite((Composite)grpMigrationModels, 0);
        final StackLayout sl_mig_folder_selection_composite = new StackLayout();
        mig_folder_selection_composite.setLayout((org.eclipse.swt.widgets.Layout)sl_mig_folder_selection_composite);
        FormData fd_mig_folder_selection_composite = new FormData();
        fd_mig_folder_selection_composite.top = new FormAttachment(0, 51);
        fd_mig_folder_selection_composite.left = new FormAttachment(0, 7);
        mig_folder_selection_composite.setLayoutData((Object)fd_mig_folder_selection_composite);
        final Composite empty_composite = new Composite(mig_folder_selection_composite, 0);
        empty_composite.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout(1, false));
        final Composite mig_output_directory_selection_composite = new Composite(mig_folder_selection_composite, 0);
        this.lblOutputDirectory = new Label(mig_output_directory_selection_composite, 0);
        this.lblOutputDirectory.setBounds(0, 3, 96, 15);
        this.lblOutputDirectory.setText("Output directory");
        this.txtOutputDirectory = new Text(mig_output_directory_selection_composite, 2048);
        this.txtOutputDirectory.setEditable(false);
        this.txtOutputDirectory.setBounds(150, 0, 269, 21);
        this.txtOutputDirectory.setTouchEnabled(true);
        this.outputDirectoryLocation = this.migrationSettings.getOutputDirectoryLocation();
        Button btnBrowse = new Button(mig_output_directory_selection_composite, 0);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(e.display.getActiveShell());
                dialog.setFilterPath(ModelMigrationDialog.this.getMigrationSettings().getProject().getAbsolutePath());
                String selectedPath = dialog.open();
                if (selectedPath != null) {
                    ModelMigrationDialog.this.logger.info((Object)ModelMigrationDialog.this.getMigrationSettings().getOutputDirectoryLocation());
                    ModelMigrationDialog.this.setOutputDirectoryLocation(selectedPath);
                    ModelMigrationDialog.this.getTxtOutputDirectory().setText(selectedPath);
                }
            }
        });
        btnBrowse.setBounds(442, 0, 75, 25);
        btnBrowse.setText("Browse...");
        sl_mig_folder_selection_composite.topControl = mig_output_directory_selection_composite;
        mig_folder_selection_composite.layout();
        this.mig_model_version_combo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String selection_outputModelVersion = ModelMigrationDialog.this.getMig_model_version_combo().getText();
                if (selection_outputModelVersion != null && selection_outputModelVersion.length() > 0) {
                    ModelMigrationDialog.this.getMigrationSettings().setMigrationModelVersion(selection_outputModelVersion);
                }
            }
        });
        this.mig_model_version_combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = ModelMigrationDialog.this.getMig_model_version_combo().getText();
                if (selection != null && selection.equals("itea.110")) {
                    ModelMigrationDialog.this.getTxtOutputDirectory().setText("");
                    sl_mig_folder_selection_composite.topControl = empty_composite;
                    mig_folder_selection_composite.layout();
                } else {
                    ModelMigrationDialog.this.getTxtOutputDirectory().setText(ModelMigrationDialog.this.getOutputDirectoryLocation());
                    sl_mig_folder_selection_composite.topControl = mig_output_directory_selection_composite;
                    mig_folder_selection_composite.layout();
                }
            }
        });
        this.initDataBindings();
        return shlAmalthea;
    }

    private void addEmptyLabels(Group grpInitialModel) {
        new Label((Composite)grpInitialModel, 0);
        new Label((Composite)grpInitialModel, 0);
        new Label((Composite)grpInitialModel, 0);
    }

    private TableViewerColumn createTableViewerColumn(TableViewer tableViewer, String title) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        column.setWidth(1000);
        return viewerColumn;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.migrateModelsButton = this.createButton(parent, 0, "Migrate Models", true);
        this.migrateModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
                String dateToStr = format.format(new Date());
                File modelMigrationLogFile = new File(ModelMigrationDialog.this.getMigrationSettings().getOutputDirectoryLocation(), "ModelMigration__" + dateToStr + ".log");
                try {
                    ModelMigrationDialog.this.setFileAppender(new FileAppender((Layout)new PatternLayout("%d{yyyy-MM-dd_HH_mm_ss} - %-5p:  %m%n"), modelMigrationLogFile.getAbsolutePath(), false));
                    ModelMigrationDialog.this.getFileAppender().addFilter(new Filter(){

                        public int decide(LoggingEvent event) {
                            if (event.getLevel() == Level.TRACE) {
                                return -1;
                            }
                            return 1;
                        }
                    });
                    ModelMigrationDialog.this.logger.addAppender((Appender)ModelMigrationDialog.this.getFileAppender());
                }
                catch (IOException e1) {
                    ModelMigrationDialog.this.logger.error((Object)("Unable to add FileAppender for model migration logger" + modelMigrationLogFile.getAbsolutePath()), (Throwable)e1);
                }
                ModelMigrationJob job = new ModelMigrationJob("AMALTHEA Model Migration", ModelMigrationDialog.this.getMigrationSettings());
                job.setUser(true);
                job.schedule();
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(final IJobChangeEvent event) {
                        super.done(event);
                        IStatus result = event.getResult();
                        if (result.getCode() == 20) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell shell = new Shell(Display.getDefault());
                                    MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)event.getResult().getMessage());
                                }
                            });
                        } else if (result.getCode() == 30) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell shell = new Shell(Display.getDefault());
                                    ErrorDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)event.getResult().getMessage(), (IStatus)event.getResult());
                                }
                            });
                        } else if (result.equals(Status.OK_STATUS)) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    Shell shell = new Shell(Display.getDefault());
                                    MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA Model Migration", (String)"Model Migration successful !!");
                                    try {
                                        ModelMigrationDialog.this.getMigrationSettings().getiProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                    catch (CoreException e) {
                                        ((this).this).ModelMigrationDialog.this.logger.error((Object)e.getMessage(), (Throwable)e);
                                    }
                                }
                            });
                        }
                        if (ModelMigrationDialog.this.getFileAppender() != null) {
                            ModelMigrationDialog.this.getFileAppender().close();
                            (this).ModelMigrationDialog.this.logger.removeAppender((Appender)ModelMigrationDialog.this.getFileAppender());
                        }
                    }
                });
            }
        });
        this.cancelMigrationButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.cancelMigrationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Job.getJobManager().cancel((Object)"AMALTHEA_MODEL_MIGRATION");
            }
        });
        this.initDataBindings();
    }

    public MigrationSettings getMigrationSettings() {
        return this.migrationSettings;
    }

    public void setMigrationSettings(MigrationSettings migrationSettings) {
        this.migrationSettings = migrationSettings;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IWidgetValueProperty text = WidgetProperties.text((int)24);
        ISWTObservableValue observeTextTxtInputModelVersionObserveWidget = text.observe((Widget)this.txtInputModelVersion);
        IObservableValue inputModelVersionMigDataModelObserveValue = PojoProperties.value((String)"inputModelVersion").observe((Object)this.getMigrationSettings());
        bindingContext.bindValue((IObservableValue)observeTextTxtInputModelVersionObserveWidget, inputModelVersionMigDataModelObserveValue, null, null);
        ISWTObservableValue observeTextTxtOutputDirectoryObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtOutputDirectory);
        IObservableValue outputDirectoryLocationMigDataModelObserveValue = PojoProperties.value((String)"outputDirectoryLocation").observe((Object)this.getMigrationSettings());
        bindingContext.bindValue((IObservableValue)observeTextTxtOutputDirectoryObserveWidget, outputDirectoryLocationMigDataModelObserveValue, null, null);
        ISWTObservableValue observeSelectionMig_model_version_comboObserveWidget = WidgetProperties.selection().observe((Widget)this.mig_model_version_combo);
        IObservableValue migrationModelVersionMigrationSettingsObserveValue = PojoProperties.value((String)"migrationModelVersion").observe((Object)this.migrationSettings);
        bindingContext.bindValue((IObservableValue)observeSelectionMig_model_version_comboObserveWidget, migrationModelVersionMigrationSettingsObserveValue, null, null);
        return bindingContext;
    }

    public Combo getMig_model_version_combo() {
        return this.mig_model_version_combo;
    }

    public void setMig_model_version_combo(Combo mig_model_version_combo) {
        this.mig_model_version_combo = mig_model_version_combo;
    }

    public String getOutputDirectoryLocation() {
        return this.outputDirectoryLocation;
    }

    public void setOutputDirectoryLocation(String outputDirectoryLocation) {
        this.outputDirectoryLocation = outputDirectoryLocation;
    }

    public Text getTxtInputModelVersion() {
        return this.txtInputModelVersion;
    }

    public void setTxtInputModelVersion(Text txtInputModelVersion) {
        this.txtInputModelVersion = txtInputModelVersion;
    }

    public Text getTxtOutputDirectory() {
        return this.txtOutputDirectory;
    }

    public void setTxtOutputDirectory(Text txtOutputDirectory) {
        this.txtOutputDirectory = txtOutputDirectory;
    }

    public Label getLblOutputDirectory() {
        return this.lblOutputDirectory;
    }

    public void setLblOutputDirectory(Label lblOutputDirectory) {
        this.lblOutputDirectory = lblOutputDirectory;
    }

    public Button getCancelMigrationButton() {
        return this.cancelMigrationButton;
    }

    public void setCancelMigrationButton(Button cancelMigrationButton) {
        this.cancelMigrationButton = cancelMigrationButton;
    }

    public FileAppender getFileAppender() {
        return this.fileAppender;
    }

    public void setFileAppender(FileAppender fileAppender) {
        this.fileAppender = fileAppender;
    }
}

