/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.base.IFormatter;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.eclipse.app4mc.amalthea.converters.common.base.IPreProcessor;
import org.eclipse.app4mc.amalthea.converters.common.utils.AbstractHelper;
import org.eclipse.app4mc.amalthea.converters.common.utils.BaseHelperUtils;
import org.eclipse.app4mc.amalthea.converters.common.xpath.utils.ProcessorElement;
import org.eclipse.app4mc.amalthea.converters.ui.utils.ConverterElement;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationSettings;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.jdom2.Document;

public class ModelMigrationJob
extends Job {
    private final MigrationSettings migrationSettings;
    protected AbstractHelper helper;
    private final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public ModelMigrationJob(String name, MigrationSettings migrationSettings) {
        super(name);
        this.migrationSettings = migrationSettings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.setTaskName("Collecting information for intermediate migration steps");
        String inputModelVersion = this.migrationSettings.getInputModelVersion();
        String outputModelVersion = this.migrationSettings.getMigrationModelVersion();
        this.helper = BaseHelperUtils.getInstance();
        List<Map.Entry<String, String>> migStepEntries = this.generateMigrationSteps(inputModelVersion, outputModelVersion);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(migStepEntries.size() + 3));
        subMonitor.worked(1);
        if (migStepEntries.size() == 0) {
            return new Status(8, " org.eclipse.app4mc.amalthea.converters.ui", 20, "Migration not supported for the selected model versions. \nInput Model version : \"" + inputModelVersion + "\" Output Model Version : \"" + outputModelVersion + "\"", null);
        }
        try {
            Map<File, Document> fileName_documentsMap = this.migrationSettings.getMigModelFilesMap();
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.valueOf(System.getProperty("line.separator")) + "***************************************************************************************************************************************" + System.getProperty("line.separator"));
            buffer.append("\t\t Starting model migration for the following AMALTHEA models: " + System.getProperty("line.separator"));
            for (File modelFile : fileName_documentsMap.keySet()) {
                buffer.append("\t\t -- " + modelFile.getAbsolutePath() + System.getProperty("line.separator"));
            }
            buffer.append(String.valueOf(System.getProperty("line.separator")) + "***************************************************************************************************************************************" + System.getProperty("line.separator"));
            this.logger.info((Object)buffer.toString());
            buffer.delete(0, buffer.length());
            subMonitor.setTaskName("invoking pre processors ");
            List<IPreProcessor> preProcessors = this.getAllPreProcessorObjectsFromExtensions(inputModelVersion);
            List<ProcessorElement<IConfigurationElement, List<String>, List<String>>> allPostProcessorObjectsFromExtensions = this.getAllPostProcessorObjectsFromExtensions();
            this.invokeAllPreProcessors(preProcessors, fileName_documentsMap);
            subMonitor.worked(1);
            ArrayList<ConverterElement> allConverters = new ArrayList<ConverterElement>();
            for (Map.Entry<String, String> entry : migStepEntries) {
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                subMonitor.setTaskName("Migrating AMALTHEA models from : " + entry.getKey() + " to " + entry.getValue());
                this.logger.info((Object)("=========== START: Migrating AMALTHEA models from : " + entry.getKey() + " to " + entry.getValue() + " ========== "));
                Collection<ConverterElement> converterObjects = this.executeConversion(fileName_documentsMap, entry.getKey(), entry.getValue());
                allConverters.addAll(converterObjects);
                subMonitor.worked(1);
                this.executePostProcessors(entry, migStepEntries, allPostProcessorObjectsFromExtensions, fileName_documentsMap);
                this.logger.info((Object)("=========== END: Migrating AMALTHEA models from : " + entry.getKey() + " to " + entry.getValue() + "  =========== " + System.getProperty("line.separator")));
            }
            subMonitor.setTaskName("invoking post processors ");
            subMonitor.worked(1);
            if (allConverters.size() > 0) {
                boolean updateFileNames = false;
                if ((inputModelVersion.equals("itea.103") || inputModelVersion.equals("itea.110")) && (outputModelVersion.equals("itea.111") || outputModelVersion.equals("0.7.0") || outputModelVersion.equals("0.7.1") || outputModelVersion.equals("0.7.2") || outputModelVersion.equals("0.8.0"))) {
                    updateFileNames = true;
                }
                this.saveFiles(subMonitor, fileName_documentsMap, updateFileNames);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return new Status(8, " org.eclipse.app4mc.amalthea.converters.ui", 30, "Error during migration ", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private List<Map.Entry<String, String>> generateMigrationSteps(String inputModelVersion, String outputModelVersion) {
        ArrayList<Map.Entry<String, String>> migStepEntries = new ArrayList<Map.Entry<String, String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add("itea.103");
        versions.add("itea.110");
        versions.add("itea.111");
        versions.add("0.7.0");
        versions.add("0.7.1");
        versions.add("0.7.2");
        versions.add("0.8.0");
        int inputModelVersionIndex = versions.indexOf(inputModelVersion);
        int outputModelVersionIndex = versions.indexOf(outputModelVersion);
        if (inputModelVersionIndex != -1 & outputModelVersionIndex != -1) {
            int i = inputModelVersionIndex;
            while (i <= outputModelVersionIndex && i + 1 <= outputModelVersionIndex) {
                AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>((String)versions.get(i), (String)versions.get(i + 1));
                migStepEntries.add(entry);
                ++i;
            }
        }
        return migStepEntries;
    }

    private void saveFiles(SubMonitor subMonitor, Map<File, Document> fileName_documentsMap, boolean updateFileNames) throws Exception {
        ArrayList<File> outputFiles = new ArrayList<File>();
        subMonitor.setTaskName("Saving migrated AMALTHEA model files ");
        Set<File> keySet = fileName_documentsMap.keySet();
        for (File inputFile : keySet) {
            String location;
            int indexOfDot;
            String extension;
            String outputDirectoryLocation = this.migrationSettings.getOutputDirectoryLocation();
            String convertedFileName = inputFile.getName();
            if (updateFileNames && (extension = convertedFileName.substring((indexOfDot = convertedFileName.lastIndexOf(".")) + 1)).startsWith("amxmi") && !extension.equals("amxmi")) {
                convertedFileName = String.valueOf(convertedFileName) + ".amxmi";
            }
            File outputFile = null;
            if (outputDirectoryLocation != null && !outputDirectoryLocation.equals("")) {
                location = String.valueOf(outputDirectoryLocation) + File.separator + convertedFileName;
                this.helper.saveFile(fileName_documentsMap.get(inputFile), location, true, true);
                outputFile = new File(location);
                outputFiles.add(outputFile);
            } else {
                location = String.valueOf(inputFile.getParentFile().getAbsolutePath()) + File.separator + convertedFileName;
                this.helper.saveFile(fileName_documentsMap.get(inputFile), location, true, true);
                outputFile = new File(location);
                outputFiles.add(outputFile);
            }
            this.logger.info((Object)("Migrated model file saved @ : " + outputFile.getAbsolutePath()));
        }
        subMonitor.worked(1);
        subMonitor.setTaskName("Formatting AMALTHEA model files ");
        IFormatter modelFormatter = this.getModelFormatter();
        subMonitor.worked(1);
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.equals("AMALTHEA_MODEL_MIGRATION")) {
            return true;
        }
        return super.belongsTo(family);
    }

    protected void executeConversion(IConverter converter, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        for (File file : fileName_documentsMap.keySet()) {
            converter.convert(file, fileName_documentsMap, caches);
        }
    }

    protected IConfigurationElement[] getAllConverterExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters");
        IConfigurationElement[] extensions = extensionPoint.getConfigurationElements();
        return extensions;
    }

    protected List<ICache> getAllCacheObjectsFromExtensions(String inputModelVersion) throws CoreException {
        IConfigurationElement[] extensions;
        ArrayList<ICache> caches = new ArrayList<ICache>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters.cachebuilders");
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionPoint.getConfigurationElements();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String definedInputModelVersion = iConfigurationElement.getAttribute("input-model-version");
            if (definedInputModelVersion.equals(inputModelVersion)) {
                Object cacheBuilder = iConfigurationElement.createExecutableExtension("class");
                caches.add((ICache)cacheBuilder);
            }
            ++n2;
        }
        return caches;
    }

    protected List<IPreProcessor> getAllPreProcessorObjectsFromExtensions(String ... inputModelVersions) throws CoreException {
        IConfigurationElement[] extensions;
        ArrayList<IPreProcessor> preProcessors = new ArrayList<IPreProcessor>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters.preprocessor");
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionPoint.getConfigurationElements();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            ArrayList<String> definedModelVersions = new ArrayList<String>();
            Object[] objectArray = children = iConfigurationElement.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement childConfigurationElement = objectArray[n4];
                String attrib = childConfigurationElement.getAttribute("version");
                if (attrib != null) {
                    definedModelVersions.add(attrib);
                }
                ++n4;
            }
            objectArray = inputModelVersions;
            n3 = inputModelVersions.length;
            n4 = 0;
            block2: while (n4 < n3) {
                IConfigurationElement inputModelVersion = objectArray[n4];
                for (String definedModelVersion : definedModelVersions) {
                    if (!definedModelVersion.equals(inputModelVersion)) continue;
                    Object preProcessor = iConfigurationElement.createExecutableExtension("class");
                    preProcessors.add((IPreProcessor)preProcessor);
                    break block2;
                }
                ++n4;
            }
            ++n2;
        }
        return preProcessors;
    }

    private void executePostProcessors(Map.Entry<String, String> executionEntry, List<Map.Entry<String, String>> allEntries, List<ProcessorElement<IConfigurationElement, List<String>, List<String>>> allPostProcessors, Map<File, Document> fileName_documentsMap) throws Exception {
        List<ProcessorElement<IConfigurationElement, List<String>, List<String>>> matchingProcessorElements = this.getMatchingPostProcessorElements(this.getAllInputVersionsFromMigrationsEntries(executionEntry, allEntries), this.getAllOutputVersionsFromMigrationsEntries(executionEntry, allEntries), allPostProcessors);
        ArrayList<ProcessorElement<IConfigurationElement, List<String>, List<String>>> matchingProcessorElementsForOtherEntries = new ArrayList<ProcessorElement<IConfigurationElement, List<String>, List<String>>>();
        int indexOf = allEntries.indexOf(executionEntry);
        if (indexOf != -1) {
            int i = indexOf + 1;
            while (i < allEntries.size()) {
                Map.Entry<String, String> nextEntry = allEntries.get(i);
                matchingProcessorElementsForOtherEntries.addAll(this.getMatchingPostProcessorElements(this.getAllInputVersionsFromMigrationsEntries(nextEntry, allEntries), this.getAllOutputVersionsFromMigrationsEntries(nextEntry, allEntries), allPostProcessors));
                ++i;
            }
        }
        matchingProcessorElements.removeAll(matchingProcessorElementsForOtherEntries);
        for (ProcessorElement<IConfigurationElement, List<String>, List<String>> processorElement : matchingProcessorElements) {
            IConfigurationElement iConfigurationElement = (IConfigurationElement)processorElement.getConfigurationElement();
            Object postProcessor = iConfigurationElement.createExecutableExtension("class");
            ((IPostProcessor)postProcessor).process(fileName_documentsMap, this.helper);
        }
    }

    private List<String> getAllInputVersionsFromMigrationsEntries(Map.Entry<String, String> entry, List<Map.Entry<String, String>> allEntries) {
        ArrayList<String> keys = new ArrayList<String>();
        int i = allEntries.indexOf(entry);
        while (i < allEntries.size() && i != -1) {
            keys.add(allEntries.get(i).getKey());
            ++i;
        }
        return keys;
    }

    private List<String> getAllOutputVersionsFromMigrationsEntries(Map.Entry<String, String> entry, List<Map.Entry<String, String>> allEntries) {
        ArrayList<String> values = new ArrayList<String>();
        int i = allEntries.indexOf(entry);
        while (i < allEntries.size() && i != -1) {
            values.add(allEntries.get(i).getValue());
            ++i;
        }
        return values;
    }

    private List<ProcessorElement<IConfigurationElement, List<String>, List<String>>> getMatchingPostProcessorElements(List<String> inputVersions, List<String> outputVersions, List<ProcessorElement<IConfigurationElement, List<String>, List<String>>> allPostProcessors) {
        ArrayList<ProcessorElement<IConfigurationElement, List<String>, List<String>>> matchingElements = new ArrayList<ProcessorElement<IConfigurationElement, List<String>, List<String>>>();
        for (ProcessorElement<IConfigurationElement, List<String>, List<String>> processorElement : allPostProcessors) {
            boolean isOutputVersionFound;
            boolean isInputVersionFound = processorElement.getInputVersions() != null && !Collections.disjoint((Collection)processorElement.getInputVersions(), inputVersions);
            boolean bl = isOutputVersionFound = processorElement.getOutputVersions() != null && !Collections.disjoint((Collection)processorElement.getOutputVersions(), outputVersions);
            if (!isInputVersionFound || !isOutputVersionFound) continue;
            matchingElements.add(processorElement);
        }
        return matchingElements;
    }

    protected List<ProcessorElement<IConfigurationElement, List<String>, List<String>>> getAllPostProcessorObjectsFromExtensions() {
        IConfigurationElement[] extensions;
        ArrayList<ProcessorElement<IConfigurationElement, List<String>, List<String>>> postProcessors = new ArrayList<ProcessorElement<IConfigurationElement, List<String>, List<String>>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters.postprocessor");
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionPoint.getConfigurationElements();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            ArrayList<String> definedInputModelVersions = new ArrayList<String>();
            ArrayList<String> definedOutputModelVersions = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray2 = children = iConfigurationElement.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement childConfigurationElement = iConfigurationElementArray2[n4];
                String attrib = childConfigurationElement.getAttribute("version");
                if (attrib != null) {
                    if (childConfigurationElement.getName().equals("input-model-version")) {
                        definedInputModelVersions.add(attrib);
                    } else if (childConfigurationElement.getName().equals("output-model-version")) {
                        definedOutputModelVersions.add(attrib);
                    }
                }
                ++n4;
            }
            postProcessors.add((ProcessorElement<IConfigurationElement, List<String>, List<String>>)new ProcessorElement((Object)iConfigurationElement, definedInputModelVersions, definedOutputModelVersions));
            ++n2;
        }
        return postProcessors;
    }

    protected void invokeAllPreProcessors(List<IPreProcessor> preProcessors, Map<File, Document> fileName_documentsMap) throws Exception {
        for (IPreProcessor preProcessor : preProcessors) {
            for (File file : fileName_documentsMap.keySet()) {
                preProcessor.process(file, fileName_documentsMap);
            }
        }
    }

    protected void invokeAllCacheBuilders(List<ICache> caches, Map<File, Document> fileName_documentsMap) {
        for (ICache iCache : caches) {
            iCache.buildCache(fileName_documentsMap);
        }
    }

    protected Collection<ConverterElement> getEnabledConverterObjects(IConfigurationElement[] extensions, String inputModelVersion, String outputModelVersion) throws CoreException {
        HashMap<String, ConverterElement> converterElementsMap = new HashMap<String, ConverterElement>();
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String isEnabled = iConfigurationElement.getAttribute("enabled");
            if ("true".equals(isEnabled)) {
                String id = iConfigurationElement.getAttribute("id");
                String definedInputModelVersion = iConfigurationElement.getAttribute("input-model-version");
                String definedOutputModelVersion = iConfigurationElement.getAttribute("output-model-version");
                if (inputModelVersion.equals(definedInputModelVersion) && outputModelVersion.equals(definedOutputModelVersion)) {
                    IConfigurationElement[] children;
                    Object converterObject = iConfigurationElement.createExecutableExtension("converter-class");
                    ConverterElement converterElement = new ConverterElement(id, (IConverter)converterObject);
                    converterElementsMap.put(id, converterElement);
                    IConfigurationElement[] iConfigurationElementArray2 = children = iConfigurationElement.getChildren("dependent-on-converter");
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement childConfigurationElement = iConfigurationElementArray2[n4];
                        String dependentOnConverterID = childConfigurationElement.getAttribute("id");
                        if (dependentOnConverterID != null) {
                            converterElement.addDependentOnConverterID(dependentOnConverterID);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        if (converterElementsMap.size() > 0) {
            for (String converterID : converterElementsMap.keySet()) {
                ConverterElement converterElement = (ConverterElement)converterElementsMap.get(converterID);
                List<String> idsOfDependentOnConverters = converterElement.getIDSofDependentOnConverters();
                for (String idOfDependentOnConverter : idsOfDependentOnConverters) {
                    converterElement.addRequiredConverter((ConverterElement)converterElementsMap.get(idOfDependentOnConverter));
                }
            }
        }
        return converterElementsMap.values();
    }

    protected void invokeAllConvertersHeirarchially(Collection<ConverterElement> converterObjects, List<String> iconverters, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        for (ConverterElement converterElement : converterObjects) {
            if (converterElement.isCompleted() || iconverters.contains(converterElement.getID())) continue;
            List<ConverterElement> requiredConverters = converterElement.getRequiredConverters();
            this.invokeAllConvertersHeirarchially(requiredConverters, iconverters, fileName_documentsMap, caches);
            this.executeConversion(converterElement.getConverterObject(), fileName_documentsMap, caches);
            converterElement.setCompleted(true);
            iconverters.add(converterElement.getID());
        }
    }

    protected Collection<ConverterElement> executeConversion(Map<File, Document> fileName_documentsMap, String inputModelVersion, String outputModelVersion) throws CoreException, Exception {
        List<ICache> caches = this.getAllCacheObjectsFromExtensions(inputModelVersion);
        this.logger.trace((Object)("Start : Building cache for AMALTHEA models present in : " + inputModelVersion));
        long st = System.currentTimeMillis();
        this.invokeAllCacheBuilders(caches, fileName_documentsMap);
        long end = System.currentTimeMillis();
        this.logger.trace((Object)("End : Building cache for AMALTHEA models present in : " + inputModelVersion));
        this.logger.trace((Object)("Total time taken to build cache for " + inputModelVersion + " models:  " + (end - st) + "milli seconds"));
        IConfigurationElement[] allConverterExtensions = this.getAllConverterExtensions();
        Collection<ConverterElement> converterObjects = this.getEnabledConverterObjects(allConverterExtensions, inputModelVersion, outputModelVersion);
        this.invokeAllConvertersHeirarchially(converterObjects, new ArrayList<String>(), fileName_documentsMap, caches);
        return converterObjects;
    }

    protected IFormatter getModelFormatter() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return null;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.app4mc.amalthea.model.converters.formatter");
        if (extensionPoint != null) {
            IConfigurationElement[] extensions;
            IConfigurationElement[] iConfigurationElementArray = extensions = extensionPoint.getConfigurationElements();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                try {
                    Object iConverter = iConfigurationElement.createExecutableExtension("class");
                    return (IFormatter)iConverter;
                }
                catch (CoreException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                    ++n2;
                }
            }
        }
        return null;
    }
}

