/**
 * *******************************************************************************
 *  Copyright (c) 2017 Robert Bosch GmbH and others.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */
package org.eclipse.app4mc.amalthea.model;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.app4mc.amalthea.model.AmaltheaPackage
 * @generated
 */
public interface AmaltheaFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AmaltheaFactory eINSTANCE = org.eclipse.app4mc.amalthea.model.impl.AmaltheaFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Amalthea</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Amalthea</em>'.
	 * @generated
	 */
	Amalthea createAmalthea();

	/**
	 * Returns a new object of class '<em>Common Elements</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Common Elements</em>'.
	 * @generated
	 */
	CommonElements createCommonElements();

	/**
	 * Returns a new object of class '<em>Tag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tag</em>'.
	 * @generated
	 */
	Tag createTag();

	/**
	 * Returns a new object of class '<em>Core Classifier</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Core Classifier</em>'.
	 * @generated
	 */
	CoreClassifier createCoreClassifier();

	/**
	 * Returns a new object of class '<em>Memory Classifier</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory Classifier</em>'.
	 * @generated
	 */
	MemoryClassifier createMemoryClassifier();

	/**
	 * Returns a new object of class '<em>Transmission Policy</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transmission Policy</em>'.
	 * @generated
	 */
	TransmissionPolicy createTransmissionPolicy();

	/**
	 * Returns a new object of class '<em>Instructions Deviation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Instructions Deviation</em>'.
	 * @generated
	 */
	InstructionsDeviation createInstructionsDeviation();

	/**
	 * Returns a new object of class '<em>Instructions Constant</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Instructions Constant</em>'.
	 * @generated
	 */
	InstructionsConstant createInstructionsConstant();

	/**
	 * Returns a new object of class '<em>Time</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time</em>'.
	 * @generated
	 */
	Time createTime();

	/**
	 * Returns a new object of class '<em>Frequency</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Frequency</em>'.
	 * @generated
	 */
	Frequency createFrequency();

	/**
	 * Returns a new object of class '<em>Data Size</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Size</em>'.
	 * @generated
	 */
	DataSize createDataSize();

	/**
	 * Returns a new object of class '<em>Data Rate</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Rate</em>'.
	 * @generated
	 */
	DataRate createDataRate();

	/**
	 * Returns a new object of class '<em>List Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>List Object</em>'.
	 * @generated
	 */
	ListObject createListObject();

	/**
	 * Returns a new object of class '<em>String Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>String Object</em>'.
	 * @generated
	 */
	StringObject createStringObject();

	/**
	 * Returns a new object of class '<em>Big Integer Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Big Integer Object</em>'.
	 * @generated
	 */
	BigIntegerObject createBigIntegerObject();

	/**
	 * Returns a new object of class '<em>Reference Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Reference Object</em>'.
	 * @generated
	 */
	ReferenceObject createReferenceObject();

	/**
	 * Returns a new object of class '<em>Integer Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Integer Object</em>'.
	 * @generated
	 */
	IntegerObject createIntegerObject();

	/**
	 * Returns a new object of class '<em>Long Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Long Object</em>'.
	 * @generated
	 */
	LongObject createLongObject();

	/**
	 * Returns a new object of class '<em>Float Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Float Object</em>'.
	 * @generated
	 */
	FloatObject createFloatObject();

	/**
	 * Returns a new object of class '<em>Double Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Double Object</em>'.
	 * @generated
	 */
	DoubleObject createDoubleObject();

	/**
	 * Returns a new object of class '<em>Boolean Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Boolean Object</em>'.
	 * @generated
	 */
	BooleanObject createBooleanObject();

	/**
	 * Returns a new object of class '<em>Time Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Object</em>'.
	 * @generated
	 */
	TimeObject createTimeObject();

	/**
	 * Returns a new object of class '<em>Deviation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Deviation</em>'.
	 * @generated
	 */
	<T> Deviation<T> createDeviation();

	/**
	 * Returns a new object of class '<em>Weibull Parameters</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Weibull Parameters</em>'.
	 * @generated
	 */
	<T> WeibullParameters<T> createWeibullParameters();

	/**
	 * Returns a new object of class '<em>Weibull Estimators</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Weibull Estimators</em>'.
	 * @generated
	 */
	<T> WeibullEstimators<T> createWeibullEstimators();

	/**
	 * Returns a new object of class '<em>Uniform Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Uniform Distribution</em>'.
	 * @generated
	 */
	<T> UniformDistribution<T> createUniformDistribution();

	/**
	 * Returns a new object of class '<em>Boundaries</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Boundaries</em>'.
	 * @generated
	 */
	<T> Boundaries<T> createBoundaries();

	/**
	 * Returns a new object of class '<em>Gauss Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Gauss Distribution</em>'.
	 * @generated
	 */
	<T> GaussDistribution<T> createGaussDistribution();

	/**
	 * Returns a new object of class '<em>Beta Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Beta Distribution</em>'.
	 * @generated
	 */
	<T> BetaDistribution<T> createBetaDistribution();

	/**
	 * Returns a new object of class '<em>Min Avg Max Statistic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Min Avg Max Statistic</em>'.
	 * @generated
	 */
	MinAvgMaxStatistic createMinAvgMaxStatistic();

	/**
	 * Returns a new object of class '<em>Single Value Statistic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single Value Statistic</em>'.
	 * @generated
	 */
	SingleValueStatistic createSingleValueStatistic();

	/**
	 * Returns a new object of class '<em>Mode</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode</em>'.
	 * @generated
	 */
	Mode createMode();

	/**
	 * Returns a new object of class '<em>Mode Literal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Literal</em>'.
	 * @generated
	 */
	ModeLiteral createModeLiteral();

	/**
	 * Returns a new object of class '<em>Components Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Components Model</em>'.
	 * @generated
	 */
	ComponentsModel createComponentsModel();

	/**
	 * Returns a new object of class '<em>Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component</em>'.
	 * @generated
	 */
	Component createComponent();

	/**
	 * Returns a new object of class '<em>Composite</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite</em>'.
	 * @generated
	 */
	Composite createComposite();

	/**
	 * Returns a new object of class '<em>System</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>System</em>'.
	 * @generated
	 */
	System createSystem();

	/**
	 * Returns a new object of class '<em>Component Instance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component Instance</em>'.
	 * @generated
	 */
	ComponentInstance createComponentInstance();

	/**
	 * Returns a new object of class '<em>Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Connector</em>'.
	 * @generated
	 */
	Connector createConnector();

	/**
	 * Returns a new object of class '<em>Qualified Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Qualified Port</em>'.
	 * @generated
	 */
	QualifiedPort createQualifiedPort();

	/**
	 * Returns a new object of class '<em>FInterface Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>FInterface Port</em>'.
	 * @generated
	 */
	FInterfacePort createFInterfacePort();

	/**
	 * Returns a new object of class '<em>Config Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Config Model</em>'.
	 * @generated
	 */
	ConfigModel createConfigModel();

	/**
	 * Returns a new object of class '<em>Event Config</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Config</em>'.
	 * @generated
	 */
	EventConfig createEventConfig();

	/**
	 * Returns a new object of class '<em>Constraints Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constraints Model</em>'.
	 * @generated
	 */
	ConstraintsModel createConstraintsModel();

	/**
	 * Returns a new object of class '<em>Runnable Sequencing Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Sequencing Constraint</em>'.
	 * @generated
	 */
	RunnableSequencingConstraint createRunnableSequencingConstraint();

	/**
	 * Returns a new object of class '<em>Process Runnable Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Runnable Group</em>'.
	 * @generated
	 */
	ProcessRunnableGroup createProcessRunnableGroup();

	/**
	 * Returns a new object of class '<em>Runnable Separation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Separation Constraint</em>'.
	 * @generated
	 */
	RunnableSeparationConstraint createRunnableSeparationConstraint();

	/**
	 * Returns a new object of class '<em>Process Separation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Separation Constraint</em>'.
	 * @generated
	 */
	ProcessSeparationConstraint createProcessSeparationConstraint();

	/**
	 * Returns a new object of class '<em>Data Separation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Separation Constraint</em>'.
	 * @generated
	 */
	DataSeparationConstraint createDataSeparationConstraint();

	/**
	 * Returns a new object of class '<em>Runnable Pairing Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Pairing Constraint</em>'.
	 * @generated
	 */
	RunnablePairingConstraint createRunnablePairingConstraint();

	/**
	 * Returns a new object of class '<em>Process Pairing Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Pairing Constraint</em>'.
	 * @generated
	 */
	ProcessPairingConstraint createProcessPairingConstraint();

	/**
	 * Returns a new object of class '<em>Data Pairing Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Pairing Constraint</em>'.
	 * @generated
	 */
	DataPairingConstraint createDataPairingConstraint();

	/**
	 * Returns a new object of class '<em>Target Memory</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Target Memory</em>'.
	 * @generated
	 */
	TargetMemory createTargetMemory();

	/**
	 * Returns a new object of class '<em>Target Core</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Target Core</em>'.
	 * @generated
	 */
	TargetCore createTargetCore();

	/**
	 * Returns a new object of class '<em>Target Scheduler</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Target Scheduler</em>'.
	 * @generated
	 */
	TargetScheduler createTargetScheduler();

	/**
	 * Returns a new object of class '<em>Label Entity Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Entity Group</em>'.
	 * @generated
	 */
	LabelEntityGroup createLabelEntityGroup();

	/**
	 * Returns a new object of class '<em>Runnable Entity Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Entity Group</em>'.
	 * @generated
	 */
	RunnableEntityGroup createRunnableEntityGroup();

	/**
	 * Returns a new object of class '<em>Process Entity Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Entity Group</em>'.
	 * @generated
	 */
	ProcessEntityGroup createProcessEntityGroup();

	/**
	 * Returns a new object of class '<em>Tag Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tag Group</em>'.
	 * @generated
	 */
	TagGroup createTagGroup();

	/**
	 * Returns a new object of class '<em>Event Chain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain</em>'.
	 * @generated
	 */
	EventChain createEventChain();

	/**
	 * Returns a new object of class '<em>Event Chain Reference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain Reference</em>'.
	 * @generated
	 */
	EventChainReference createEventChainReference();

	/**
	 * Returns a new object of class '<em>Sub Event Chain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Event Chain</em>'.
	 * @generated
	 */
	SubEventChain createSubEventChain();

	/**
	 * Returns a new object of class '<em>Physical Section Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Physical Section Constraint</em>'.
	 * @generated
	 */
	PhysicalSectionConstraint createPhysicalSectionConstraint();

	/**
	 * Returns a new object of class '<em>Event Synchronization Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Synchronization Constraint</em>'.
	 * @generated
	 */
	EventSynchronizationConstraint createEventSynchronizationConstraint();

	/**
	 * Returns a new object of class '<em>Event Chain Synchronization Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain Synchronization Constraint</em>'.
	 * @generated
	 */
	EventChainSynchronizationConstraint createEventChainSynchronizationConstraint();

	/**
	 * Returns a new object of class '<em>Delay Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Delay Constraint</em>'.
	 * @generated
	 */
	DelayConstraint createDelayConstraint();

	/**
	 * Returns a new object of class '<em>Event Chain Latency Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain Latency Constraint</em>'.
	 * @generated
	 */
	EventChainLatencyConstraint createEventChainLatencyConstraint();

	/**
	 * Returns a new object of class '<em>Repetition Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Repetition Constraint</em>'.
	 * @generated
	 */
	RepetitionConstraint createRepetitionConstraint();

	/**
	 * Returns a new object of class '<em>Data Age Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Age Constraint</em>'.
	 * @generated
	 */
	DataAgeConstraint createDataAgeConstraint();

	/**
	 * Returns a new object of class '<em>Data Age Cycle</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Age Cycle</em>'.
	 * @generated
	 */
	DataAgeCycle createDataAgeCycle();

	/**
	 * Returns a new object of class '<em>Data Age Time</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Age Time</em>'.
	 * @generated
	 */
	DataAgeTime createDataAgeTime();

	/**
	 * Returns a new object of class '<em>Process Requirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Requirement</em>'.
	 * @generated
	 */
	ProcessRequirement createProcessRequirement();

	/**
	 * Returns a new object of class '<em>Runnable Requirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Requirement</em>'.
	 * @generated
	 */
	RunnableRequirement createRunnableRequirement();

	/**
	 * Returns a new object of class '<em>Architecture Requirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Architecture Requirement</em>'.
	 * @generated
	 */
	ArchitectureRequirement createArchitectureRequirement();

	/**
	 * Returns a new object of class '<em>Process Chain Requirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Chain Requirement</em>'.
	 * @generated
	 */
	ProcessChainRequirement createProcessChainRequirement();

	/**
	 * Returns a new object of class '<em>CPU Percentage Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CPU Percentage Requirement Limit</em>'.
	 * @generated
	 */
	CPUPercentageRequirementLimit createCPUPercentageRequirementLimit();

	/**
	 * Returns a new object of class '<em>Frequency Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Frequency Requirement Limit</em>'.
	 * @generated
	 */
	FrequencyRequirementLimit createFrequencyRequirementLimit();

	/**
	 * Returns a new object of class '<em>Percentage Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Percentage Requirement Limit</em>'.
	 * @generated
	 */
	PercentageRequirementLimit createPercentageRequirementLimit();

	/**
	 * Returns a new object of class '<em>Count Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Count Requirement Limit</em>'.
	 * @generated
	 */
	CountRequirementLimit createCountRequirementLimit();

	/**
	 * Returns a new object of class '<em>Time Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Requirement Limit</em>'.
	 * @generated
	 */
	TimeRequirementLimit createTimeRequirementLimit();

	/**
	 * Returns a new object of class '<em>Data Coherency Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Coherency Group</em>'.
	 * @generated
	 */
	DataCoherencyGroup createDataCoherencyGroup();

	/**
	 * Returns a new object of class '<em>Data Stability Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Stability Group</em>'.
	 * @generated
	 */
	DataStabilityGroup createDataStabilityGroup();

	/**
	 * Returns a new object of class '<em>Process Scope</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Scope</em>'.
	 * @generated
	 */
	ProcessScope createProcessScope();

	/**
	 * Returns a new object of class '<em>Runnable Scope</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Scope</em>'.
	 * @generated
	 */
	RunnableScope createRunnableScope();

	/**
	 * Returns a new object of class '<em>Component Scope</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component Scope</em>'.
	 * @generated
	 */
	ComponentScope createComponentScope();

	/**
	 * Returns a new object of class '<em>Event Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Model</em>'.
	 * @generated
	 */
	EventModel createEventModel();

	/**
	 * Returns a new object of class '<em>Event Set</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Set</em>'.
	 * @generated
	 */
	EventSet createEventSet();

	/**
	 * Returns a new object of class '<em>Custom Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Event</em>'.
	 * @generated
	 */
	CustomEvent createCustomEvent();

	/**
	 * Returns a new object of class '<em>Stimulus Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Stimulus Event</em>'.
	 * @generated
	 */
	StimulusEvent createStimulusEvent();

	/**
	 * Returns a new object of class '<em>Process Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Event</em>'.
	 * @generated
	 */
	ProcessEvent createProcessEvent();

	/**
	 * Returns a new object of class '<em>Process Chain Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Chain Event</em>'.
	 * @generated
	 */
	ProcessChainEvent createProcessChainEvent();

	/**
	 * Returns a new object of class '<em>Runnable Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Event</em>'.
	 * @generated
	 */
	RunnableEvent createRunnableEvent();

	/**
	 * Returns a new object of class '<em>Label Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Event</em>'.
	 * @generated
	 */
	LabelEvent createLabelEvent();

	/**
	 * Returns a new object of class '<em>Channel Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Channel Event</em>'.
	 * @generated
	 */
	ChannelEvent createChannelEvent();

	/**
	 * Returns a new object of class '<em>Semaphore Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Semaphore Event</em>'.
	 * @generated
	 */
	SemaphoreEvent createSemaphoreEvent();

	/**
	 * Returns a new object of class '<em>HW Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>HW Model</em>'.
	 * @generated
	 */
	HWModel createHWModel();

	/**
	 * Returns a new object of class '<em>Hw System</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw System</em>'.
	 * @generated
	 */
	HwSystem createHwSystem();

	/**
	 * Returns a new object of class '<em>ECU</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ECU</em>'.
	 * @generated
	 */
	ECU createECU();

	/**
	 * Returns a new object of class '<em>Microcontroller</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Microcontroller</em>'.
	 * @generated
	 */
	Microcontroller createMicrocontroller();

	/**
	 * Returns a new object of class '<em>Core</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Core</em>'.
	 * @generated
	 */
	Core createCore();

	/**
	 * Returns a new object of class '<em>Memory</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory</em>'.
	 * @generated
	 */
	Memory createMemory();

	/**
	 * Returns a new object of class '<em>Network</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Network</em>'.
	 * @generated
	 */
	Network createNetwork();

	/**
	 * Returns a new object of class '<em>Quartz</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Quartz</em>'.
	 * @generated
	 */
	Quartz createQuartz();

	/**
	 * Returns a new object of class '<em>Hw Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Component</em>'.
	 * @generated
	 */
	HwComponent createHwComponent();

	/**
	 * Returns a new object of class '<em>System Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>System Type</em>'.
	 * @generated
	 */
	SystemType createSystemType();

	/**
	 * Returns a new object of class '<em>ECU Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ECU Type</em>'.
	 * @generated
	 */
	ECUType createECUType();

	/**
	 * Returns a new object of class '<em>Microcontroller Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Microcontroller Type</em>'.
	 * @generated
	 */
	MicrocontrollerType createMicrocontrollerType();

	/**
	 * Returns a new object of class '<em>Core Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Core Type</em>'.
	 * @generated
	 */
	CoreType createCoreType();

	/**
	 * Returns a new object of class '<em>Memory Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory Type</em>'.
	 * @generated
	 */
	MemoryType createMemoryType();

	/**
	 * Returns a new object of class '<em>Network Type</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Network Type</em>'.
	 * @generated
	 */
	NetworkType createNetworkType();

	/**
	 * Returns a new object of class '<em>Hw Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Port</em>'.
	 * @generated
	 */
	HwPort createHwPort();

	/**
	 * Returns a new object of class '<em>Pin</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pin</em>'.
	 * @generated
	 */
	Pin createPin();

	/**
	 * Returns a new object of class '<em>Complex Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Complex Port</em>'.
	 * @generated
	 */
	ComplexPort createComplexPort();

	/**
	 * Returns a new object of class '<em>Complex Pin</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Complex Pin</em>'.
	 * @generated
	 */
	ComplexPin createComplexPin();

	/**
	 * Returns a new object of class '<em>Prescaler</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Prescaler</em>'.
	 * @generated
	 */
	Prescaler createPrescaler();

	/**
	 * Returns a new object of class '<em>Crossbar Switch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Crossbar Switch</em>'.
	 * @generated
	 */
	CrossbarSwitch createCrossbarSwitch();

	/**
	 * Returns a new object of class '<em>Bus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bus</em>'.
	 * @generated
	 */
	Bus createBus();

	/**
	 * Returns a new object of class '<em>Bridge</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Bridge</em>'.
	 * @generated
	 */
	Bridge createBridge();

	/**
	 * Returns a new object of class '<em>Latency Access Path</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Latency Access Path</em>'.
	 * @generated
	 */
	LatencyAccessPath createLatencyAccessPath();

	/**
	 * Returns a new object of class '<em>Hw Access Path</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Access Path</em>'.
	 * @generated
	 */
	HwAccessPath createHwAccessPath();

	/**
	 * Returns a new object of class '<em>Access Path Ref</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Access Path Ref</em>'.
	 * @generated
	 */
	AccessPathRef createAccessPathRef();

	/**
	 * Returns a new object of class '<em>Latency Constant</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Latency Constant</em>'.
	 * @generated
	 */
	LatencyConstant createLatencyConstant();

	/**
	 * Returns a new object of class '<em>Latency Deviation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Latency Deviation</em>'.
	 * @generated
	 */
	LatencyDeviation createLatencyDeviation();

	/**
	 * Returns a new object of class '<em>Hw Access Path Ref</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Access Path Ref</em>'.
	 * @generated
	 */
	HwAccessPathRef createHwAccessPathRef();

	/**
	 * Returns a new object of class '<em>Hw Element Ref</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Element Ref</em>'.
	 * @generated
	 */
	HwElementRef createHwElementRef();

	/**
	 * Returns a new object of class '<em>Mapping Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mapping Model</em>'.
	 * @generated
	 */
	MappingModel createMappingModel();

	/**
	 * Returns a new object of class '<em>Core Allocation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Core Allocation</em>'.
	 * @generated
	 */
	CoreAllocation createCoreAllocation();

	/**
	 * Returns a new object of class '<em>Task Allocation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Task Allocation</em>'.
	 * @generated
	 */
	TaskAllocation createTaskAllocation();

	/**
	 * Returns a new object of class '<em>ISR Allocation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISR Allocation</em>'.
	 * @generated
	 */
	ISRAllocation createISRAllocation();

	/**
	 * Returns a new object of class '<em>Runnable Allocation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Allocation</em>'.
	 * @generated
	 */
	RunnableAllocation createRunnableAllocation();

	/**
	 * Returns a new object of class '<em>Memory Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory Mapping</em>'.
	 * @generated
	 */
	MemoryMapping createMemoryMapping();

	/**
	 * Returns a new object of class '<em>Physical Section Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Physical Section Mapping</em>'.
	 * @generated
	 */
	PhysicalSectionMapping createPhysicalSectionMapping();

	/**
	 * Returns a new object of class '<em>OS Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>OS Model</em>'.
	 * @generated
	 */
	OSModel createOSModel();

	/**
	 * Returns a new object of class '<em>Os Data Consistency</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os Data Consistency</em>'.
	 * @generated
	 */
	OsDataConsistency createOsDataConsistency();

	/**
	 * Returns a new object of class '<em>Data Stability</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Stability</em>'.
	 * @generated
	 */
	DataStability createDataStability();

	/**
	 * Returns a new object of class '<em>Non Atomic Data Coherency</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Non Atomic Data Coherency</em>'.
	 * @generated
	 */
	NonAtomicDataCoherency createNonAtomicDataCoherency();

	/**
	 * Returns a new object of class '<em>Semaphore</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Semaphore</em>'.
	 * @generated
	 */
	Semaphore createSemaphore();

	/**
	 * Returns a new object of class '<em>OSEK</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>OSEK</em>'.
	 * @generated
	 */
	OSEK createOSEK();

	/**
	 * Returns a new object of class '<em>Partly PFair PD2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Partly PFair PD2</em>'.
	 * @generated
	 */
	PartlyPFairPD2 createPartlyPFairPD2();

	/**
	 * Returns a new object of class '<em>Pfair PD2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pfair PD2</em>'.
	 * @generated
	 */
	PfairPD2 createPfairPD2();

	/**
	 * Returns a new object of class '<em>Partly Early Release Fair PD2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Partly Early Release Fair PD2</em>'.
	 * @generated
	 */
	PartlyEarlyReleaseFairPD2 createPartlyEarlyReleaseFairPD2();

	/**
	 * Returns a new object of class '<em>Early Release Fair PD2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Early Release Fair PD2</em>'.
	 * @generated
	 */
	EarlyReleaseFairPD2 createEarlyReleaseFairPD2();

	/**
	 * Returns a new object of class '<em>Least Local Remaining Execution Time First</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Least Local Remaining Execution Time First</em>'.
	 * @generated
	 */
	LeastLocalRemainingExecutionTimeFirst createLeastLocalRemainingExecutionTimeFirst();

	/**
	 * Returns a new object of class '<em>Earliest Deadline First</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Earliest Deadline First</em>'.
	 * @generated
	 */
	EarliestDeadlineFirst createEarliestDeadlineFirst();

	/**
	 * Returns a new object of class '<em>Deadline Monotonic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Deadline Monotonic</em>'.
	 * @generated
	 */
	DeadlineMonotonic createDeadlineMonotonic();

	/**
	 * Returns a new object of class '<em>Rate Monotonic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rate Monotonic</em>'.
	 * @generated
	 */
	RateMonotonic createRateMonotonic();

	/**
	 * Returns a new object of class '<em>Priority Based Round Robin</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Priority Based Round Robin</em>'.
	 * @generated
	 */
	PriorityBasedRoundRobin createPriorityBasedRoundRobin();

	/**
	 * Returns a new object of class '<em>User Specific Scheduling Algorithm</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>User Specific Scheduling Algorithm</em>'.
	 * @generated
	 */
	UserSpecificSchedulingAlgorithm createUserSpecificSchedulingAlgorithm();

	/**
	 * Returns a new object of class '<em>Priority Based</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Priority Based</em>'.
	 * @generated
	 */
	PriorityBased createPriorityBased();

	/**
	 * Returns a new object of class '<em>Algorithm Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Algorithm Parameter</em>'.
	 * @generated
	 */
	AlgorithmParameter createAlgorithmParameter();

	/**
	 * Returns a new object of class '<em>Scheduling HW Unit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scheduling HW Unit</em>'.
	 * @generated
	 */
	SchedulingHWUnit createSchedulingHWUnit();

	/**
	 * Returns a new object of class '<em>Scheduling SW Unit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scheduling SW Unit</em>'.
	 * @generated
	 */
	SchedulingSWUnit createSchedulingSWUnit();

	/**
	 * Returns a new object of class '<em>Operating System</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operating System</em>'.
	 * @generated
	 */
	OperatingSystem createOperatingSystem();

	/**
	 * Returns a new object of class '<em>Vendor Operating System</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vendor Operating System</em>'.
	 * @generated
	 */
	VendorOperatingSystem createVendorOperatingSystem();

	/**
	 * Returns a new object of class '<em>Task Scheduler</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Task Scheduler</em>'.
	 * @generated
	 */
	TaskScheduler createTaskScheduler();

	/**
	 * Returns a new object of class '<em>Interrupt Controller</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Interrupt Controller</em>'.
	 * @generated
	 */
	InterruptController createInterruptController();

	/**
	 * Returns a new object of class '<em>Os Instructions</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os Instructions</em>'.
	 * @generated
	 */
	OsInstructions createOsInstructions();

	/**
	 * Returns a new object of class '<em>Os API Instructions</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os API Instructions</em>'.
	 * @generated
	 */
	OsAPIInstructions createOsAPIInstructions();

	/**
	 * Returns a new object of class '<em>Os ISR Instructions</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os ISR Instructions</em>'.
	 * @generated
	 */
	OsISRInstructions createOsISRInstructions();

	/**
	 * Returns a new object of class '<em>Property Constraints Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Constraints Model</em>'.
	 * @generated
	 */
	PropertyConstraintsModel createPropertyConstraintsModel();

	/**
	 * Returns a new object of class '<em>Process Allocation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Allocation Constraint</em>'.
	 * @generated
	 */
	ProcessAllocationConstraint createProcessAllocationConstraint();

	/**
	 * Returns a new object of class '<em>Process Prototype Allocation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Prototype Allocation Constraint</em>'.
	 * @generated
	 */
	ProcessPrototypeAllocationConstraint createProcessPrototypeAllocationConstraint();

	/**
	 * Returns a new object of class '<em>Runnable Allocation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Allocation Constraint</em>'.
	 * @generated
	 */
	RunnableAllocationConstraint createRunnableAllocationConstraint();

	/**
	 * Returns a new object of class '<em>Abstract Element Mapping Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Element Mapping Constraint</em>'.
	 * @generated
	 */
	AbstractElementMappingConstraint createAbstractElementMappingConstraint();

	/**
	 * Returns a new object of class '<em>Core Classification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Core Classification</em>'.
	 * @generated
	 */
	CoreClassification createCoreClassification();

	/**
	 * Returns a new object of class '<em>Memory Classification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory Classification</em>'.
	 * @generated
	 */
	MemoryClassification createMemoryClassification();

	/**
	 * Returns a new object of class '<em>Stimuli Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Stimuli Model</em>'.
	 * @generated
	 */
	StimuliModel createStimuliModel();

	/**
	 * Returns a new object of class '<em>Mode Value List</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Value List</em>'.
	 * @generated
	 */
	ModeValueList createModeValueList();

	/**
	 * Returns a new object of class '<em>Mode Value List Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Value List Entry</em>'.
	 * @generated
	 */
	ModeValueListEntry createModeValueListEntry();

	/**
	 * Returns a new object of class '<em>Periodic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Periodic</em>'.
	 * @generated
	 */
	Periodic createPeriodic();

	/**
	 * Returns a new object of class '<em>Periodic Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Periodic Event</em>'.
	 * @generated
	 */
	PeriodicEvent createPeriodicEvent();

	/**
	 * Returns a new object of class '<em>Synthetic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Synthetic</em>'.
	 * @generated
	 */
	Synthetic createSynthetic();

	/**
	 * Returns a new object of class '<em>Timestamp List</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Timestamp List</em>'.
	 * @generated
	 */
	TimestampList createTimestampList();

	/**
	 * Returns a new object of class '<em>Custom Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Stimulus</em>'.
	 * @generated
	 */
	CustomStimulus createCustomStimulus();

	/**
	 * Returns a new object of class '<em>Single</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single</em>'.
	 * @generated
	 */
	Single createSingle();

	/**
	 * Returns a new object of class '<em>Inter Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Inter Process</em>'.
	 * @generated
	 */
	InterProcess createInterProcess();

	/**
	 * Returns a new object of class '<em>Sporadic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sporadic</em>'.
	 * @generated
	 */
	Sporadic createSporadic();

	/**
	 * Returns a new object of class '<em>Event Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Stimulus</em>'.
	 * @generated
	 */
	EventStimulus createEventStimulus();

	/**
	 * Returns a new object of class '<em>Arrival Curve</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arrival Curve</em>'.
	 * @generated
	 */
	ArrivalCurve createArrivalCurve();

	/**
	 * Returns a new object of class '<em>Arrival Curve Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arrival Curve Entry</em>'.
	 * @generated
	 */
	ArrivalCurveEntry createArrivalCurveEntry();

	/**
	 * Returns a new object of class '<em>Clock Triangle Function</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Triangle Function</em>'.
	 * @generated
	 */
	ClockTriangleFunction createClockTriangleFunction();

	/**
	 * Returns a new object of class '<em>Clock Sinus Function</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Sinus Function</em>'.
	 * @generated
	 */
	ClockSinusFunction createClockSinusFunction();

	/**
	 * Returns a new object of class '<em>Clock Multiplier List</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Multiplier List</em>'.
	 * @generated
	 */
	ClockMultiplierList createClockMultiplierList();

	/**
	 * Returns a new object of class '<em>Clock Multiplier List Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Multiplier List Entry</em>'.
	 * @generated
	 */
	ClockMultiplierListEntry createClockMultiplierListEntry();

	/**
	 * Returns a new object of class '<em>SW Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>SW Model</em>'.
	 * @generated
	 */
	SWModel createSWModel();

	/**
	 * Returns a new object of class '<em>Custom Entity</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Entity</em>'.
	 * @generated
	 */
	CustomEntity createCustomEntity();

	/**
	 * Returns a new object of class '<em>Process Chain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Chain</em>'.
	 * @generated
	 */
	ProcessChain createProcessChain();

	/**
	 * Returns a new object of class '<em>Call Graph</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Call Graph</em>'.
	 * @generated
	 */
	CallGraph createCallGraph();

	/**
	 * Returns a new object of class '<em>Call Sequence</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Call Sequence</em>'.
	 * @generated
	 */
	CallSequence createCallSequence();

	/**
	 * Returns a new object of class '<em>Mode Switch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Switch</em>'.
	 * @generated
	 */
	ModeSwitch createModeSwitch();

	/**
	 * Returns a new object of class '<em>Mode Switch Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Switch Entry</em>'.
	 * @generated
	 */
	<T> ModeSwitchEntry<T> createModeSwitchEntry();

	/**
	 * Returns a new object of class '<em>Mode Switch Default</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Switch Default</em>'.
	 * @generated
	 */
	<T> ModeSwitchDefault<T> createModeSwitchDefault();

	/**
	 * Returns a new object of class '<em>Probability Switch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Probability Switch</em>'.
	 * @generated
	 */
	ProbabilitySwitch createProbabilitySwitch();

	/**
	 * Returns a new object of class '<em>Probability Switch Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Probability Switch Entry</em>'.
	 * @generated
	 */
	<T> ProbabilitySwitchEntry<T> createProbabilitySwitchEntry();

	/**
	 * Returns a new object of class '<em>Counter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Counter</em>'.
	 * @generated
	 */
	Counter createCounter();

	/**
	 * Returns a new object of class '<em>Wait Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Wait Event</em>'.
	 * @generated
	 */
	WaitEvent createWaitEvent();

	/**
	 * Returns a new object of class '<em>Set Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Set Event</em>'.
	 * @generated
	 */
	SetEvent createSetEvent();

	/**
	 * Returns a new object of class '<em>Clear Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clear Event</em>'.
	 * @generated
	 */
	ClearEvent createClearEvent();

	/**
	 * Returns a new object of class '<em>Event Mask</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Mask</em>'.
	 * @generated
	 */
	EventMask createEventMask();

	/**
	 * Returns a new object of class '<em>Os Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os Event</em>'.
	 * @generated
	 */
	OsEvent createOsEvent();

	/**
	 * Returns a new object of class '<em>Inter Process Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Inter Process Activation</em>'.
	 * @generated
	 */
	InterProcessActivation createInterProcessActivation();

	/**
	 * Returns a new object of class '<em>Enforced Migration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Enforced Migration</em>'.
	 * @generated
	 */
	EnforcedMigration createEnforcedMigration();

	/**
	 * Returns a new object of class '<em>Task Runnable Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Task Runnable Call</em>'.
	 * @generated
	 */
	TaskRunnableCall createTaskRunnableCall();

	/**
	 * Returns a new object of class '<em>Schedule Point</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Schedule Point</em>'.
	 * @generated
	 */
	SchedulePoint createSchedulePoint();

	/**
	 * Returns a new object of class '<em>Terminate Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Terminate Process</em>'.
	 * @generated
	 */
	TerminateProcess createTerminateProcess();

	/**
	 * Returns a new object of class '<em>Task</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Task</em>'.
	 * @generated
	 */
	Task createTask();

	/**
	 * Returns a new object of class '<em>ISR</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISR</em>'.
	 * @generated
	 */
	ISR createISR();

	/**
	 * Returns a new object of class '<em>Process Prototype</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Prototype</em>'.
	 * @generated
	 */
	ProcessPrototype createProcessPrototype();

	/**
	 * Returns a new object of class '<em>Chained Process Prototype</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Chained Process Prototype</em>'.
	 * @generated
	 */
	ChainedProcessPrototype createChainedProcessPrototype();

	/**
	 * Returns a new object of class '<em>Access Precedence Spec</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Access Precedence Spec</em>'.
	 * @generated
	 */
	AccessPrecedenceSpec createAccessPrecedenceSpec();

	/**
	 * Returns a new object of class '<em>Order Precedence Spec</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Order Precedence Spec</em>'.
	 * @generated
	 */
	OrderPrecedenceSpec createOrderPrecedenceSpec();

	/**
	 * Returns a new object of class '<em>Runnable</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable</em>'.
	 * @generated
	 */
	Runnable createRunnable();

	/**
	 * Returns a new object of class '<em>Label</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label</em>'.
	 * @generated
	 */
	Label createLabel();

	/**
	 * Returns a new object of class '<em>Channel</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Channel</em>'.
	 * @generated
	 */
	Channel createChannel();

	/**
	 * Returns a new object of class '<em>Mode Label</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Label</em>'.
	 * @generated
	 */
	ModeLabel createModeLabel();

	/**
	 * Returns a new object of class '<em>Section</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Section</em>'.
	 * @generated
	 */
	Section createSection();

	/**
	 * Returns a new object of class '<em>Runnable Instructions</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Instructions</em>'.
	 * @generated
	 */
	RunnableInstructions createRunnableInstructions();

	/**
	 * Returns a new object of class '<em>Mode Label Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Label Access</em>'.
	 * @generated
	 */
	ModeLabelAccess createModeLabelAccess();

	/**
	 * Returns a new object of class '<em>Runnable Mode Switch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Mode Switch</em>'.
	 * @generated
	 */
	RunnableModeSwitch createRunnableModeSwitch();

	/**
	 * Returns a new object of class '<em>Label Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Access</em>'.
	 * @generated
	 */
	LabelAccess createLabelAccess();

	/**
	 * Returns a new object of class '<em>Channel Send</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Channel Send</em>'.
	 * @generated
	 */
	ChannelSend createChannelSend();

	/**
	 * Returns a new object of class '<em>Channel Receive</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Channel Receive</em>'.
	 * @generated
	 */
	ChannelReceive createChannelReceive();

	/**
	 * Returns a new object of class '<em>Semaphore Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Semaphore Access</em>'.
	 * @generated
	 */
	SemaphoreAccess createSemaphoreAccess();

	/**
	 * Returns a new object of class '<em>Sender Receiver Read</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sender Receiver Read</em>'.
	 * @generated
	 */
	SenderReceiverRead createSenderReceiverRead();

	/**
	 * Returns a new object of class '<em>Sender Receiver Write</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sender Receiver Write</em>'.
	 * @generated
	 */
	SenderReceiverWrite createSenderReceiverWrite();

	/**
	 * Returns a new object of class '<em>Synchronous Server Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Synchronous Server Call</em>'.
	 * @generated
	 */
	SynchronousServerCall createSynchronousServerCall();

	/**
	 * Returns a new object of class '<em>Asynchronous Server Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Asynchronous Server Call</em>'.
	 * @generated
	 */
	AsynchronousServerCall createAsynchronousServerCall();

	/**
	 * Returns a new object of class '<em>Runnable Probability Switch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Probability Switch</em>'.
	 * @generated
	 */
	RunnableProbabilitySwitch createRunnableProbabilitySwitch();

	/**
	 * Returns a new object of class '<em>Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Group</em>'.
	 * @generated
	 */
	Group createGroup();

	/**
	 * Returns a new object of class '<em>Runnable Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Call</em>'.
	 * @generated
	 */
	RunnableCall createRunnableCall();

	/**
	 * Returns a new object of class '<em>Struct</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Struct</em>'.
	 * @generated
	 */
	Struct createStruct();

	/**
	 * Returns a new object of class '<em>Struct Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Struct Entry</em>'.
	 * @generated
	 */
	StructEntry createStructEntry();

	/**
	 * Returns a new object of class '<em>Array</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array</em>'.
	 * @generated
	 */
	Array createArray();

	/**
	 * Returns a new object of class '<em>Pointer</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pointer</em>'.
	 * @generated
	 */
	Pointer createPointer();

	/**
	 * Returns a new object of class '<em>Type Ref</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Type Ref</em>'.
	 * @generated
	 */
	TypeRef createTypeRef();

	/**
	 * Returns a new object of class '<em>Data Platform Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Platform Mapping</em>'.
	 * @generated
	 */
	DataPlatformMapping createDataPlatformMapping();

	/**
	 * Returns a new object of class '<em>Data Type Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Type Definition</em>'.
	 * @generated
	 */
	DataTypeDefinition createDataTypeDefinition();

	/**
	 * Returns a new object of class '<em>Base Type Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Base Type Definition</em>'.
	 * @generated
	 */
	BaseTypeDefinition createBaseTypeDefinition();

	/**
	 * Returns a new object of class '<em>Periodic Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Periodic Activation</em>'.
	 * @generated
	 */
	PeriodicActivation createPeriodicActivation();

	/**
	 * Returns a new object of class '<em>Sporadic Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sporadic Activation</em>'.
	 * @generated
	 */
	SporadicActivation createSporadicActivation();

	/**
	 * Returns a new object of class '<em>Single Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single Activation</em>'.
	 * @generated
	 */
	SingleActivation createSingleActivation();

	/**
	 * Returns a new object of class '<em>Event Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Activation</em>'.
	 * @generated
	 */
	EventActivation createEventActivation();

	/**
	 * Returns a new object of class '<em>Custom Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Activation</em>'.
	 * @generated
	 */
	CustomActivation createCustomActivation();

	/**
	 * Returns a new object of class '<em>Label Access Statistic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Access Statistic</em>'.
	 * @generated
	 */
	LabelAccessStatistic createLabelAccessStatistic();

	/**
	 * Returns a new object of class '<em>Instruction Fetch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Instruction Fetch</em>'.
	 * @generated
	 */
	InstructionFetch createInstructionFetch();

	/**
	 * Returns a new object of class '<em>Run Entity Call Statistic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Run Entity Call Statistic</em>'.
	 * @generated
	 */
	RunEntityCallStatistic createRunEntityCallStatistic();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	AmaltheaPackage getAmaltheaPackage();

} //AmaltheaFactory
