/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.Arrays;
import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.EventModel;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelEvent;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.checks.impl.EventModelCheckValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class EventModelTests {
    private EventModelCheckValidatorImpl classUnderTest;
    private IssueCreator issueCreator;
    private IEObjectHelper eObjectHelper;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.eObjectHelper = (IEObjectHelper)EasyMock.createMock(IEObjectHelper.class);
        this.classUnderTest = new EventModelCheckValidatorImpl(this.issueCreator, this.eObjectHelper);
    }

    @Test
    public void testLabelEvent_CompleteMappingInfoWithTask() {
    }

    public void testLabelEvent_CompleteMappingInfo() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        label.setName("TestLabel");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        labelEvent.setEntity(label);
        labelEvent.setProcess((Process)process);
        labelEvent.setRunnable(runnable);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    public void testLabelEvent_MissingEntity() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        labelEvent.setProcess((Process)process);
        labelEvent.setRunnable(runnable);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Entity(), new Object[]{labelEvent.getName(), "Entity"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    public void testLabelEvent_MissingProcess() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        label.setName("TestLabel");
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnable.setName("TestRunnable");
        labelEvent.setEntity(label);
        labelEvent.setRunnable(runnable);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Process(), new Object[]{labelEvent.getName(), "Process (i.e. Task)"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    public void testLabelEvent_MissingRunnable() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        label.setName("TestLabel");
        Task process = AmaltheaFactory.eINSTANCE.createTask();
        process.setName("TestProcessAsTask");
        labelEvent.setEntity(label);
        labelEvent.setProcess((Process)process);
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Runnable(), new Object[]{labelEvent.getName(), "Runnable"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    public void testLabelEvent_MissingAll() {
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        LabelEvent labelEvent = AmaltheaFactory.eINSTANCE.createLabelEvent();
        labelEvent.setName("TestLabelEvent");
        eventModel.getEvents().add((Object)labelEvent);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesOf((EObject)eventModel, LabelEvent.class)).andReturn(Arrays.asList(labelEvent));
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Entity(), new Object[]{labelEvent.getName(), "Entity"});
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Process(), new Object[]{labelEvent.getName(), "Process (i.e. Task)"});
        this.issueCreator.issue((EObject)labelEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getLabelEvent_Runnable(), new Object[]{labelEvent.getName(), "Runnable"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkLabelEventConstraint(eventModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }
}

