/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.DataAge;
import org.eclipse.app4mc.amalthea.model.DataAgeConstraint;
import org.eclipse.app4mc.amalthea.model.DataAgeTime;
import org.eclipse.app4mc.amalthea.model.DelayConstraint;
import org.eclipse.app4mc.amalthea.model.EarliestDeadlineFirst;
import org.eclipse.app4mc.amalthea.model.EventChainLatencyConstraint;
import org.eclipse.app4mc.amalthea.model.EventSynchronizationConstraint;
import org.eclipse.app4mc.amalthea.model.LimitType;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.ProcessRequirement;
import org.eclipse.app4mc.amalthea.model.RepetitionConstraint;
import org.eclipse.app4mc.amalthea.model.RequirementLimit;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.TaskSchedulingAlgorithm;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeMetric;
import org.eclipse.app4mc.amalthea.model.TimeRequirementLimit;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.ConstraintsModelValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class ConstraintsModelValidatorTests {
    private ConstraintsModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new ConstraintsModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkEDFDeadlineAvailability_missing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        OperatingSystem operatingSystem = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        EarliestDeadlineFirst edf = AmaltheaFactory.eINSTANCE.createEarliestDeadlineFirst();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        String name = "hello";
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        TaskAllocation taskAllocation = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        amalthea.setOsModel(osModel);
        osModel.getOperatingSystems().add((Object)operatingSystem);
        operatingSystem.getTaskSchedulers().add((Object)taskScheduler);
        taskScheduler.setSchedulingAlgorithm((TaskSchedulingAlgorithm)edf);
        amalthea.setSwModel(swModel);
        swModel.getTasks().add((Object)task);
        task.setName(name);
        amalthea.setMappingModel(mappingModel);
        mappingModel.getTaskAllocation().add((Object)taskAllocation);
        taskAllocation.setScheduler(taskScheduler);
        taskAllocation.setTask(task);
        this.issueCreator.issue((EObject)task, null, new Object[]{name});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEDFDeadlineAvailability(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEDFDeadlineAvailability_available() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        OperatingSystem operatingSystem = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        EarliestDeadlineFirst edf = AmaltheaFactory.eINSTANCE.createEarliestDeadlineFirst();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        String name = "hello";
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        TaskAllocation taskAllocation = AmaltheaFactory.eINSTANCE.createTaskAllocation();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        ProcessRequirement processRequirement = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        LimitType limitType = LimitType.UPPER_LIMIT;
        TimeMetric metric = TimeMetric.RESPONSE_TIME;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setOsModel(osModel);
        osModel.getOperatingSystems().add((Object)operatingSystem);
        operatingSystem.getTaskSchedulers().add((Object)taskScheduler);
        taskScheduler.setSchedulingAlgorithm((TaskSchedulingAlgorithm)edf);
        amalthea.setSwModel(swModel);
        swModel.getTasks().add((Object)task);
        task.setName(name);
        amalthea.setMappingModel(mappingModel);
        mappingModel.getTaskAllocation().add((Object)taskAllocation);
        taskAllocation.setScheduler(taskScheduler);
        taskAllocation.setTask(task);
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getRequirements().add((Object)processRequirement);
        processRequirement.setProcess((AbstractProcess)task);
        processRequirement.setLimit((RequirementLimit)limit);
        limit.setLimitType(limitType);
        limit.setMetric(metric);
        limit.setLimitValue(time);
        time.setValue(10);
        time.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEDFDeadlineAvailability(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeadlineValue_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        ProcessRequirement processRequirement = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        LimitType limitType = LimitType.UPPER_LIMIT;
        TimeMetric metric = TimeMetric.RESPONSE_TIME;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getRequirements().add((Object)processRequirement);
        processRequirement.setLimit((RequirementLimit)limit);
        limit.setLimitType(limitType);
        limit.setMetric(metric);
        limit.setLimitValue(time);
        time.setValue(-10);
        time.setUnit(unit);
        this.issueCreator.issue((EObject)limit, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimeRequirementLimit_LimitValue(), new Object[]{-10, unit});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeadlineValue(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeadlineValue_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        ProcessRequirement processRequirement = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        LimitType limitType = LimitType.UPPER_LIMIT;
        TimeMetric metric = TimeMetric.RESPONSE_TIME;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getRequirements().add((Object)processRequirement);
        processRequirement.setLimit((RequirementLimit)limit);
        limit.setLimitType(limitType);
        limit.setMetric(metric);
        limit.setLimitValue(time);
        time.setValue(0);
        time.setUnit(unit);
        this.issueCreator.issue((EObject)limit, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimeRequirementLimit_LimitValue(), new Object[]{0, unit});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeadlineValue(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDeadlineValue_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        ProcessRequirement processRequirement = AmaltheaFactory.eINSTANCE.createProcessRequirement();
        TimeRequirementLimit limit = AmaltheaFactory.eINSTANCE.createTimeRequirementLimit();
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        LimitType limitType = LimitType.UPPER_LIMIT;
        TimeMetric metric = TimeMetric.RESPONSE_TIME;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getRequirements().add((Object)processRequirement);
        processRequirement.setLimit((RequirementLimit)limit);
        limit.setLimitType(limitType);
        limit.setMetric(metric);
        limit.setLimitValue(time);
        time.setValue(10);
        time.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDeadlineValue(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSynchronizationConstraintToleranceUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventSynchronizationConstraint synchronizationConstraint = AmaltheaFactory.eINSTANCE.createEventSynchronizationConstraint();
        Time tolerance = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)synchronizationConstraint);
        synchronizationConstraint.setTolerance(tolerance);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSynchronizationConstraintToleranceUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSynchronizationConstraintToleranceUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventSynchronizationConstraint synchronizationConstraint = AmaltheaFactory.eINSTANCE.createEventSynchronizationConstraint();
        Time tolerance = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)synchronizationConstraint);
        synchronizationConstraint.setTolerance(tolerance);
        tolerance.setValue(value.intValue());
        tolerance.setUnit(unit);
        this.issueCreator.issue((EObject)tolerance, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSynchronizationConstraint_Tolerance(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSynchronizationConstraintToleranceUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSynchronizationConstraintToleranceUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventSynchronizationConstraint synchronizationConstraint = AmaltheaFactory.eINSTANCE.createEventSynchronizationConstraint();
        Time tolerance = AmaltheaFactory.eINSTANCE.createTime();
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)synchronizationConstraint);
        synchronizationConstraint.setTolerance(tolerance);
        tolerance.setValue(0);
        tolerance.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSynchronizationConstraintToleranceUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSynchronizationConstraintToleranceUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventSynchronizationConstraint synchronizationConstraint = AmaltheaFactory.eINSTANCE.createEventSynchronizationConstraint();
        Time tolerance = AmaltheaFactory.eINSTANCE.createTime();
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)synchronizationConstraint);
        synchronizationConstraint.setTolerance(tolerance);
        tolerance.setValue(10);
        tolerance.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSynchronizationConstraintToleranceUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDelayConstraintUpperUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DelayConstraint delayConstraint = AmaltheaFactory.eINSTANCE.createDelayConstraint();
        Time upper = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)delayConstraint);
        delayConstraint.setUpper(upper);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDelayConstraintUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDelayConstraintUpperUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DelayConstraint delayConstraint = AmaltheaFactory.eINSTANCE.createDelayConstraint();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)delayConstraint);
        delayConstraint.setUpper(upper);
        upper.setValue(value.intValue());
        upper.setUnit(unit);
        this.issueCreator.issue((EObject)upper, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDelayConstraint_Upper(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDelayConstraintUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDelayConstraintUpperUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DelayConstraint delayConstraint = AmaltheaFactory.eINSTANCE.createDelayConstraint();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)delayConstraint);
        delayConstraint.setUpper(upper);
        upper.setValue(value.intValue());
        upper.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDelayConstraintUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDelayConstraintUpperUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DelayConstraint delayConstraint = AmaltheaFactory.eINSTANCE.createDelayConstraint();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)delayConstraint);
        delayConstraint.setUpper(upper);
        upper.setValue(value.intValue());
        upper.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDelayConstraintUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDelayConstraintLowerUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DelayConstraint delayConstraint = AmaltheaFactory.eINSTANCE.createDelayConstraint();
        Time lower = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)delayConstraint);
        delayConstraint.setLower(lower);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDelayConstraintLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDelayConstraintLowerUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DelayConstraint delayConstraint = AmaltheaFactory.eINSTANCE.createDelayConstraint();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)delayConstraint);
        delayConstraint.setLower(lower);
        lower.setValue(value.intValue());
        lower.setUnit(unit);
        this.issueCreator.issue((EObject)lower, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDelayConstraint_Lower(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDelayConstraintLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDelayConstraintLowerUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DelayConstraint delayConstraint = AmaltheaFactory.eINSTANCE.createDelayConstraint();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)delayConstraint);
        delayConstraint.setUpper(lower);
        lower.setValue(value.intValue());
        lower.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDelayConstraintLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDelayConstraintLowerUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DelayConstraint delayConstraint = AmaltheaFactory.eINSTANCE.createDelayConstraint();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)delayConstraint);
        delayConstraint.setUpper(lower);
        lower.setValue(value.intValue());
        lower.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDelayConstraintLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventChainLatencyConstraintMinimumUnsinged_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventChainLatencyConstraint eventChainLatencyConstraint = AmaltheaFactory.eINSTANCE.createEventChainLatencyConstraint();
        Time minimum = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)eventChainLatencyConstraint);
        eventChainLatencyConstraint.setMinimum(minimum);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChainLatencyConstraintMinimumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventChainLatencyConstraintMinimumUnsinged_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventChainLatencyConstraint eventChainLatencyConstraint = AmaltheaFactory.eINSTANCE.createEventChainLatencyConstraint();
        Time minimum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)eventChainLatencyConstraint);
        eventChainLatencyConstraint.setMinimum(minimum);
        minimum.setValue(value.intValue());
        minimum.setUnit(unit);
        this.issueCreator.issue((EObject)minimum, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainLatencyConstraint_Minimum(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChainLatencyConstraintMinimumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventChainLatencyConstraintMinimumUnsinged_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventChainLatencyConstraint eventChainLatencyConstraint = AmaltheaFactory.eINSTANCE.createEventChainLatencyConstraint();
        Time minimum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)eventChainLatencyConstraint);
        eventChainLatencyConstraint.setMinimum(minimum);
        minimum.setValue(value.intValue());
        minimum.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChainLatencyConstraintMinimumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventChainLatencyConstraintMinimumUnsinged_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventChainLatencyConstraint eventChainLatencyConstraint = AmaltheaFactory.eINSTANCE.createEventChainLatencyConstraint();
        Time minimum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)eventChainLatencyConstraint);
        eventChainLatencyConstraint.setMinimum(minimum);
        minimum.setValue(value.intValue());
        minimum.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChainLatencyConstraintMinimumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventChainLatencyConstraintMaximumUnsinged_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventChainLatencyConstraint eventChainLatencyConstraint = AmaltheaFactory.eINSTANCE.createEventChainLatencyConstraint();
        Time maximum = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)eventChainLatencyConstraint);
        eventChainLatencyConstraint.setMaximum(maximum);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChainLatencyConstraintMaximumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventChainLatencyConstraintMaximumUnsinged_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventChainLatencyConstraint eventChainLatencyConstraint = AmaltheaFactory.eINSTANCE.createEventChainLatencyConstraint();
        Time maximum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)eventChainLatencyConstraint);
        eventChainLatencyConstraint.setMaximum(maximum);
        maximum.setValue(value.intValue());
        maximum.setUnit(unit);
        this.issueCreator.issue((EObject)maximum, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainLatencyConstraint_Maximum(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChainLatencyConstraintMaximumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventChainLatencyConstraintMaximumUnsinged_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventChainLatencyConstraint eventChainLatencyConstraint = AmaltheaFactory.eINSTANCE.createEventChainLatencyConstraint();
        Time maximum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)eventChainLatencyConstraint);
        eventChainLatencyConstraint.setMinimum(maximum);
        maximum.setValue(value.intValue());
        maximum.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChainLatencyConstraintMaximumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventChainLatencyConstraintMaximumUnsinged_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        EventChainLatencyConstraint eventChainLatencyConstraint = AmaltheaFactory.eINSTANCE.createEventChainLatencyConstraint();
        Time maximum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)eventChainLatencyConstraint);
        eventChainLatencyConstraint.setMaximum(maximum);
        maximum.setValue(value.intValue());
        maximum.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChainLatencyConstraintMaximumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintLowerUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time lower = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setLower(lower);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintLowerUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setLower(lower);
        lower.setValue(value.intValue());
        lower.setUnit(unit);
        this.issueCreator.issue((EObject)lower, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRepetitionConstraint_Lower(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintLowerUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setLower(lower);
        lower.setValue(value.intValue());
        lower.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintLowerUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setLower(lower);
        lower.setValue(value.intValue());
        lower.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintUpperUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time upper = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setUpper(upper);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintUpperUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setUpper(upper);
        upper.setValue(value.intValue());
        upper.setUnit(unit);
        this.issueCreator.issue((EObject)upper, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRepetitionConstraint_Upper(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintUpperUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setUpper(upper);
        upper.setValue(value.intValue());
        upper.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintUpperUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setUpper(upper);
        upper.setValue(value.intValue());
        upper.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintJitterUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time jitter = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setJitter(jitter);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintJitterUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintJitterUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time jitter = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setJitter(jitter);
        jitter.setValue(value.intValue());
        jitter.setUnit(unit);
        this.issueCreator.issue((EObject)jitter, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRepetitionConstraint_Jitter(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintJitterUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintJitterUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time jitter = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setJitter(jitter);
        jitter.setValue(value.intValue());
        jitter.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintJitterUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintJitterUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time jitter = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setJitter(jitter);
        jitter.setValue(value.intValue());
        jitter.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintJitterUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintPeriodUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time period = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setPeriod(period);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintPeriodUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setPeriod(period);
        period.setValue(value.intValue());
        period.setUnit(unit);
        this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRepetitionConstraint_Period(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintPeriodUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setPeriod(period);
        period.setValue(value.intValue());
        period.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRepetitionConstraintPeriodUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        RepetitionConstraint repetitionConstraint = AmaltheaFactory.eINSTANCE.createRepetitionConstraint();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getTimingConstraints().add((Object)repetitionConstraint);
        repetitionConstraint.setPeriod(period);
        period.setValue(value.intValue());
        period.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRepetitionConstraintPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDataAgeTimeMinimumUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DataAgeConstraint dataAgeConstraint = AmaltheaFactory.eINSTANCE.createDataAgeConstraint();
        DataAgeTime dataAgeTime = AmaltheaFactory.eINSTANCE.createDataAgeTime();
        Time minimum = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getDataAgeConstraints().add((Object)dataAgeConstraint);
        dataAgeConstraint.setDataAge((DataAge)dataAgeTime);
        dataAgeTime.setMinimumTime(minimum);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDataAgeTimeMinimumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDataAgeTimeMinimumUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DataAgeConstraint dataAgeConstraint = AmaltheaFactory.eINSTANCE.createDataAgeConstraint();
        DataAgeTime dataAgeTime = AmaltheaFactory.eINSTANCE.createDataAgeTime();
        Time minimum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getDataAgeConstraints().add((Object)dataAgeConstraint);
        dataAgeConstraint.setDataAge((DataAge)dataAgeTime);
        dataAgeTime.setMinimumTime(minimum);
        minimum.setValue(value.intValue());
        minimum.setUnit(unit);
        this.issueCreator.issue((EObject)minimum, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDataAgeTime_MinimumTime(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDataAgeTimeMinimumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDataAgeTimeMinimumUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DataAgeConstraint dataAgeConstraint = AmaltheaFactory.eINSTANCE.createDataAgeConstraint();
        DataAgeTime dataAgeTime = AmaltheaFactory.eINSTANCE.createDataAgeTime();
        Time minimum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getDataAgeConstraints().add((Object)dataAgeConstraint);
        dataAgeConstraint.setDataAge((DataAge)dataAgeTime);
        dataAgeTime.setMinimumTime(minimum);
        minimum.setValue(value.intValue());
        minimum.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDataAgeTimeMinimumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDataAgeTimeMinimumUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DataAgeConstraint dataAgeConstraint = AmaltheaFactory.eINSTANCE.createDataAgeConstraint();
        DataAgeTime dataAgeTime = AmaltheaFactory.eINSTANCE.createDataAgeTime();
        Time minimum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getDataAgeConstraints().add((Object)dataAgeConstraint);
        dataAgeConstraint.setDataAge((DataAge)dataAgeTime);
        dataAgeTime.setMinimumTime(minimum);
        minimum.setValue(value.intValue());
        minimum.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDataAgeTimeMinimumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDataAgeTimeMaximumUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DataAgeConstraint dataAgeConstraint = AmaltheaFactory.eINSTANCE.createDataAgeConstraint();
        DataAgeTime dataAgeTime = AmaltheaFactory.eINSTANCE.createDataAgeTime();
        Time maximum = null;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getDataAgeConstraints().add((Object)dataAgeConstraint);
        dataAgeConstraint.setDataAge((DataAge)dataAgeTime);
        dataAgeTime.setMaximumTime(maximum);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDataAgeTimeMaximumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDataAgeTimeMaximumUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DataAgeConstraint dataAgeConstraint = AmaltheaFactory.eINSTANCE.createDataAgeConstraint();
        DataAgeTime dataAgeTime = AmaltheaFactory.eINSTANCE.createDataAgeTime();
        Time maximum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = -10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getDataAgeConstraints().add((Object)dataAgeConstraint);
        dataAgeConstraint.setDataAge((DataAge)dataAgeTime);
        dataAgeTime.setMaximumTime(maximum);
        maximum.setValue(value.intValue());
        maximum.setUnit(unit);
        this.issueCreator.issue((EObject)maximum, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDataAgeTime_MaximumTime(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDataAgeTimeMaximumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDataAgeTimeMaximumUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DataAgeConstraint dataAgeConstraint = AmaltheaFactory.eINSTANCE.createDataAgeConstraint();
        DataAgeTime dataAgeTime = AmaltheaFactory.eINSTANCE.createDataAgeTime();
        Time maximum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 0;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getDataAgeConstraints().add((Object)dataAgeConstraint);
        dataAgeConstraint.setDataAge((DataAge)dataAgeTime);
        dataAgeTime.setMaximumTime(maximum);
        maximum.setValue(value.intValue());
        maximum.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDataAgeTimeMaximumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkDataAgeTimeMaximumUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        DataAgeConstraint dataAgeConstraint = AmaltheaFactory.eINSTANCE.createDataAgeConstraint();
        DataAgeTime dataAgeTime = AmaltheaFactory.eINSTANCE.createDataAgeTime();
        Time maximum = AmaltheaFactory.eINSTANCE.createTime();
        Integer value = 10;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setConstraintsModel(constraintsModel);
        constraintsModel.getDataAgeConstraints().add((Object)dataAgeConstraint);
        dataAgeConstraint.setDataAge((DataAge)dataAgeTime);
        dataAgeTime.setMaximumTime(maximum);
        maximum.setValue(value.intValue());
        maximum.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkDataAgeTimeMaximumUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

