/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.ArrayList;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainItem;
import org.eclipse.app4mc.amalthea.model.EventChainReference;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ConstraintsModelCheckValidatorImpl
extends AbstractValidatorImpl {
    public ConstraintsModelCheckValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public ConstraintsModelCheckValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkEventChains(ConstraintsModel constraintsModel) {
        if (constraintsModel != null) {
            for (EventChain eventChain : constraintsModel.getEventChains()) {
                this.checkChainConsistency(eventChain);
            }
        }
    }

    private void checkChainConsistency(EventChain eventChain) {
        if (eventChain == null) {
            return;
        }
        this.checkChainConsistency(eventChain, (EList<EventChainItem>)eventChain.getSegments());
        this.checkChainConsistency(eventChain, (EList<EventChainItem>)eventChain.getStrands());
    }

    private void checkChainConsistency(EventChain pEventChain, EList<EventChainItem> pSubEventChains) {
        ArrayList<EventChain> subEventChains = new ArrayList<EventChain>();
        for (EventChainItem subEventChainItem : pSubEventChains) {
            EventChain subEventChain = null;
            if (subEventChainItem instanceof SubEventChain) {
                subEventChain = ((SubEventChain)subEventChainItem).getEventChain();
            }
            if (subEventChainItem instanceof EventChainReference) {
                subEventChain = ((EventChainReference)subEventChainItem).getEventChain();
            }
            if (subEventChain == null) continue;
            subEventChains.add(subEventChain);
            this.checkChainConsistency(subEventChain);
        }
        if (subEventChains.isEmpty()) {
            return;
        }
        int chainnedEventsCnt = -1;
        for (EventChain subEventChain : subEventChains) {
            if (subEventChain.getStimulus() != pEventChain.getStimulus()) continue;
            chainnedEventsCnt = 0;
            EventChain chainingEvent = subEventChain;
            StringBuilder completeChainBuilder = new StringBuilder();
            completeChainBuilder.append("EventChain: [ --> {" + this.getStimulusEvent(pEventChain) + "}" + pEventChain.getName() + "{" + this.getResponseEvent(pEventChain) + "} --> ]\n");
            completeChainBuilder.append("  SubEventChain: (");
            while (chainingEvent.getResponse() != pEventChain.getResponse()) {
                boolean hasChained = false;
                for (EventChain subEvent : subEventChains) {
                    if (chainingEvent.getResponse() != subEvent.getStimulus()) continue;
                    completeChainBuilder.append(" --> {" + this.getStimulusEvent(chainingEvent) + "}" + chainingEvent.getName() + "{" + this.getResponseEvent(chainingEvent) + "}");
                    chainingEvent = subEvent;
                    ++chainnedEventsCnt;
                    hasChained = true;
                }
                if (hasChained || chainingEvent.getResponse() == pEventChain.getResponse()) continue;
                this.issueCreator.issue((EObject)chainingEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"No successor found for EventChain '" + chainingEvent.getName() + "'"});
                break;
            }
            completeChainBuilder.append(" --> {" + this.getStimulusEvent(chainingEvent) + "}" + chainingEvent.getName() + "{" + this.getResponseEvent(chainingEvent) + "}" + " --> )");
            if (chainingEvent.getResponse() != pEventChain.getResponse()) continue;
            if (chainnedEventsCnt < subEventChains.size() - 1) {
                this.issueCreator.issue((EObject)pEventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"SubChain complete BUT unconnected SubEventChains left for EventChain " + pEventChain.getName()});
            }
            if (chainnedEventsCnt <= subEventChains.size()) continue;
            this.issueCreator.issue((EObject)pEventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"Cycle found for EventChain " + pEventChain.getName()});
        }
        if (chainnedEventsCnt == -1) {
            this.issueCreator.issue((EObject)pEventChain, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"Beginning SubEventChain not found; EventChain's stimulus does not match with any SubEventChain's stimulus " + pEventChain.getName()});
        }
    }

    private String getResponseEvent(EventChain chainingEvent) {
        if (chainingEvent == null || chainingEvent.getResponse() == null) {
            return "MISSING";
        }
        return chainingEvent.getResponse().getName();
    }

    private String getStimulusEvent(EventChain chainingEvent) {
        if (chainingEvent == null || chainingEvent.getStimulus() == null) {
            return "MISSING";
        }
        return chainingEvent.getStimulus().getName();
    }
}

