/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.ECU;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.HwSystem;
import org.eclipse.app4mc.amalthea.model.Microcontroller;
import org.eclipse.app4mc.amalthea.model.Prescaler;
import org.eclipse.app4mc.amalthea.model.Quartz;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class HWModelValidatorImpl
extends AbstractValidatorImpl {
    public HWModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public HWModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkQuartzFrequency(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Quartz)) continue;
            Quartz quartz = (Quartz)elem;
            Frequency frequency = quartz.getFrequency();
            if (frequency == null) {
                this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
                continue;
            }
            if (!(0.0 < frequency.getValue())) {
                this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
            }
            if (FrequencyUnit._UNDEFINED_ != frequency.getUnit()) continue;
            this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
        }
    }

    public void checkCoreTypeInstructionsPerCycle(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            CoreType coreType;
            float instructionsPerCycle;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof CoreType) || !(0.0f >= (instructionsPerCycle = (coreType = (CoreType)elem).getInstructionsPerCycle()))) continue;
            this.issueCreator.issue((EObject)coreType, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCoreType_InstructionsPerCycle(), new Object[]{Float.valueOf(instructionsPerCycle)});
        }
    }

    public void checkQuartzReferenceOfPrescaler(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<Prescaler> prescalers = new HashSet<Prescaler>();
        HashSet<Quartz> quartzes = new HashSet<Quartz>();
        while (amaIter.hasNext()) {
            Core core;
            EList quartzList;
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof Prescaler) {
                Prescaler prescaler = (Prescaler)elem;
                prescalers.add(prescaler);
                continue;
            }
            if (elem instanceof HwSystem) {
                HwSystem hwSystem = (HwSystem)elem;
                quartzList = hwSystem.getQuartzes();
                if (quartzList == null) continue;
                for (Quartz quartz : quartzList) {
                    if (quartz == null) continue;
                    quartzes.add(quartz);
                }
                continue;
            }
            if (elem instanceof ECU) {
                ECU ecu = (ECU)elem;
                quartzList = ecu.getQuartzes();
                if (quartzList == null) continue;
                for (Quartz quartz : quartzList) {
                    if (quartz == null) continue;
                    quartzes.add(quartz);
                }
                continue;
            }
            if (elem instanceof Microcontroller) {
                Microcontroller microcontroller = (Microcontroller)elem;
                quartzList = microcontroller.getQuartzes();
                if (quartzList == null) continue;
                for (Quartz quartz : quartzList) {
                    if (quartz == null) continue;
                    quartzes.add(quartz);
                }
                continue;
            }
            if (!(elem instanceof Core) || (quartzList = (core = (Core)elem).getQuartzes()) == null) continue;
            for (Quartz quartz : quartzList) {
                if (quartz == null) continue;
                quartzes.add(quartz);
            }
        }
        for (Prescaler prescaler : prescalers) {
            Quartz quartz;
            if (prescaler == null || (quartz = prescaler.getQuartz()) != null && quartzes.contains(quartz)) continue;
            this.issueCreator.issue((EObject)prescaler, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPrescaler_Quartz(), new Object[0]);
        }
    }
}

