/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry;
import org.eclipse.app4mc.amalthea.model.Clock;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierList;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry;
import org.eclipse.app4mc.amalthea.model.ClockSinusFunction;
import org.eclipse.app4mc.amalthea.model.ClockTriangleFunction;
import org.eclipse.app4mc.amalthea.model.Periodic;
import org.eclipse.app4mc.amalthea.model.Single;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.Synthetic;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TimestampList;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StimuliModelValidatorImpl
extends AbstractValidatorImpl {
    public StimuliModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public StimuliModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkPeriodicRecurrence(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            Periodic periodic;
            Time recurrence;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Periodic) || (recurrence = (periodic = (Periodic)elem).getRecurrence()) == null) continue;
            int value = recurrence.getValue();
            TimeUnit unit = recurrence.getUnit();
            if (value > 0 && TimeUnit._UNDEFINED_ != unit) continue;
            this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodic_Recurrence(), new Object[]{value, unit});
        }
    }

    public void checkClockReferenceOfPeriodic(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<Periodic> periodics = new HashSet<Periodic>();
        HashSet<Clock> clocks = new HashSet<Clock>();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof Periodic) {
                Periodic periodic = (Periodic)elem;
                periodics.add(periodic);
                continue;
            }
            if (!(elem instanceof StimuliModel)) continue;
            StimuliModel stimuliModel = (StimuliModel)elem;
            EList clockList = stimuliModel.getClocks();
            for (Clock clock : clockList) {
                if (clock == null) continue;
                clocks.add(clock);
            }
        }
        for (Periodic periodic : periodics) {
            Clock clock;
            if (periodic == null || (clock = periodic.getClock()) != null && clocks.contains(clock)) continue;
            this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodic_Clock(), new Object[0]);
        }
    }

    public void checkClockTriangleFunction(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockTriangleFunction)) continue;
            ClockTriangleFunction clockTriangleFunction = (ClockTriangleFunction)elem;
            double min = clockTriangleFunction.getMin();
            double max = clockTriangleFunction.getMax();
            if (min < 0.0) {
                this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
                continue;
            }
            if (max <= 0.0) {
                this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
                continue;
            }
            if (!(min > max)) continue;
            this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
        }
    }

    public void checkClockSinusFunction(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockSinusFunction)) continue;
            ClockSinusFunction clockSinusFunction = (ClockSinusFunction)elem;
            double amplitude = clockSinusFunction.getAmplitude();
            double yOffset = clockSinusFunction.getYOffset();
            if (amplitude < 0.0) {
                this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
                continue;
            }
            if (yOffset <= 0.0) {
                this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
                continue;
            }
            if (!(amplitude > yOffset)) continue;
            this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
        }
    }

    public void checkClockMultiplierList(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockMultiplierList)) continue;
            ClockMultiplierList clock = (ClockMultiplierList)elem;
            for (ClockMultiplierListEntry entry : clock.getEntries()) {
                double value = entry.getMultiplier();
                if (!(value < 0.0)) continue;
                this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Multiplier(), new Object[0]);
            }
        }
    }

    public void checkPeriodicOffsetUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            Periodic periodic;
            Time offset;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Periodic) || (offset = (periodic = (Periodic)elem).getOffset()) == null || (value = offset.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodic_Offset(), new Object[]{value});
        }
    }

    public void checkPeriodicRecurrenceUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            Periodic periodic;
            Time recurrence;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Periodic) || (recurrence = (periodic = (Periodic)elem).getRecurrence()) == null || (value = recurrence.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)recurrence, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodic_Recurrence(), new Object[]{value});
        }
    }

    public void checkSyntheticOffsetUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            Synthetic synthetic;
            Time offset;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Synthetic) || (offset = (synthetic = (Synthetic)elem).getOffset()) == null || (value = offset.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSynthetic_Offset(), new Object[]{value});
        }
    }

    public void checkSyntheticPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            Synthetic synthetic;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Synthetic) || (period = (synthetic = (Synthetic)elem).getPeriod()) == null || (value = period.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSynthetic_Period(), new Object[]{value});
        }
    }

    public void checkTimestampListTimestampsUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof TimestampList)) continue;
            TimestampList timestampList = (TimestampList)elem;
            for (Time timestamp : timestampList.getTimestamps()) {
                int value;
                if (timestamp == null || (value = timestamp.getValue()) >= 0) continue;
                this.issueCreator.issue((EObject)timestamp, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimestampList_Timestamps(), new Object[]{value});
            }
        }
    }

    public void checkSingleActivationUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            Single single;
            Time activation;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof Single) || (activation = (single = (Single)elem).getActivation()) == null || (value = activation.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)activation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSingle_Activation(), new Object[]{value});
        }
    }

    public void checkArrivalCurveEntryLowerUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            ArrivalCurveEntry arrivalCurveEntry;
            Time lowerTimeBorder;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ArrivalCurveEntry) || (lowerTimeBorder = (arrivalCurveEntry = (ArrivalCurveEntry)elem).getLowerTimeBorder()) == null || (value = lowerTimeBorder.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)lowerTimeBorder, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getArrivalCurveEntry_LowerTimeBorder(), new Object[]{value});
        }
    }

    public void checkArrivalCurveEntryUpperUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            ArrivalCurveEntry arrivalCurveEntry;
            Time upperTimeBorder;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ArrivalCurveEntry) || (upperTimeBorder = (arrivalCurveEntry = (ArrivalCurveEntry)elem).getUpperTimeBorder()) == null || (value = upperTimeBorder.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)upperTimeBorder, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getArrivalCurveEntry_UpperTimeBorder(), new Object[]{value});
        }
    }

    public void checkClockTriangleFunctionPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            ClockTriangleFunction clockTriangleFunction;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockTriangleFunction) || (period = (clockTriangleFunction = (ClockTriangleFunction)elem).getPeriod()) == null || (value = period.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Period(), new Object[]{value});
        }
    }

    public void checkClockSinusFunctionPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            ClockSinusFunction clockSinusFunction;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockSinusFunction) || (period = (clockSinusFunction = (ClockSinusFunction)elem).getPeriod()) == null || (value = period.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Period(), new Object[]{value});
        }
    }

    public void checkClockMultiplierListEntryTimeUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            int value;
            ClockMultiplierListEntry clockMultiplierListEntry;
            Time time;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockMultiplierListEntry) || (time = (clockMultiplierListEntry = (ClockMultiplierListEntry)elem).getTime()) == null || (value = time.getValue()) >= 0) continue;
            this.issueCreator.issue((EObject)time, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Time(), new Object[]{value});
        }
    }
}

