/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.openmapping;

import java.util.HashMap;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CoreAllocation;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMCore;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMScheduler;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMTask;

public class AmaltheaModelBuilder {
    private final OMMapping mapping;
    private Amalthea centralModel;

    public AmaltheaModelBuilder(OMMapping mapping) {
        this.mapping = mapping;
    }

    public Amalthea getAmaltheaModel() {
        if (this.centralModel == null) {
            this.buildAmaltheaModel();
        }
        return this.centralModel;
    }

    private void buildAmaltheaModel() {
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        os.setName("OS");
        osModel.getOperatingSystems().add((Object)os);
        HashMap<OMCore, OMScheduler> coreSchedulerMap = new HashMap<OMCore, OMScheduler>();
        for (OMAllocation allocation : this.mapping.getAllocationList()) {
            OMScheduler scheduler;
            OMCore core = allocation.getCore();
            OMTask task = allocation.getTask();
            if (coreSchedulerMap.containsKey(core)) {
                scheduler = (OMScheduler)coreSchedulerMap.get(core);
            } else {
                scheduler = new OMScheduler(core);
                os.getTaskSchedulers().add((Object)scheduler.getSchedulerRef());
                CoreAllocation coreAlloc = AmaltheaFactory.eINSTANCE.createCoreAllocation();
                coreAlloc.getCore().add((Object)core.getCoreRef());
                coreAlloc.setScheduler((Scheduler)scheduler.getSchedulerRef());
                mappingModel.getCoreAllocation().add((Object)coreAlloc);
                coreSchedulerMap.put(core, scheduler);
            }
            TaskAllocation taskAlloc = AmaltheaFactory.eINSTANCE.createTaskAllocation();
            taskAlloc.setTask(task.getTaskRef());
            taskAlloc.setScheduler(scheduler.getSchedulerRef());
            mappingModel.getTaskAllocation().add((Object)taskAlloc);
        }
        this.centralModel = AmaltheaFactory.eINSTANCE.createAmalthea();
        this.centralModel.setOsModel(osModel);
        this.centralModel.setMappingModel(mappingModel);
    }
}

