/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.openmapping;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Periodic;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMEdge;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMRunnable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OMTask {
    private final Task taskRef;
    private OMTask predecessor = null;
    private long iInstructionCount = -1L;
    private final List<OMEdge> post = new LinkedList<OMEdge>();
    private List<OMRunnable> runnableSequence;
    private long period = -1L;

    public OMTask(Task taskRef) {
        this.taskRef = taskRef;
    }

    public OMTask(Task taskRef, OMTask predecessor) {
        this.taskRef = taskRef;
        this.predecessor = predecessor;
    }

    public Task getTaskRef() {
        return this.taskRef;
    }

    public OMTask getPredecessor() {
        return this.predecessor;
    }

    public long getInstructionCount() {
        if (0L > this.iInstructionCount) {
            this.getPropertyInstructionCount();
        }
        if (0L > this.iInstructionCount) {
            this.iInstructionCount = 0L;
            for (OMRunnable r : this.getRunnableCallSequence()) {
                this.iInstructionCount += r.getInstructionCount();
            }
        }
        return this.iInstructionCount;
    }

    private boolean getPropertyInstructionCount() {
        Object o;
        long val;
        EList a;
        Value x = (Value)this.getTaskRef().getCustomProperties().get((Object)"instructionCount");
        if (x != null && (a = x.eClass().getEAttributes()).size() > 0 && (val = Long.parseLong((o = x.eGet((EStructuralFeature)a.get(0))).toString())) > 0L) {
            this.iInstructionCount = val;
            return true;
        }
        return false;
    }

    public long getRunnableCount() {
        return this.getRunnableCallSequence().size();
    }

    public String toString() {
        return this.taskRef.getUniqueName();
    }

    public long getPeriod() {
        if (this.period < 0L) {
            for (Stimulus s : this.getTaskRef().getStimuli()) {
                if (!(s instanceof Periodic)) continue;
                Periodic ps = (Periodic)s;
                Time x = ps.getRecurrence();
                if (x == null) {
                    this.period = 0L;
                    return this.period;
                }
                long val = x.getValue();
                if (val == 0L || x.getUnit() == null) {
                    this.period = 0L;
                    return this.period;
                }
                switch (x.getUnit()) {
                    case PS: {
                        val *= 1L;
                        break;
                    }
                    case NS: {
                        val *= 1000L;
                        break;
                    }
                    case US: {
                        val *= 1000000L;
                        break;
                    }
                    case MS: {
                        val *= 1000000000L;
                        break;
                    }
                    case S: {
                        val *= 1000000000000L;
                        break;
                    }
                    default: {
                        this.period = 0L;
                        return this.period;
                    }
                }
                this.period = val;
                return this.period;
            }
            this.period = 0L;
        }
        return this.period;
    }

    /*
     * Exception decompiling
     */
    public double calcRecursionFactor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl80 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl80 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<OMRunnable> getRunnableCallSequence() {
        if (this.runnableSequence == null) {
            try {
                this.runnableSequence = this.createCallSequenceList().stream().map(OMRunnable::new).collect(Collectors.toList());
            }
            catch (MalformedModelException e) {
                e.printStackTrace();
                this.runnableSequence = new LinkedList<OMRunnable>();
            }
        }
        return this.runnableSequence;
    }

    private List<Runnable> createCallSequenceList() throws MalformedModelException {
        LinkedList<Runnable> list = new LinkedList<Runnable>();
        Task t = this.getTaskRef();
        if (t == null) {
            throw new MalformedModelException("No Task defined!");
        }
        CallGraph graph = t.getCallGraph();
        if (graph == null) {
            throw new MalformedModelException("No callgraph at task " + t.getName());
        }
        for (GraphEntryBase entry : graph.getGraphEntries()) {
            if (!(entry instanceof CallSequence)) continue;
            CallSequence seq = (CallSequence)entry;
            for (CallSequenceItem item : seq.getCalls()) {
                if (!(item instanceof TaskRunnableCall)) continue;
                TaskRunnableCall call = (TaskRunnableCall)item;
                Runnable r = call.getRunnable();
                if (r == null) {
                    throw new MalformedModelException("Empty Runnable call at task " + t.getName());
                }
                list.add(r);
            }
            if (list.size() == 0) {
                throw new MalformedModelException("Empty CallSequence at task " + t.getName());
            }
            return list;
        }
        throw new MalformedModelException("No CallSequence defined!");
    }

    public List<OMEdge> getPosts() {
        return this.post;
    }
}

