/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.tracing;

import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerEventListener;

public class PrintStreamSchedulerTracer
implements ISchedulerEventListener {
    private PrintStream out;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("mm:ss:SSS");
    private final String label;

    public PrintStreamSchedulerTracer(String label, PrintStream s) {
        this.out = s;
        this.label = label;
    }

    public PrintStreamSchedulerTracer(String label) {
        this.label = label;
    }

    public void setPtrintStream(PrintStream s) {
        this.out = s;
    }

    public PrintStream getPrintStream() {
        return this.out;
    }

    @Override
    public void onTaskAdded(String taskName) {
        this.write("Added task to StepScheduler: " + taskName);
    }

    @Override
    public void onActivateTask(String task, long time) {
        this.write(String.valueOf(time) + " | onActivateTask " + task);
    }

    @Override
    public void onStartTask(String task, long time) {
        this.write(String.valueOf(time) + " | onStartTask " + task);
    }

    @Override
    public void onTerminateTask(String task, long time) {
        this.write(String.valueOf(time) + " | onTerminateTask " + task);
    }

    @Override
    public void onPreemptTask(String task, long time) {
        this.write(String.valueOf(time) + " | onPreemptTask " + task);
    }

    @Override
    public void onWaitTask(String task, long time, String muxName, String holder) {
        this.write(String.valueOf(time) + " | onWaitTask " + task);
    }

    @Override
    public void onReleaseTask(String task, long time) {
        this.write(String.valueOf(time) + " | onReleaseTask " + task);
    }

    @Override
    public void onTaskMissedDeadline(String task, long time, long remainingExectime) {
        this.write(String.valueOf(time) + " | onTaskMissedDeadline " + task);
    }

    @Override
    public void onStartIdleCore(long time) {
        this.write(String.valueOf(time) + " | onStartIdleCore ");
    }

    @Override
    public void onStopIdleCore(long time) {
        this.write(String.valueOf(time) + " | onStopIdleCore ");
    }

    private void write(String w) {
        String x = LocalDateTime.now().format(this.formatter);
        this.out.println(String.valueOf(x) + " " + this.getCoreName() + " -> " + w);
    }

    @Override
    public String getCoreName() {
        return this.label;
    }
}

