/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.helper;

import com.google.common.collect.HashMultimap;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMTag;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;

public class ConstraintBuilder {
    private HashMultimap<OMTag, OMCore> mTagToCore = HashMultimap.create();
    private HashMultimap<OMTask, OMCore> mTaskToCore = HashMultimap.create();

    public boolean fetchAllocationConstraints(List<OMTask> taskList, List<OMCore> coreList) {
        for (OMCore c : coreList) {
            if (c.getTags().size() <= 0) continue;
            Stream sTags = c.getTags().stream();
            sTags.forEach(item -> {
                boolean bl = this.mTagToCore.put(item, (Object)c);
            });
        }
        for (OMTask t : taskList) {
            if (t.getValidTags().size() > 0) {
                t.getValidTags().forEach(tag -> {
                    Set<OMCore> cores = this.getCoresByTag((OMTag)tag);
                    this.mTaskToCore.putAll((Object)t, cores);
                });
            } else {
                this.mTaskToCore.putAll((Object)t, coreList);
            }
            if (t.getInvalidTags().size() > 0) {
                t.getInvalidTags().forEach(tag -> {
                    Set<OMCore> cores = this.getCoresByTag((OMTag)tag);
                    if (cores != null && cores.size() > 0) {
                        cores.forEach(core -> {
                            boolean bl = this.mTaskToCore.remove((Object)t, core);
                        });
                    }
                });
            }
            System.out.println("---- VALID CORES FOR " + t.getTaskRef().getName() + " ----");
            this.mTaskToCore.get((Object)t).forEach(core -> System.out.print("|" + core + "|\n"));
        }
        return true;
    }

    private Set<OMCore> getCoresByTag(OMTag tag) {
        return this.mTagToCore.get((Object)tag);
    }

    public HashMultimap<OMTask, OMCore> getValidAllocationMap() {
        return this.mTaskToCore;
    }

    public Set<OMCore> getValidAlocationTargets(OMTask task) {
        return this.mTaskToCore.get((Object)task);
    }
}

