/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.helper;

import com.google.common.collect.HashMultimap;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.multicore.openmapping.algorithms.helper.ConstraintBuilder;
import org.eclipse.app4mc.multicore.openmapping.algorithms.helper.ListBuilder;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;
import org.eclipse.app4mc.multicore.sharelibs.ConsoleOutputHandler;

public class ProblemGraph {
    private final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");
    ConstraintBuilder cb;
    private final Amalthea model;
    private List<OMTask> taskList;
    private List<OMCore> coreList;

    public ProblemGraph(Amalthea model) {
        this.model = model;
    }

    public boolean initialize() {
        this.taskList = ListBuilder.getTaskList(this.model.getSwModel());
        if (this.taskList == null) {
            this.con.append("Error during TaskList generation, exiting.");
            return false;
        }
        this.coreList = ListBuilder.getCoreList(this.model.getHwModel());
        if (this.coreList == null) {
            this.con.append("Error during CoreList generation, exiting.");
            return false;
        }
        this.cb = new ConstraintBuilder();
        if (!this.cb.fetchAllocationConstraints(this.taskList, this.coreList)) {
            this.con.append("Error during Constraint generation, exiting.");
            return false;
        }
        return true;
    }

    public List<OMTask> getTaskList() {
        return this.taskList;
    }

    public List<OMCore> getCoreList() {
        return this.coreList;
    }

    public HashMultimap<OMTask, OMCore> getValidAllocationMap() {
        return this.cb.getValidAllocationMap();
    }

    public Set<OMCore> getValidAlocationTargets(OMTask task) {
        return this.cb.getValidAlocationTargets(task);
    }
}

