/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.AdvancedCore;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.ExtendedRunnable;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.VoltageLevel;
import org.ojalgo.optimisation.Variable;

public class AdvancedRunnable
extends ExtendedRunnable
implements Comparable<AdvancedRunnable> {
    private static long lastIndex = 0L;
    private final long index;
    private long lFinishTime = -1L;
    private long readyTime = 0L;
    private long startTime = 0L;
    private long fastestExecTime;
    private Variable varDu;
    private Variable varNu;
    private final Map<VoltageLevel, Variable> varNui = new HashMap<VoltageLevel, Variable>();

    public AdvancedRunnable(Runnable ref) {
        super(ref);
        this.index = lastIndex++;
    }

    void setLft(long lft) {
        assert (lft > 0L);
        this.lFinishTime = lft;
    }

    long getLft() {
        return this.lFinishTime;
    }

    void setExecTime(long psPerInstruction) {
        this.fastestExecTime = this.getNumberOfInstructions() * psPerInstruction;
    }

    long getExecTime() {
        return this.fastestExecTime;
    }

    long getPriority() {
        return this.lFinishTime + this.getEarliestStartTime();
    }

    void setReadyTime(long readyTime) {
        this.readyTime = readyTime;
    }

    long getReadyTime() {
        return this.readyTime;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    long getStartTime() {
        return this.startTime;
    }

    long getEarliestStartTime() {
        if (this.readyTime < AdvancedCore.getMinAvailTime()) {
            return this.readyTime;
        }
        return AdvancedCore.getMinAvailTime();
    }

    public Variable getVarDu() {
        return this.varDu;
    }

    public void setVarDu(Variable du) {
        this.varDu = du;
    }

    public Variable getVarNui(VoltageLevel v) {
        return this.varNui.get(v);
    }

    public Map<VoltageLevel, Variable> getVarNuis() {
        return this.varNui;
    }

    public void setVarNu(Variable nu) {
        this.varNu = nu;
    }

    public Variable getVarNu() {
        return this.varNu;
    }

    public void addVarNui(VoltageLevel v, Variable nui) {
        this.varNui.put(v, nui);
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public int compareTo(AdvancedRunnable ar) {
        if (this.getPriority() > ar.getPriority()) {
            return 1;
        }
        if (this.getPriority() < ar.getPriority()) {
            return -1;
        }
        return 0;
    }
}

