/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CoreAllocation;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.RunnableAllocation;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.AdvancedCore;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.AdvancedRunnable;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.ExtendedCore;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.VoltageLevel;
import org.ojalgo.optimisation.Variable;

public class MappingBuilder {
    private final List<VoltageLevel> lVoltageLevels = new LinkedList<VoltageLevel>();
    private final List<AbstractMap.SimpleEntry<AdvancedCore, AdvancedRunnable>> mRunToCore = new LinkedList<AbstractMap.SimpleEntry<AdvancedCore, AdvancedRunnable>>();
    private final List<AbstractMap.SimpleEntry<ExtendedCore, Scheduler>> mCoreToScheduler = new LinkedList<AbstractMap.SimpleEntry<ExtendedCore, Scheduler>>();
    private final Map<AdvancedCore, Long> mCoreUtilizationOrig = new HashMap<AdvancedCore, Long>();
    private final Map<AdvancedCore, Long> mCoreUtilizationReal = new HashMap<AdvancedCore, Long>();
    private final Map<AdvancedCore, Long> mCoreUtilizationSlower = new HashMap<AdvancedCore, Long>();
    private final AmaltheaFactory mmInstance = AmaltheaFactory.eINSTANCE;
    private final AmaltheaFactory commonInstance = AmaltheaFactory.eINSTANCE;
    private MappingModel mappingModel = null;
    private long lMaxUtil;
    private String sAllocation;
    private String sBarChart;
    private String sSlowDown;

    public void addRunnableToCore(AdvancedCore c, AdvancedRunnable r) {
        this.mRunToCore.add(new AbstractMap.SimpleEntry<AdvancedCore, AdvancedRunnable>(c, r));
    }

    public void generateMapping() {
        this.generateMappingModel();
        this.generateAllocationString();
        this.generateBarChart();
        this.generateSlowDownText();
    }

    private void generateSlowDownText() {
        long realVal;
        long origVal;
        this.sSlowDown = "\nIncrease in execution time due to lower VoltageLevels:\n";
        for (Map.Entry<AdvancedCore, Long> entry : this.mCoreUtilizationReal.entrySet()) {
            this.sSlowDown = String.valueOf(this.sSlowDown) + " " + entry.getKey().getCore().getName() + ":\t";
            origVal = this.mCoreUtilizationOrig.get(entry.getKey());
            realVal = entry.getValue();
            this.sSlowDown = String.valueOf(this.sSlowDown) + String.format("+ %.5f", 100.0 / (double)origVal * (double)realVal - 100.0) + "%\n";
        }
        this.sSlowDown = String.valueOf(this.sSlowDown) + "\nInstructions running at lower VoltageLevels:\n";
        for (Map.Entry<AdvancedCore, Long> entry : this.mCoreUtilizationSlower.entrySet()) {
            this.sSlowDown = String.valueOf(this.sSlowDown) + " " + entry.getKey().getCore().getName() + ":\t";
            origVal = this.mCoreUtilizationOrig.get(entry.getKey());
            realVal = entry.getValue();
            this.sSlowDown = String.valueOf(this.sSlowDown) + String.format("+ %.5f", 100.0 / (double)origVal * (double)realVal) + "%\n";
        }
    }

    private void generateMappingModel() {
        ExtendedCore c;
        this.mappingModel = this.mmInstance.createMappingModel();
        for (AbstractMap.SimpleEntry<ExtendedCore, Scheduler> entry : this.mCoreToScheduler) {
            CoreAllocation ca = this.mmInstance.createCoreAllocation();
            c = entry.getKey();
            Scheduler s = entry.getValue();
            try {
                ca.setScheduler(s);
                ca.getCore().add((Object)c.getCore());
                this.mappingModel.getCoreAllocation().add((Object)ca);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        VoltageLevel vlBest = this.lVoltageLevels.get(0);
        for (AbstractMap.SimpleEntry<AdvancedCore, AdvancedRunnable> entry : this.mRunToCore) {
            c = entry.getKey();
            AdvancedRunnable r = entry.getValue();
            long leftCycles = r.getNumberOfInstructions();
            long tmpCycles = this.mCoreUtilizationOrig.containsKey(c) ? this.mCoreUtilizationOrig.get(c) + leftCycles : leftCycles;
            this.mCoreUtilizationOrig.put((AdvancedCore)c, tmpCycles);
            long tmpProcCycles = 0L;
            if (this.mCoreUtilizationReal.containsKey(c)) {
                tmpProcCycles = this.mCoreUtilizationReal.get(c);
            }
            long slowerCycles = 0L;
            if (this.mCoreUtilizationSlower.containsKey(c)) {
                slowerCycles = this.mCoreUtilizationSlower.get(c);
            }
            RunnableAllocation ra = this.mmInstance.createRunnableAllocation();
            ra.setEntity(r.getRunnableRef());
            ra.setScheduler((Scheduler)c.getScheduler());
            for (Map.Entry<VoltageLevel, Variable> e : r.getVarNuis().entrySet()) {
                String vlName = e.getKey().getName();
                long vlCycles = e.getValue().getValue().longValue();
                leftCycles -= vlCycles;
                LongObject v = this.commonInstance.createLongObject();
                v.setValue(vlCycles);
                ra.getCustomProperties().put((Object)("EnEf-VoltageLevel_" + vlName), (Object)v);
                this.getMappingModel().getRunnableAllocation().add((Object)ra);
                tmpProcCycles += Math.round((double)vlCycles / e.getKey().getScale());
            }
            LongObject v = this.commonInstance.createLongObject();
            v.setValue(leftCycles);
            ra.getCustomProperties().put((Object)("EnEf-VoltageLevel_" + vlBest.getName()), (Object)v);
            this.getMappingModel().getRunnableAllocation().add((Object)ra);
            this.mCoreUtilizationReal.put((AdvancedCore)c, tmpProcCycles += Math.round((double)leftCycles / vlBest.getScale()));
            this.mCoreUtilizationSlower.put((AdvancedCore)c, slowerCycles + r.getNumberOfInstructions() - leftCycles);
        }
    }

    private void generateAllocationString() {
        this.sAllocation = "";
        for (AbstractMap.SimpleEntry<AdvancedCore, AdvancedRunnable> entry : this.mRunToCore) {
            AdvancedCore c = entry.getKey();
            AdvancedRunnable r = entry.getValue();
            this.sAllocation = String.valueOf(this.sAllocation) + "Allocation: '" + r.getRunnableRef().getName() + "' <=> '" + c.getCore().getName() + "'\n";
        }
    }

    private void generateBarChart() {
        this.lMaxUtil = Collections.max(this.mCoreUtilizationReal.values());
        System.out.println(this.lMaxUtil);
        this.sBarChart = "Core (#Runnables) - Utilization                              - Cycles          - Time (round to 5 fig.)\n";
        this.sBarChart = String.valueOf(this.sBarChart) + "-------------------------------------------------------------------------------------------------------\n";
        for (Map.Entry<AdvancedCore, Long> entry : this.mCoreUtilizationReal.entrySet()) {
            AdvancedCore c = entry.getKey();
            Long cycles = entry.getValue();
            double curUtil = 40.0 / (double)this.lMaxUtil * (double)cycles.longValue();
            this.sBarChart = String.valueOf(this.sBarChart) + String.format("%-12s %4s - ", c.getCore().getName(), "(" + c.getRunnables().size() + ")");
            int i = 0;
            while (i < 40) {
                this.sBarChart = (double)i < curUtil ? String.valueOf(this.sBarChart) + "X" : String.valueOf(this.sBarChart) + " ";
                ++i;
            }
            this.sBarChart = String.valueOf(this.sBarChart) + String.format(" - %-,15d - %-,18.5f ms\n", cycles, (double)entry.getValue().longValue() / entry.getKey().getCyclesPerSecond() * 1000.0);
        }
    }

    public MappingModel getMappingModel() {
        return this.mappingModel;
    }

    public String getAllocation() {
        return this.sAllocation;
    }

    public String getBarChart() {
        return this.sBarChart;
    }

    public String getSlowDownText() {
        return this.sSlowDown;
    }

    public void setVoltageLevels(List<VoltageLevel> vl) {
        assert (this.lVoltageLevels.size() == 0);
        this.lVoltageLevels.addAll(vl);
        Collections.sort(this.lVoltageLevels);
    }

    public void addCoreToSchedulder(ExtendedCore c, Scheduler s) {
        this.mCoreToScheduler.add(new AbstractMap.SimpleEntry<ExtendedCore, Scheduler>(c, s));
    }
}

