/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.lb;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractILPBasedMappingAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.algorithms.helper.ListBuilder;
import org.eclipse.app4mc.multicore.openmapping.model.OMAllocation;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMMapping;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;
import org.eclipse.app4mc.multicore.sharelibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.optimisation.Expression;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.type.context.NumberContext;

public class ILPBasedLoadBalancing
extends AbstractILPBasedMappingAlgorithm {
    private List<OMTask> taskList = new ArrayList<OMTask>();
    private List<OMCore> coreList = new ArrayList<OMCore>();
    private final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");

    private Boolean parseConstraints() {
        return true;
    }

    private Boolean performMappingAlgorithm() {
        int noCores = this.coreList.size();
        int noTasks = this.taskList.size();
        if (noCores == 1) {
            return this.mapToFirstCore();
        }
        Variable[][] vars = new Variable[noTasks][noCores];
        Variable z = new Variable("z").integer(false);
        this.getEbm().addVariable(z);
        Expression obj = this.getEbm().addExpression("Objective");
        obj.setLinearFactor(z, (Number)1);
        obj.weight((Number)new BigDecimal(1));
        UniversalHandler.getInstance().logCon("Setting Objective...");
        UniversalHandler.getInstance().logCon(" " + obj.getName() + " - " + obj.getLinearFactor(z) + " x " + z.getName() + " = " + z.getValue());
        UniversalHandler.getInstance().logCon("Setting constraints (hint: Z and the upper bound won't be listed here)...");
        for (OMCore c : this.coreList) {
            int coreIndex = this.coreList.indexOf(c);
            Expression coreExp = this.getEbm().addExpression(" Utilization_Core" + coreIndex);
            for (OMTask t : this.taskList) {
                int taskIndex = this.taskList.indexOf(t);
                BigDecimal exCore = BigDecimal.valueOf(new OMAllocation(t, c).calculateProcessingTime());
                Variable tmp = Variable.makeBinary((String)("map_c" + coreIndex + "_t" + taskIndex));
                this.getEbm().addVariable(tmp);
                coreExp.setLinearFactor(tmp, (Number)exCore);
                vars[taskIndex][coreIndex] = tmp;
                UniversalHandler.getInstance().logCon(String.valueOf(coreExp.getName()) + " - " + coreExp.getLinearFactor(tmp) + " x " + tmp.getName() + " = " + tmp.getValue());
            }
            coreExp.setLinearFactor(z, (Number)-1);
            coreExp.upper((Number)new BigDecimal("0", MathContext.DECIMAL128));
        }
        UniversalHandler.getInstance().logCon("Setting one-task-per-core constraints (hint: bounds wont be listed here)...");
        for (OMTask tmp : this.taskList) {
            int taskIndex = this.taskList.indexOf(tmp);
            Expression assignLimit = this.getEbm().addExpression(" AssignLimit_Task" + taskIndex);
            for (OMCore cTmp : this.coreList) {
                int coreIndex = this.coreList.indexOf(cTmp);
                assignLimit.setLinearFactor(vars[taskIndex][coreIndex], (Number)1);
                UniversalHandler.getInstance().logCon(String.valueOf(assignLimit.getName()) + " - " + assignLimit.getLinearFactor(vars[taskIndex][coreIndex]) + " x " + vars[taskIndex][coreIndex].getName() + " = " + vars[taskIndex][coreIndex].getValue());
            }
            assignLimit.level((Number)BigDecimal.valueOf(1L));
        }
        this.con.appendln("ILP solver settings");
        this.con.appendln(" Max gap: " + this.getEbm().options.mip_gap);
        this.con.appendln(" Max iterations (abort): " + this.getEbm().options.iterations_abort);
        this.con.appendln(" Max iterations (suffice): " + this.getEbm().options.iterations_suffice);
        this.con.appendln(" Max time (abort): " + this.getEbm().options.time_abort);
        this.con.appendln(" Max time (suffice): " + this.getEbm().options.time_suffice);
        this.con.appendln("Working...");
        this.getEbm().options.problem = NumberContext.getGeneral((int)16, (int)16);
        Optimisation.Result res = this.getEbm().minimise();
        this.con.appendln("Objective Minimization done!");
        this.con.appendln(" Objective value: " + res.getValue());
        this.con.appendln(" Solution state: " + res.getState().toString());
        this.con.appendln("");
        OMMapping mapping = this.generateOMMapping(vars);
        this.updateModel(mapping);
        this.con.focus();
        return true;
    }

    private OMMapping generateOMMapping(Variable[][] vars) {
        OMMapping mapping = new OMMapping();
        for (OMTask t : this.taskList) {
            int taskIndex = this.taskList.indexOf(t);
            Variable[] allocation = vars[taskIndex];
            int i = 0;
            while (i < allocation.length) {
                if (allocation[i].getValue().compareTo(BigDecimal.ONE) == 0) {
                    try {
                        OMCore core = this.coreList.get(i);
                        OMAllocation alloc = new OMAllocation(t, core);
                        mapping.addAllocation(alloc);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return mapping;
    }

    @Override
    public void calculateMapping() {
        long timeStep3;
        String sVersion = "Using: " + OjAlgoUtils.getTitle() + " " + OjAlgoUtils.getVersion() + " (" + OjAlgoUtils.getDate() + ")";
        this.con.appendln("Performing ILP based Load Balancing");
        this.con.appendln(sVersion);
        this.con.appendln("Preparing Models...");
        if (!this.initModels()) {
            this.con.appendln("Error during Model initialization, exiting.");
            return;
        }
        long timeStart = System.nanoTime();
        this.con.appendln("Step 1: Building Task-List...");
        this.taskList = ListBuilder.getTaskList(this.getMergedModel().getSwModel());
        if (this.taskList == null) {
            this.con.append("Error during Task generation, exiting.");
            return;
        }
        long timeStep1 = System.nanoTime();
        this.con.appendln(" Success! (" + (timeStep1 - timeStart) / 1000000L + "ms)");
        this.con.appendln("Step 2: Building Core-List...");
        this.coreList = ListBuilder.getCoreList(this.getMergedModel().getHwModel());
        if (this.coreList == null) {
            this.con.appendln("Error during Core generation, exiting.");
            return;
        }
        long timeStep2 = System.nanoTime();
        this.con.appendln(" Success! (" + (timeStep2 - timeStep1) / 1000000L + "ms)");
        this.con.appendln("Step 3: Determining Constraints and narrowing down the solution space... ");
        if (!this.hasConstraints().booleanValue()) {
            this.con.appendln(" There are no propertyConstraints set, skipping this step.");
            timeStep3 = System.nanoTime();
        } else {
            if (!this.parseConstraints().booleanValue()) {
                this.con.appendln("Error during constrain analysis, exiting.");
                return;
            }
            timeStep3 = System.nanoTime();
            this.con.appendln(" Success! (" + (timeStep3 - timeStep2) / 1000000L + "ms)");
        }
        this.con.appendln("Step 4: Creating Mapping...");
        if (!this.performMappingAlgorithm().booleanValue()) {
            this.con.appendln("Error during performMappingAlgorithm, exiting.");
            return;
        }
        long timeStep4 = System.nanoTime();
        this.con.appendln("Success after " + (timeStep4 - timeStep3) / 1000000L + "ms.");
        this.con.appendln("Leaving mapping algorithm.");
    }
}

