/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.taskgen.pragmatic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.Periodic;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Sporadic;
import org.eclipse.app4mc.amalthea.model.SporadicActivation;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.multicore.openmapping.OpenMappingPlugin;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractTaskCreationAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.model.OMProcessPrototype;
import org.eclipse.app4mc.multicore.openmapping.model.OMRunnable;
import org.eclipse.app4mc.multicore.sharelibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PragmaticTaskGenerator
extends AbstractTaskCreationAlgorithm {
    private final Map<Activation, Stimulus> mActivationStimuli = new HashMap<Activation, Stimulus>();
    private final ArrayList<OMProcessPrototype> lProcessPrototypes = new ArrayList();
    private final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");

    private boolean initProcessPrototypes() {
        if (this.getSwModel().getProcessPrototypes().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid SWModel.\nThere are no ProcessPrototypes in this model.\nLeaving Algorithm...", null);
            return false;
        }
        UniversalHandler.getInstance().logCon("Found " + this.getSwModel().getProcessPrototypes().size() + " Process Prototype(s)");
        for (ProcessPrototype pp : this.getSwModel().getProcessPrototypes()) {
            OMProcessPrototype ompp = new OMProcessPrototype(pp);
            this.lProcessPrototypes.add(ompp);
        }
        return true;
    }

    private boolean convertActivations() {
        if (this.getSwModel().getActivations().size() <= 0) {
            UniversalHandler.getInstance().logWarn("Unexpected SWModel: There are no Activation elements in this model. Leaving Algorithm...");
            return false;
        }
        UniversalHandler.getInstance().logCon("Found " + this.getSwModel().getActivations().size() + " Activation element(s)");
        for (Activation activation : this.getSwModel().getActivations()) {
            if (activation instanceof PeriodicActivation) {
                Periodic stimuliPeriodic = this.convertPeriodicActivation((PeriodicActivation)activation);
                this.getStimuliModel().getStimuli().add((Object)stimuliPeriodic);
                this.mActivationStimuli.put(activation, (Stimulus)stimuliPeriodic);
                continue;
            }
            if (activation instanceof SporadicActivation) {
                Sporadic stimuliSporadic = this.convertSporadicActivation((SporadicActivation)activation);
                this.getStimuliModel().getStimuli().add((Object)stimuliSporadic);
                this.mActivationStimuli.put(activation, (Stimulus)stimuliSporadic);
                continue;
            }
            UniversalHandler.getInstance().log("Unhandled Activation element.\nSkipping...", null);
        }
        return true;
    }

    private Periodic convertPeriodicActivation(PeriodicActivation activation) {
        String name = activation.getName();
        UniversalHandler.getInstance().logCon("Connverting Periodic Activation Element '" + name);
        Periodic stimuliPeriodic = this.getStimuliInstance().createPeriodic();
        stimuliPeriodic.setName(name);
        if (activation.getOffset() != null) {
            stimuliPeriodic.setOffset((Time)EcoreUtil.copy((EObject)activation.getOffset()));
        }
        if (activation.getMax() != null) {
            stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)activation.getMax()));
        }
        if (activation.getMin() != null) {
            stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)activation.getMin()));
        }
        if (activation.getDeadline() != null) {
            stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)activation.getDeadline()));
        }
        return stimuliPeriodic;
    }

    private Sporadic convertSporadicActivation(SporadicActivation activation) {
        String name = activation.getName();
        UniversalHandler.getInstance().logCon("Connverting Sporiadic Activation Element '" + name);
        Sporadic stimuliSporadic = this.getStimuliInstance().createSporadic();
        stimuliSporadic.setName(name);
        return stimuliSporadic;
    }

    @Override
    public void createTasks() {
        UniversalHandler.getInstance().setPluginId(OpenMappingPlugin.getPluginId());
        if (OpenMappingPlugin.getDefault() != null) {
            UniversalHandler.getInstance().setLog(OpenMappingPlugin.getDefault().getLog());
        }
        UniversalHandler.getInstance().log("Entering Pragmatic Task-Creation algorithm.");
        this.setStimuliModel(this.getStimuliInstance().createStimuliModel());
        if (!this.initProcessPrototypes()) {
            UniversalHandler.getInstance().log("Error during ProcessPrototype initialization.\nLeaving Algorithm...", null);
            return;
        }
        UniversalHandler.getInstance().logCon("ProcessPrototypes successfully initialized.");
        if (!this.convertActivations()) {
            UniversalHandler.getInstance().logWarn("Warning: No Activation Elements found. Skipping conversion.");
        } else {
            UniversalHandler.getInstance().logCon("Activation elements successfully converted.");
        }
        UniversalHandler.getInstance().log("Runnable Dependency Graph has been successfully created.", null);
        int iTotalRunnables = 0;
        for (OMProcessPrototype epp : this.lProcessPrototypes) {
            String name = epp.getName();
            epp.createRunnableGraph();
            Set<OMRunnable> lRunnables = epp.getRunnableList();
            if (lRunnables.isEmpty()) {
                UniversalHandler.getInstance().logCon("Unexpected Runnable list (List Empty?).\nSkipping entry...");
                break;
            }
            Task task = this.getSwInstance().createTask();
            task.setName("Task_" + name);
            CallGraph cGraph = this.getSwInstance().createCallGraph();
            CallSequence cSeq = this.getSwInstance().createCallSequence();
            for (OMRunnable run : lRunnables) {
                TaskRunnableCall trc = this.getSwInstance().createTaskRunnableCall();
                trc.setRunnable(run.getRunnableRef());
                cSeq.getCalls().add((Object)trc);
            }
            cGraph.getGraphEntries().add((Object)cSeq);
            task.setCallGraph(cGraph);
            if (epp.getProcessPrototype().getActivation() != null) {
                task.getStimuli().add((Object)this.mActivationStimuli.get(epp.getProcessPrototype().getActivation()));
            }
            this.getSwModel().getTasks().add((Object)task);
            iTotalRunnables += lRunnables.size();
            String msg = "Added Task: '" + task.getName() + "', Runnables: " + lRunnables.size();
            System.out.println("-----------------------------------------------------------------");
            System.out.println(epp.toString());
            System.out.println(lRunnables);
            UniversalHandler.getInstance().logCon(msg);
            this.con.appendln(msg);
        }
        UniversalHandler.getInstance().logCon("Leaving Pragmatic Task-Creation algorithm.");
        this.con.appendln("Done! " + iTotalRunnables + " Runnables in tasks\n");
        this.con.focus();
    }
}

