/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CriticalPath;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.DirectedGraph;

public class CPP {
    public SWModel swm;
    public ConstraintsModel cm;
    int ctcp = 0;
    public boolean bglobalCP = true;
    EList<ProcessPrototype> result = new BasicEList();
    private final Map<Runnable, CriticalPath.tf> cache = new HashMap<Runnable, CriticalPath.tf>();
    private CriticalPath globalCP = null;
    private final EList<Runnable> assignedNodes = new BasicEList();
    private DirectedGraph<Runnable, RunnableSequencingConstraint> graph;

    public CPP(SWModel swm, ConstraintsModel cm) {
        this.swm = swm;
        this.cm = cm;
    }

    public void build(IProgressMonitor monitor) {
        PartLog.getInstance().setLogName("CP Partitioning");
        if (this.swm == null) {
            PartLog.getInstance().log("No SWmodel for CP partitioning. Stopping.", null);
            return;
        }
        HashSet<AccessPrecedenceSpec> aps = new HashSet<AccessPrecedenceSpec>();
        aps.addAll((Collection<AccessPrecedenceSpec>)((ProcessPrototype)this.swm.getProcessPrototypes().get(0)).getAccessPrecedenceSpec());
        CriticalPath gcp = new CriticalPath(this.swm, this.cm);
        monitor.beginTask("Find ciritcal path", 1);
        EList<Runnable> gcpr = gcp.getCP();
        monitor.worked(1);
        this.graph = gcp.getGraph();
        int gcpl = 0;
        for (Runnable r : gcpr) {
            gcpl = (int)((long)gcpl + new Helper().getInstructions(r));
        }
        PartLog.getInstance().log("CP contains " + gcpr.size() + " Runnables and consumes " + gcpl + " instructions.");
        for (Runnable r : this.swm.getRunnables()) {
            this.cache.put(r, gcp.getTF(r));
            if (gcp.getTF((Runnable)r).lit < 0L) {
                PartLog.getInstance().log("Negative LIT value", null);
                break;
            }
            if (gcp.getTF((Runnable)r).lit >= gcp.getTF((Runnable)r).eit) continue;
            PartLog.getInstance().log("LIT < EIT", null);
            break;
        }
        if (this.swm.getProcessPrototypes().size() > 1) {
            PartLog.getInstance().log("GGP/AA performed. Partitioning starts for each ProcessPrototype!");
        }
        AmaltheaFactory cf = AmaltheaFactory.eINSTANCE;
        AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
        if (this.bglobalCP) {
            ProcessPrototype pp0 = swf.createProcessPrototype();
            pp0.setName("GCP00");
            for (Runnable r : gcpr) {
                this.assignedNodes.add((Object)r);
                TaskRunnableCall trc = swf.createTaskRunnableCall();
                trc.setRunnable(r);
                pp0.getRunnableCalls().add((Object)trc);
            }
            this.result.add((Object)pp0);
        }
        this.globalCP = gcp;
        long cpl = this.globalCP.getPathLength(gcpr);
        PartLog.getInstance().log("GCP00: " + this.globalCP.getPathString(gcpr));
        SWModel swm2 = swf.createSWModel();
        ConstraintsModel cm2 = cf.createConstraintsModel();
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            if (cm2.getRunnableSequencingConstraints().size() > 0) {
                BasicEList rscl = new BasicEList();
                for (RunnableSequencingConstraint rsc : cm2.getRunnableSequencingConstraints()) {
                    rscl.add((Object)rsc);
                }
                for (RunnableSequencingConstraint rsc : rscl) {
                    this.cm.getRunnableSequencingConstraints().add((Object)rsc);
                }
            }
            cm2.getRunnableSequencingConstraints().clear();
            swm2.getRunnables().clear();
            swm2.getProcessPrototypes().clear();
            EList<Runnable> llr = new EList<Runnable>();
            llr = new Helper().getRunnables(pp);
            for (Runnable ru : llr) {
                if (this.assignedNodes.contains((Object)ru)) continue;
                swm2.getRunnables().add((Object)ru);
            }
            BasicEList rscl = new BasicEList();
            for (RunnableSequencingConstraint rsc : this.cm.getRunnableSequencingConstraints()) {
                rscl.add((Object)rsc);
            }
            for (RunnableSequencingConstraint rsc : rscl) {
                if (!llr.contains(((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)) || !llr.contains(((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
                cm2.getRunnableSequencingConstraints().add((Object)rsc);
            }
            swm2.getActivations().addAll((Collection)this.swm.getActivations());
            int ct = 0;
            if (!this.bglobalCP && swm2.getRunnables().size() > 0) {
                CriticalPath lcp = new CriticalPath(swm2, cm2);
                EList<Runnable> lcpr = lcp.getCP();
                ProcessPrototype pp1 = swf.createProcessPrototype();
                pp1.setName("LCP" + ++this.ctcp + ct);
                for (Runnable r : lcpr) {
                    TaskRunnableCall trc = swf.createTaskRunnableCall();
                    trc.setRunnable(r);
                    pp1.getRunnableCalls().add((Object)trc);
                }
                this.result.add((Object)pp1);
                cpl = lcp.getPathLength(lcpr);
                for (Runnable r : lcpr) {
                    this.assignedNodes.add((Object)r);
                }
            }
            if (this.result.size() == 1) {
                ++ct;
            }
            int temp = swm2.getRunnables().size() - this.assignedNodes.size();
            monitor.beginTask("Assigning Runnables next to the ciritcal path to further ProcessProrotypes", temp);
            while (!this.assignedNodes.containsAll((Collection)swm2.getRunnables())) {
                monitor.worked(1);
                ProcessPrototype ppt = swf.createProcessPrototype();
                ppt.setName("PP" + this.ctcp + ct++);
                long ttime = 0L;
                for (Runnable r : swm2.getRunnables()) {
                    if (this.cache.get((Object)r).lit <= cpl) continue;
                    cpl = this.cache.get((Object)r).lit + new Helper().getInstructions(r);
                }
                block17: while (ttime < cpl) {
                    EList<Runnable> an = this.getAssignableNodes(ttime, swm2, cm2);
                    switch (an.size()) {
                        case 0: {
                            long nextTime = this.getNextAssignableRunnablesRT(ttime, swm2);
                            ttime = nextTime != ttime ? nextTime : ++ttime;
                            if (ttime != 0L) continue block17;
                            ttime = cpl;
                            break;
                        }
                        case 1: {
                            TaskRunnableCall trc = swf.createTaskRunnableCall();
                            trc.setRunnable((Runnable)an.get(0));
                            ppt.getRunnableCalls().add((Object)trc);
                            this.assignedNodes.add((Object)((Runnable)an.get(0)));
                            this.updateTFs((Runnable)an.get(0), ttime += new Helper().getInstructions((Runnable)an.get(0)));
                            break;
                        }
                        default: {
                            Runnable men = this.getMostEffectiveNode(an);
                            if (men == null) {
                                PartLog.getInstance().log("No most effective Runnable found - aborting", null);
                                return;
                            }
                            TaskRunnableCall trc2 = swf.createTaskRunnableCall();
                            trc2.setRunnable(men);
                            ppt.getRunnableCalls().add((Object)trc2);
                            this.assignedNodes.add((Object)((Runnable)an.get(an.indexOf((Object)men))));
                            this.updateTFs(men, ttime += new Helper().getInstructions(men));
                        }
                    }
                }
                if (ppt.getRunnableCalls().size() == 0) {
                    PartLog.getInstance().log("No Runnable found! Unassigned Nodes: ", null);
                    StringBuffer sb = new StringBuffer();
                    for (Runnable r : swm2.getRunnables()) {
                        if (this.assignedNodes.contains((Object)r)) continue;
                        sb.append(String.valueOf(r.getName()) + "(" + this.cache.get((Object)r).eit + " " + this.cache.get((Object)r).lit + "), ");
                    }
                    PartLog.getInstance().log(sb.toString());
                }
                this.result.add((Object)ppt);
            }
            if (!this.bglobalCP) continue;
            ++this.ctcp;
            --ct;
        }
        PartLog.getInstance().log("Critical Path Partitioning finished. Created ProcessPrototypes: " + this.result.size());
        for (ProcessPrototype pp : this.result) {
            StringBuffer sb = new StringBuffer();
            sb.append("ProcessPrototype " + pp.getName() + ": ");
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                sb.append(String.valueOf(trc.getRunnable().getName()) + " (" + this.cache.get((Object)trc.getRunnable()).eit + "," + this.cache.get((Object)trc.getRunnable()).lit + ") ");
            }
            PartLog.getInstance().log(sb.toString());
        }
        new Helper().assignAPs(aps);
        this.swm.getProcessPrototypes().clear();
        for (ProcessPrototype pp : this.result) {
            this.swm.getRunnables().addAll(new Helper().getRunnables(pp));
            this.swm.getProcessPrototypes().add((Object)pp);
        }
        this.cm.getRunnableSequencingConstraints().addAll((Collection)cm2.getRunnableSequencingConstraints());
        Amalthea amodels = AmaltheaFactory.eINSTANCE.createAmalthea();
        amodels.setConstraintsModel(this.cm);
        amodels.setSwModel(this.swm);
        this.cm = new Helper().updateRSCs(amodels.getConstraintsModel(), amodels.getSwModel());
        for (Runnable r : this.swm.getRunnables()) {
            if (r.getActivation() == null || this.swm.getActivations().contains((Object)r.getActivation())) continue;
            this.swm.getActivations().add((Object)r.getActivation());
        }
    }

    private void updateTFs(Runnable r, long ttime) {
        CriticalPath.tf ntf;
        long temp;
        long assignedTime = ttime - new Helper().getInstructions(r);
        long eitDistance = assignedTime - this.cache.get((Object)r).eit;
        long litDistance = this.cache.get((Object)r).lit - assignedTime;
        if (eitDistance > 0L) {
            Set<Runnable> srl = this.getSuceedingUnassignedRunnables(r);
            for (Runnable run : srl) {
                temp = 0L;
                ntf = this.cache.get(run);
                temp = ntf.eit + eitDistance;
                if (temp >= ntf.lit) continue;
                ntf.eit = temp;
                this.cache.put(run, ntf);
            }
        }
        if (litDistance > 0L) {
            Set<Runnable> prl = this.getPreceedingUnassignedRunnables(r);
            for (Runnable run : prl) {
                temp = 0L;
                ntf = this.cache.get(run);
                temp = ntf.lit - litDistance;
                if (temp <= ntf.eit || temp <= 0L) continue;
                ntf.lit = temp;
                this.cache.put(run, ntf);
            }
        }
    }

    private Set<Runnable> getPreceedingUnassignedRunnables(Runnable r) {
        Set originsrsc = this.graph.incomingEdgesOf((Object)r);
        HashSet<Runnable> origins = new HashSet<Runnable>();
        for (RunnableSequencingConstraint rsc : originsrsc) {
            if (this.assignedNodes.contains(this.graph.getEdgeSource((Object)rsc))) continue;
            origins.addAll(this.getPreceedingUnassignedRunnables((Runnable)this.graph.getEdgeSource((Object)rsc)));
        }
        if (!this.assignedNodes.contains((Object)r)) {
            origins.add(r);
        }
        return origins;
    }

    private Set<Runnable> getSuceedingUnassignedRunnables(Runnable r) {
        Set targetsrsc = this.graph.outgoingEdgesOf((Object)r);
        HashSet<Runnable> targets = new HashSet<Runnable>();
        for (RunnableSequencingConstraint rsc : targetsrsc) {
            if (this.assignedNodes.contains(this.graph.getEdgeTarget((Object)rsc))) continue;
            targets.addAll(this.getSuceedingUnassignedRunnables((Runnable)this.graph.getEdgeTarget((Object)rsc)));
        }
        if (!this.assignedNodes.contains((Object)r)) {
            targets.add(r);
        }
        return targets;
    }

    private long getNextAssignableRunnablesRT(long time, SWModel swm2) {
        long RunnablesCurrentStartTime = Long.MAX_VALUE;
        for (Runnable r : swm2.getRunnables()) {
            long st;
            if (this.assignedNodes.contains((Object)r) || (st = this.cache.get((Object)r).eit) < time || st >= RunnablesCurrentStartTime) continue;
            RunnablesCurrentStartTime = st;
        }
        if (RunnablesCurrentStartTime == Long.MAX_VALUE) {
            return 0L;
        }
        return RunnablesCurrentStartTime;
    }

    private Runnable getMostEffectiveNode(EList<Runnable> an) {
        HashMap<Runnable, Long> hm = new HashMap<Runnable, Long>();
        long cpl = this.globalCP.getPathLength();
        for (Runnable r : an) {
            long prio = 1L;
            prio += this.getCommunicationOverhead(r);
            CriticalPath.tf TF = this.cache.get(r);
            hm.put(r, prio *= cpl - (TF.lit - TF.eit > 0L ? TF.lit - TF.eit : 1L));
        }
        float temp = 0.0f;
        Runnable ret = null;
        for (Runnable r : hm.keySet()) {
            if (!((float)((Long)hm.get(r)).longValue() > temp)) continue;
            ret = r;
            temp = ((Long)hm.get(r)).longValue();
        }
        return ret;
    }

    private long getCommunicationOverhead(Runnable r) {
        int co = 0;
        if (r.getRunnableCalls().size() > 1) {
            PartLog.getInstance().log("Runnable is called multiple times", null);
            return 0L;
        }
        TaskRunnableCall trc = (TaskRunnableCall)r.getTaskRunnableCalls().get(0);
        if (trc == null) {
            PartLog.getInstance().log("Runnable " + r.getName() + " is never called");
            return 0L;
        }
        ProcessPrototype pp = null;
        Task t = null;
        if (trc.eContainer() instanceof ProcessPrototype) {
            pp = (ProcessPrototype)trc.eContainer();
        } else if (trc.eContainer() instanceof CallSequence) {
            t = (Task)trc.eContainer().eContainer().eContainer();
        }
        if (t == null && pp == null) {
            PartLog.getInstance().log("TRC neither task nor parocessPrototye", null);
            return 0L;
        }
        for (RunnableItem ri : r.getRunnableItems()) {
            LabelAccess laSource;
            if (!(ri instanceof LabelAccess) || (laSource = (LabelAccess)ri).getData() == null) continue;
            EList las = laSource.getData().getLabelAccesses();
            for (LabelAccess laOther : las) {
                Task ot;
                Runnable or;
                if (laOther.equals(laSource) || !(laOther.eContainer() instanceof Runnable) || r.equals(or = (Runnable)laOther.eContainer())) continue;
                TaskRunnableCall trc2 = (TaskRunnableCall)or.getTaskRunnableCalls().get(0);
                if (trc2.eContainer() instanceof ProcessPrototype) {
                    ProcessPrototype opp = (ProcessPrototype)trc2.eContainer();
                    if (opp.equals(pp) || opp.getName() == "allRunnables") continue;
                    if (laSource.getData().getSize() != null) {
                        co = (int)((long)co + laSource.getData().getSize().getNumberBits());
                        continue;
                    }
                    ++co;
                    continue;
                }
                if (!(trc2.eContainer() instanceof CallSequence) || (ot = (Task)trc2.eContainer().eContainer().eContainer()).equals(t)) continue;
                if (laSource.getData().getSize() != null) {
                    co = (int)((long)co + laSource.getData().getSize().getNumberBits());
                    continue;
                }
                ++co;
            }
        }
        return co;
    }

    private EList<Runnable> getAssignableNodes(long tt, SWModel swm2, ConstraintsModel cm2) {
        BasicEList an = new BasicEList();
        for (Runnable r : swm2.getRunnables()) {
            if (this.cache.get((Object)r).eit > tt || this.assignedNodes.contains((Object)r) || tt > this.cache.get((Object)r).lit) continue;
            an.add((Object)r);
        }
        return an;
    }
}

