/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CriticalPath;
import org.eclipse.app4mc.multicore.partitioning.algorithms.ESSPe;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class ESSP {
    public SWModel swm;
    public ConstraintsModel cm;
    private final EList<ProcessPrototype> tasks = new BasicEList();
    private final EList<Runnable> assignedNodes = new BasicEList();
    final Map<Runnable, Long> cache = new HashMap<Runnable, Long>();
    private final Map<ProcessPrototype, Long> TargetRT = new HashMap<ProcessPrototype, Long>();
    private Stack<Runnable> runs = new Stack();

    public ESSP(SWModel swmi, ConstraintsModel cmi, int tasks) {
        this.swm = swmi;
        this.cm = cmi;
        PartLog.getInstance().setLogName("ESS Partitioning");
        AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
        int i = 0;
        while (i < tasks) {
            ProcessPrototype pp = swf.createProcessPrototype();
            pp.setName("ESS" + i);
            this.tasks.add((Object)pp);
            this.TargetRT.put(pp, 0L);
            ++i;
        }
        if (tasks < this.swm.getProcessPrototypes().size()) {
            PartLog.getInstance().log("ESSP can't create less partitions than already present from independent graph groups (GGP) or activation groups (AA). ProcessPrototypes in file:" + this.swm.getProcessPrototypes().size() + ", configured partitions: " + tasks + ". ProcessPrototypes are resetted (AA/GGP is ignored).", null);
            this.swm.getProcessPrototypes().clear();
            ProcessPrototype pp = swf.createProcessPrototype();
            pp.setName("AllRunnables");
            for (Runnable r : this.swm.getRunnables()) {
                TaskRunnableCall trc = swf.createTaskRunnableCall();
                trc.setRunnable(r);
                pp.getRunnableCalls().add((Object)trc);
            }
            this.swm.getProcessPrototypes().add((Object)pp);
        }
        CriticalPath cp = new CriticalPath(this.swm, this.cm);
        for (Runnable r : swmi.getRunnables()) {
            this.cache.put(r, cp.getLongestPreceedingRT(r));
        }
    }

    public EList<ProcessPrototype> build(IProgressMonitor monitor) {
        HashSet<AccessPrecedenceSpec> aps = new HashSet<AccessPrecedenceSpec>();
        aps.addAll((Collection<AccessPrecedenceSpec>)((ProcessPrototype)this.swm.getProcessPrototypes().get(0)).getAccessPrecedenceSpec());
        if (this.swm.getProcessPrototypes().size() > 1) {
            return new ESSPe(this.swm, this.cm, this.tasks.size()).build(monitor);
        }
        this.runs = this.createRunnableStack();
        int temp = this.swm.getRunnables().size() - this.assignedNodes.size();
        monitor.beginTask("ESSP...", temp);
        while (this.assignedNodes.size() < this.swm.getRunnables().size()) {
            monitor.worked(1);
            Runnable r = this.runs.pop();
            int taskIndex = 0;
            EList<Integer> td = this.getRunnablesTaskDependencyIndices(r);
            switch (td.size()) {
                case 0: {
                    taskIndex = this.getIndexOfEarliestTask();
                    break;
                }
                case 1: {
                    taskIndex = (Integer)td.get(0);
                    break;
                }
                default: {
                    taskIndex = this.getIndexOfLatestTask(td);
                }
            }
            AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
            TaskRunnableCall trc = swf.createTaskRunnableCall();
            trc.setRunnable(r);
            ((ProcessPrototype)this.tasks.get(taskIndex)).getRunnableCalls().add((Object)trc);
            this.assignedNodes.add((Object)r);
            this.TargetRT.put((ProcessPrototype)this.tasks.get(taskIndex), this.TargetRT.get(this.tasks.get(taskIndex)) + new Helper().getInstructions(r));
        }
        monitor.done();
        this.swm.getProcessPrototypes().clear();
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            if (((ProcessPrototype)it.next()).getRunnableCalls().size() >= 1) continue;
            it.remove();
        }
        this.swm.getProcessPrototypes().addAll(this.tasks);
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            pp.setName("ESSP" + this.swm.getProcessPrototypes().indexOf((Object)pp));
        }
        new Helper().updateRSCs(this.cm, this.swm);
        new Helper().updatePPsFirstLastActParams(this.swm);
        new Helper().assignAPs(aps);
        PartLog.getInstance().log(new Helper().writePPs((EList<ProcessPrototype>)this.swm.getProcessPrototypes()));
        return this.swm.getProcessPrototypes();
    }

    private Stack<Runnable> createRunnableStack() {
        BasicEList rl = new BasicEList();
        rl.addAll(this.swm.getRunnables());
        Collections.sort(rl, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                return ESSP.this.cache.get(o2).intValue() - ESSP.this.cache.get(o1).intValue();
            }
        });
        Stack<Runnable> rs = new Stack<Runnable>();
        for (Runnable r : rl) {
            rs.push(r);
        }
        return rs;
    }

    private int getIndexOfLatestTask(EList<Integer> td) {
        int index = 0;
        long max = 0L;
        int i = 0;
        while (i < td.size()) {
            if (this.TargetRT.get(this.tasks.get(((Integer)td.get(i)).intValue())) > max) {
                max = this.TargetRT.get(this.tasks.get(((Integer)td.get(i)).intValue()));
                index = (Integer)td.get(i);
            }
            ++i;
        }
        return index;
    }

    private EList<Integer> getRunnablesTaskDependencyIndices(Runnable r) {
        LinkedList<RunnableSequencingConstraint> prevRuns = new LinkedList<RunnableSequencingConstraint>();
        Set rscs = new CriticalPath(this.swm, this.cm).getGraph().incomingEdgesOf((Object)r);
        for (RunnableSequencingConstraint rsc : rscs) {
            prevRuns.add(rsc);
        }
        EList<Runnable> latestRunnablesAtTasks = this.getLatestRunnablesAtTasks();
        BasicEList TaskIndexes = new BasicEList();
        for (RunnableSequencingConstraint rsc : prevRuns) {
            if (!latestRunnablesAtTasks.contains(((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0))) continue;
            TaskIndexes.add((Object)this.getTaskIndexOf((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)));
        }
        return TaskIndexes;
    }

    private Integer getTaskIndexOf(Runnable runnable) {
        for (ProcessPrototype pp : this.tasks) {
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                if (!trc.getRunnable().equals(runnable)) continue;
                return this.tasks.indexOf((Object)pp);
            }
        }
        PartLog.getInstance().log("Runnable " + runnable.getName() + " is not yet assigned to a task!");
        return null;
    }

    private EList<Runnable> getLatestRunnablesAtTasks() {
        BasicEList ltr = new BasicEList();
        for (ProcessPrototype pp : this.tasks) {
            int temp = pp.getRunnableCalls().size();
            if (temp == 0) continue;
            ltr.add((Object)((TaskRunnableCall)pp.getRunnableCalls().get(--temp)).getRunnable());
        }
        return ltr;
    }

    private int getIndexOfEarliestTask() {
        int index = 0;
        long min = Long.MAX_VALUE;
        for (ProcessPrototype pp : this.TargetRT.keySet()) {
            if (this.TargetRT.get(pp) >= min) continue;
            min = this.TargetRT.get(pp);
            index = this.tasks.indexOf((Object)pp);
        }
        return index;
    }
}

