/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CriticalPath;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;

public class ESSPe {
    public SWModel swm;
    public ConstraintsModel cm;
    final Map<Runnable, Long> cache = new HashMap<Runnable, Long>();
    private int tasknumber = 0;
    private final DirectedAcyclicGraph<Runnable, RunnableSequencingConstraint> graph;
    private final List<ProcessPrototype> exceptPPs = new BasicEList();

    public ESSPe(SWModel swmi, ConstraintsModel cmi, int tasks) {
        this.swm = swmi;
        this.cm = cmi;
        this.tasknumber = tasks;
        PartLog.getInstance().setLogName("ESS Partitioning");
        CriticalPath cp = new CriticalPath(this.swm, this.cm);
        this.graph = cp.getGraph();
        for (Runnable r : swmi.getRunnables()) {
            this.cache.put(r, cp.getLongestPreceedingRT(r));
        }
    }

    public EList<ProcessPrototype> build(IProgressMonitor monitor) {
        HashSet<AccessPrecedenceSpec> aps = new HashSet<AccessPrecedenceSpec>();
        aps.addAll((Collection<AccessPrecedenceSpec>)((ProcessPrototype)this.swm.getProcessPrototypes().get(0)).getAccessPrecedenceSpec());
        int addTasks = this.tasknumber - this.swm.getProcessPrototypes().size();
        int taskCunter = 0;
        monitor.beginTask("ESSP...", addTasks);
        while (addTasks-- > 0) {
            monitor.worked(1);
            AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
            ProcessPrototype ppNew1 = swf.createProcessPrototype();
            ProcessPrototype ppNew2 = swf.createProcessPrototype();
            ppNew1.setName("ESSP" + taskCunter++);
            ppNew2.setName("ESSP" + taskCunter++);
            BasicEList ppl = new BasicEList();
            ppl.add(ppNew1);
            ppl.add(ppNew2);
            this.exceptPPs.clear();
            ProcessPrototype ppEdit = this.getLongestPP();
            if (ppEdit != null) {
                Stack<Runnable> rs = this.createRunnableStack(ppEdit);
                while (!rs.isEmpty()) {
                    TaskRunnableCall trc = swf.createTaskRunnableCall();
                    trc.setRunnable(rs.pop());
                    if (this.RDependsOn1(trc.getRunnable(), (List<ProcessPrototype>)ppl)) {
                        ((ProcessPrototype)ppl.get(0)).getRunnableCalls().add((Object)trc);
                        continue;
                    }
                    if (this.RDependsOn2(trc.getRunnable(), (List<ProcessPrototype>)ppl)) {
                        ((ProcessPrototype)ppl.get(1)).getRunnableCalls().add((Object)trc);
                        continue;
                    }
                    int i = this.getIndexOfEarliestTask((List<ProcessPrototype>)ppl);
                    ((ProcessPrototype)ppl.get(i)).getRunnableCalls().add((Object)trc);
                }
            }
            if (this.pplContainsEmptyEntry((List<ProcessPrototype>)ppl)) break;
            this.swm.getProcessPrototypes().addAll((Collection)ppl);
            this.swm.getProcessPrototypes().remove((Object)ppEdit);
        }
        monitor.done();
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            pp.setName("ESSP" + this.swm.getProcessPrototypes().indexOf((Object)pp));
        }
        new Helper().updateRSCs(this.cm, this.swm);
        new Helper().updatePPsFirstLastActParams(this.swm);
        new Helper().assignAPs(aps);
        PartLog.getInstance().log(new Helper().writePPs((EList<ProcessPrototype>)this.swm.getProcessPrototypes()));
        return this.swm.getProcessPrototypes();
    }

    private boolean pplContainsEmptyEntry(List<ProcessPrototype> ppl) {
        for (ProcessPrototype pp : ppl) {
            if (pp.getRunnableCalls().size() >= 1) continue;
            return true;
        }
        return false;
    }

    private boolean RDependsOn2(Runnable runnable, List<ProcessPrototype> ppl) {
        if (ppl.size() == 2 && ppl.get(1).getRunnableCalls().size() > 0) {
            Runnable d = ((TaskRunnableCall)ppl.get(1).getRunnableCalls().get(ppl.get(1).getRunnableCalls().size() - 1)).getRunnable();
            Set sources = this.graph.incomingEdgesOf((Object)runnable);
            for (RunnableSequencingConstraint rsc : sources) {
                if (!((Runnable)this.graph.getEdgeSource((Object)rsc)).equals(d)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean RDependsOn1(Runnable runnable, List<ProcessPrototype> ppl) {
        if (ppl.size() == 2 && ppl.get(0).getRunnableCalls().size() > 0) {
            Runnable d = ((TaskRunnableCall)ppl.get(0).getRunnableCalls().get(ppl.get(0).getRunnableCalls().size() - 1)).getRunnable();
            Set sources = this.graph.incomingEdgesOf((Object)runnable);
            for (RunnableSequencingConstraint rsc : sources) {
                if (!((Runnable)this.graph.getEdgeSource((Object)rsc)).equals(d)) continue;
                return true;
            }
        }
        return false;
    }

    private int getIndexOfEarliestTask(List<ProcessPrototype> ppl) {
        int index = 0;
        long min = Long.MAX_VALUE;
        for (ProcessPrototype pp : ppl) {
            long ppi = new Helper().getPPInstructions(pp);
            if (ppi >= min) continue;
            min = ppi;
            index = ppl.indexOf(pp);
        }
        return index;
    }

    private Stack<Runnable> createRunnableStack(ProcessPrototype PPs) {
        BasicEList rl = new BasicEList();
        for (TaskRunnableCall trc : PPs.getRunnableCalls()) {
            rl.add(trc.getRunnable());
        }
        Collections.sort(rl, new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                return ESSPe.this.cache.get(o2).intValue() - ESSPe.this.cache.get(o1).intValue();
            }
        });
        Stack<Runnable> rs = new Stack<Runnable>();
        for (Runnable r : rl) {
            rs.push(r);
        }
        return rs;
    }

    private ProcessPrototype getLongestPP() {
        ProcessPrototype pps = null;
        long max = 0L;
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            long temp = new Helper().getPPInstructions(pp);
            if (!this.exceptPPs.isEmpty()) {
                if (temp <= max || this.exceptPPs.contains(pp)) continue;
                max = temp;
                pps = pp;
                continue;
            }
            if (temp <= max) continue;
            max = temp;
            pps = pp;
        }
        if (pps == null) {
            PartLog.getInstance().log("No longest Runnable found", null);
            return null;
        }
        if (pps.getRunnableCalls().size() < 2 || this.isSequence(pps)) {
            this.exceptPPs.add(pps);
            return this.getLongestPP();
        }
        return pps;
    }

    private boolean isSequence(ProcessPrototype pps) {
        for (TaskRunnableCall trc : pps.getRunnableCalls()) {
            int counter;
            Runnable r = trc.getRunnable();
            if (this.graph.incomingEdgesOf((Object)r).size() > 1) {
                counter = 0;
                for (RunnableSequencingConstraint rsc : this.graph.incomingEdgesOf((Object)r)) {
                    Runnable source = (Runnable)this.graph.getEdgeSource((Object)rsc);
                    if (new Helper().getPPfromR(r, this.swm).equals(new Helper().getPPfromR(source, this.swm))) {
                        ++counter;
                    }
                    if (counter <= 1) continue;
                    return false;
                }
                continue;
            }
            if (this.graph.outgoingEdgesOf((Object)r).size() <= 1) continue;
            counter = 0;
            for (RunnableSequencingConstraint rsc : this.graph.outgoingEdgesOf((Object)r)) {
                Runnable target = (Runnable)this.graph.getEdgeTarget((Object)rsc);
                if (new Helper().getPPfromR(r, this.swm).equals(new Helper().getPPfromR(target, this.swm))) {
                    ++counter;
                }
                if (counter <= 1) continue;
                return false;
            }
        }
        return true;
    }
}

