/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.algorithms.CriticalPath;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;

public class GGP {
    private final SWModel swm;
    private final ConstraintsModel cm;
    private LinkedList<Runnable> unassigned = new LinkedList();
    LinkedList<LinkedList<Runnable>> tasks = new LinkedList();
    private final LinkedList<Runnable> visited = new LinkedList();
    private final LinkedList<Runnable> unvisited = new LinkedList();
    private DirectedAcyclicGraph<Runnable, RunnableSequencingConstraint> graph = null;

    GGP(SWModel swm, LinkedList<Runnable> uCNs, LinkedList<LinkedList<Runnable>> threads, ConstraintsModel cm) {
        this.swm = swm;
        this.unassigned = uCNs;
        this.tasks = threads;
        this.cm = cm;
    }

    public GGP(SWModel swm, ConstraintsModel cm) {
        this.cm = cm;
        this.swm = swm;
        for (Runnable r : swm.getRunnables()) {
            this.unassigned.add(r);
            this.unvisited.add(r);
        }
    }

    public GGP(SWModel swm, ConstraintsModel cm, DirectedAcyclicGraph<Runnable, RunnableSequencingConstraint> graph) {
        this.cm = cm;
        this.swm = swm;
        this.graph = graph;
    }

    public void build() {
        if (this.unassigned.size() == 0) {
            this.unassigned.addAll((Collection<Runnable>)this.swm.getRunnables());
        } else if (this.unassigned.size() != this.swm.getRunnables().size()) {
            PartLog.getInstance().log("Unassigned != Runnables.size");
        }
        PartLog.getInstance().setLogName("GG Partitioning");
        if (this.swm.getProcessPrototypes().size() == 0) {
            AmaltheaFactory swf = AmaltheaFactory.eINSTANCE;
            ProcessPrototype pp = swf.createProcessPrototype();
            pp.setName("AllRunnables");
            for (Runnable runnable : this.swm.getRunnables()) {
                TaskRunnableCall trc = swf.createTaskRunnableCall();
                trc.setRunnable(runnable);
                pp.getRunnableCalls().add((Object)trc);
            }
            this.swm.getProcessPrototypes().add((Object)pp);
        }
        this.graph = new CriticalPath(this.getSwm(), this.getCm()).getGraph();
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            this.genGraphs(pp);
        }
        StringBuffer sb = new StringBuffer();
        int ct = 0;
        for (LinkedList linkedList : this.tasks) {
            sb.append(String.valueOf(ct++) + ": ");
            for (Runnable r : linkedList) {
                sb.append(String.valueOf(r.getName()) + ", ");
            }
            sb.append("\n");
        }
        this.correctPPs();
    }

    private void genGraphs(ProcessPrototype pp) {
        LinkedList<Runnable> sinks = this.getSinks(pp);
        if (sinks.size() == 0) {
            PartLog.getInstance().log("getGraph didnt find unhandled Runnable at" + pp.getName() + " TRCs " + pp.getRunnableCalls().size(), null);
            return;
        }
        for (Runnable r : sinks) {
            if (!this.unassigned.contains(r)) continue;
            Set<Runnable> task = this.getCoherentNodes(r, pp);
            this.unassigned.removeAll(task);
            LinkedList<Runnable> temp = new LinkedList<Runnable>();
            temp.addAll(task);
            this.tasks.add(temp);
        }
    }

    private LinkedList<Runnable> getSinks(ProcessPrototype pp) {
        LinkedList<Runnable> sinks = this.getSinks();
        HashSet<Runnable> rs = new HashSet<Runnable>();
        for (TaskRunnableCall trc : pp.getRunnableCalls()) {
            rs.add(trc.getRunnable());
        }
        sinks.retainAll(rs);
        return sinks;
    }

    public LinkedList<Runnable> getSinks() {
        LinkedList<Runnable> sinks = new LinkedList<Runnable>();
        for (Runnable r : this.swm.getRunnables()) {
            if (this.graph.outgoingEdgesOf((Object)r).size() == 0) {
                sinks.add(r);
                continue;
            }
            Set oe = this.graph.outgoingEdgesOf((Object)r);
            int ct = 0;
            for (RunnableSequencingConstraint rsc : oe) {
                Runnable target = (Runnable)this.graph.getEdgeTarget((Object)rsc);
                if (new Helper().getPPfromR(r, this.swm).equals(new Helper().getPPfromR(target, this.swm))) continue;
                ++ct;
            }
            if (oe.size() != ct) continue;
            sinks.add(r);
        }
        if (sinks.size() == 0) {
            PartLog.getInstance().log("No sink found", null);
        }
        return sinks;
    }

    private Set<Runnable> getCoherentNodes(Runnable r, ProcessPrototype pp) {
        HashSet<Runnable> rl = new HashSet<Runnable>();
        rl.add(r);
        this.visited.add(r);
        for (RunnableSequencingConstraint rsc : this.graph.incomingEdgesOf((Object)r)) {
            Runnable source = (Runnable)this.graph.getEdgeSource((Object)rsc);
            if (!new Helper().getPPfromR(source, this.swm).equals(pp) || this.visited.contains(source)) continue;
            rl.addAll(this.getCoherentNodes(source, pp));
        }
        for (RunnableSequencingConstraint rsc : this.graph.outgoingEdgesOf((Object)r)) {
            Runnable target = (Runnable)this.graph.getEdgeTarget((Object)rsc);
            if (!new Helper().getPPfromR(target, this.swm).equals(pp) || this.visited.contains(target)) continue;
            rl.addAll(this.getCoherentNodes(target, pp));
        }
        return rl;
    }

    public SWModel getSwm() {
        return this.swm;
    }

    public ConstraintsModel getCm() {
        return this.cm;
    }

    private void correctPPs() {
        this.swm.getProcessPrototypes().clear();
        int i = 0;
        for (LinkedList linkedList : this.tasks) {
            AmaltheaFactory instance = AmaltheaFactory.eINSTANCE;
            ProcessPrototype pp = instance.createProcessPrototype();
            for (Runnable r : linkedList) {
                TaskRunnableCall trc = instance.createTaskRunnableCall();
                trc.setRunnable(r);
                pp.getRunnableCalls().add((Object)trc);
            }
            pp.setName("PP" + i++);
            pp.setActivation(((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getActivation());
            pp.setFirstRunnable((Runnable)linkedList.get(0));
            pp.setLastRunnable((Runnable)linkedList.get(linkedList.size() - 1));
            this.swm.getProcessPrototypes().add((Object)pp);
        }
        for (RunnableSequencingConstraint runnableSequencingConstraint : this.cm.getRunnableSequencingConstraints()) {
            Runnable source = (Runnable)((ProcessRunnableGroup)runnableSequencingConstraint.getRunnableGroups().get(0)).getRunnables().get(0);
            Runnable target = (Runnable)((ProcessRunnableGroup)runnableSequencingConstraint.getRunnableGroups().get(1)).getRunnables().get(0);
            if (!this.swm.getRunnables().contains((Object)source) || !this.swm.getRunnables().contains((Object)target)) {
                PartLog.getInstance().log("Runnable " + source.getName() + " / " + target.getName() + " could not be found. SWM.size:" + this.swm.getRunnables().size(), null);
            }
            for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
                for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                    if (trc.getRunnable().equals(source)) {
                        runnableSequencingConstraint.getProcessScope().clear();
                        runnableSequencingConstraint.getProcessScope().add((Object)pp);
                        continue;
                    }
                    if (!trc.getRunnable().equals(target)) continue;
                    runnableSequencingConstraint.getProcessScope().clear();
                    runnableSequencingConstraint.getProcessScope().add((Object)pp);
                }
            }
        }
    }
}

