/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.handlers;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.multicore.partitioning.PartitioningPlugin;
import org.eclipse.app4mc.multicore.partitioning.algorithms.PartitioningJob;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PartitioningHandler
extends AbstractHandler {
    private IPreferenceStore store = PartitioningPlugin.getDefault().getPreferenceStore();

    public PartitioningHandler() {
        this.store = PartitioningPlugin.getDefault().getPreferenceStore();
    }

    public PartitioningHandler(IPreferenceStore store) {
        this.store = store;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        UniversalHandler uh = UniversalHandler.getInstance();
        PartLog.getInstance().setLogName("PrePartitioning");
        PartLog.getInstance().setEnableTargetConsoleLog(this.store.getBoolean("org.eclipse.app4mc.multicore.partitioning.debug"));
        IFile file = UniversalHandler.getInstance().getSelectedFile(event);
        uh.dropCache();
        uh.readModels(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
        Amalthea amodels = AmaltheaFactory.eINSTANCE.createAmalthea();
        amodels = new Helper().setAllModels(amodels, uh);
        PartitioningJob part = new PartitioningJob("Partitioning", amodels, this.store, file);
        part.schedule();
        try {
            part.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Partitioning", (String)(part.getResult().equals(Status.OK_STATUS) ? "Partitioning successful" : "Partitioning failed. Please see console / error log for details."));
        return null;
    }
}

