/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.ProcessRunnableGroup;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class Helper {
    List<Runnable> visited = new BasicEList();

    public long getInstructions(Runnable r) {
        long rt = 0L;
        for (RunnableItem ra : r.getRunnableItems()) {
            if (!(ra instanceof RunnableInstructions)) continue;
            RunnableInstructions ri = (RunnableInstructions)ra;
            long l = ri.getDefault() instanceof InstructionsConstant ? ((InstructionsConstant)ri.getDefault()).getValue() : (rt = ri.getDefault() instanceof InstructionsDeviation ? (((LongObject)((InstructionsDeviation)ri.getDefault()).getDeviation().getLowerBound()).getValue() + ((LongObject)((InstructionsDeviation)ri.getDefault()).getDeviation().getUpperBound()).getValue()) / 2L : 0L);
        }
        if (rt == 0L) {
            PartLog.getInstance().log("No instructions constant / deviation found at Runnable " + r.getName() + ". Assuming 1.");
            InstructionsConstant ic = AmaltheaFactory.eINSTANCE.createInstructionsConstant();
            ic.setValue(1L);
            r.getRunnableItems().add((Object)((RunnableItem)ic));
            rt = 1L;
        }
        return rt;
    }

    public ProcessPrototype getPPfromR(Runnable runnable, SWModel swm) {
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                if (!trc.getRunnable().equals(runnable)) continue;
                return pp;
            }
        }
        PartLog.getInstance().log("getPPFromR did not find PP for Runnable " + runnable.getName(), null);
        return null;
    }

    public long getPreceedingRunTimeCycle(ConstraintsModel cm, Runnable r) {
        if (r == null) {
            return Long.MAX_VALUE;
        }
        long rt = 0L;
        this.visited.add(r);
        for (RunnableSequencingConstraint rsc : cm.getRunnableSequencingConstraints()) {
            long temp;
            if (!((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)).equals(r) || this.visited.contains(((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)) || (temp = this.getPreceedingRunTimeCycle(cm, (Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0))) <= rt) continue;
            rt = temp;
        }
        return rt + this.getInstructions(r);
    }

    public long getSucceedingRunTimeCycle(ConstraintsModel cm, Runnable r) {
        if (r == null) {
            return Long.MAX_VALUE;
        }
        long rt = 0L;
        this.visited.add(r);
        for (RunnableSequencingConstraint rsc : cm.getRunnableSequencingConstraints()) {
            long temp;
            if (!((Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)).equals(r) || this.visited.contains(((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)) || (temp = this.getSucceedingRunTimeCycle(cm, (Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) <= rt) continue;
            rt = temp;
        }
        return rt + this.getInstructions(r);
    }

    public Label getCommonLabel(Runnable runnable, Runnable runnable2) {
        for (RunnableItem ri1 : runnable.getRunnableItems()) {
            if (!(ri1 instanceof LabelAccess)) continue;
            LabelAccess la1 = (LabelAccess)ri1;
            for (RunnableItem ri2 : runnable2.getRunnableItems()) {
                if (!(ri2 instanceof LabelAccess)) continue;
                LabelAccess la2 = (LabelAccess)ri2;
                if (!la1.getData().equals(la2.getData()) || (!la1.getAccess().equals((Object)LabelAccessEnum.READ) || !la2.getAccess().equals((Object)LabelAccessEnum.WRITE)) && (!la1.getAccess().equals((Object)LabelAccessEnum.WRITE) || !la2.getAccess().equals((Object)LabelAccessEnum.READ))) continue;
                return la1.getData();
            }
        }
        return null;
    }

    public static void writeModelFile(IFile file, URI path, ArrayList<EObject> models) {
        PartLog.getInstance().log("Writing " + path.toString() + "\n");
        UniversalHandler.getInstance().writeModel(path, models);
    }

    public static void writeModelFile(IFile file, URI path, Amalthea models) {
        PartLog.getInstance().log("Writing " + path.toString() + "\n");
        UniversalHandler.getInstance().writeModel(path, (EObject)models);
    }

    public EList<Runnable> getRunnables(ProcessPrototype pp) {
        BasicEList rl = new BasicEList();
        for (TaskRunnableCall trc : pp.getRunnableCalls()) {
            rl.add((Object)trc.getRunnable());
        }
        return rl;
    }

    public Amalthea setAllModels(Amalthea amodels, UniversalHandler uh) {
        amodels.setCommonElements(uh.getCommonElements());
        amodels.setConstraintsModel(uh.getConstraintsModel());
        amodels.setHwModel(uh.getHwModel());
        amodels.setMappingModel(uh.getMappingModel());
        amodels.setOsModel(uh.getOsModel());
        amodels.setPropertyConstraintsModel(uh.getPropertyConstraintsModel());
        amodels.setStimuliModel(uh.getStimuliModel());
        amodels.setSwModel(uh.getSwModel());
        amodels.setEventModel(uh.getEvModel());
        amodels.setComponentsModel(uh.getComModel());
        amodels.setConfigModel(uh.getConfModel());
        return amodels;
    }

    public void assignAPs(Set<AccessPrecedenceSpec> aps) {
        for (AccessPrecedenceSpec ap : aps) {
            Runnable r = ap.getOrigin();
            EList trcs = r.getTaskRunnableCalls();
            for (TaskRunnableCall trc : trcs) {
                ProcessPrototype pp = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                if (trc.eContainer() instanceof ProcessPrototype) {
                    pp = (ProcessPrototype)trc.eContainer();
                }
                if (pp.getName() == null || pp.getAccessPrecedenceSpec().contains((Object)ap)) continue;
                pp.getAccessPrecedenceSpec().add((Object)ap);
            }
        }
    }

    public ConstraintsModel updateRSCs(ConstraintsModel cm, SWModel swm) {
        for (RunnableSequencingConstraint rsc : cm.getRunnableSequencingConstraints()) {
            Runnable source = (Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0);
            Runnable target = (Runnable)((ProcessRunnableGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0);
            for (ProcessPrototype pp : swm.getProcessPrototypes()) {
                for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                    if (trc.getRunnable().equals(source)) {
                        rsc.getProcessScope().clear();
                        rsc.getProcessScope().add((Object)pp);
                        continue;
                    }
                    if (!trc.getRunnable().equals(target)) continue;
                    rsc.getProcessScope().clear();
                    rsc.getProcessScope().add((Object)pp);
                }
            }
        }
        return cm;
    }

    public SWModel updatePPsFirstLastActParams(SWModel swm) {
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            if (pp.getRunnableCalls().size() > 0) {
                if (pp.getFirstRunnable() == null || pp.getFirstRunnable() != ((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable()) {
                    pp.setFirstRunnable(((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable());
                }
                if (pp.getLastRunnable() == null || pp.getLastRunnable() != ((TaskRunnableCall)pp.getRunnableCalls().get(pp.getRunnableCalls().size() - 1)).getRunnable()) {
                    pp.setLastRunnable(((TaskRunnableCall)pp.getRunnableCalls().get(pp.getRunnableCalls().size() - 1)).getRunnable());
                }
            }
            if (pp.getActivation() == null && ((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getActivation() != null) {
                pp.setActivation(((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getActivation());
                continue;
            }
            if (((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getActivation() != null) continue;
            PartLog.getInstance().log("Runnable " + ((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getName() + " has no activation, this might be a problem for the mapping process.");
        }
        return swm;
    }

    public String writePPs(EList<ProcessPrototype> processPrototypes) {
        StringBuffer sb = new StringBuffer();
        for (ProcessPrototype pp : processPrototypes) {
            sb.append("ProcessPrototype " + pp.getName() + "(" + this.getPPInstructions(pp) + ") : ");
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                sb.append(String.valueOf(trc.getRunnable().getName()) + " ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public long getPPInstructions(ProcessPrototype pp) {
        long instrSum = 0L;
        for (TaskRunnableCall trc : pp.getRunnableCalls()) {
            instrSum += new Helper().getInstructions(trc.getRunnable());
        }
        return instrSum;
    }
}

