/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;

public class TagToPP {
    private final SWModel swm;
    private final CommonElements cem;

    public SWModel getSwm() {
        return this.swm;
    }

    public TagToPP(SWModel sw, CommonElements ce) {
        this.swm = sw;
        this.cem = ce;
    }

    public void createPPsFromTags() {
        if (this.cem.getTags() == null || this.cem == null) {
            PartLog.getInstance().log("Either no Tags or no CommonElements model existing");
            return;
        }
        if (this.swm == null || this.swm.getRunnables() == null) {
            PartLog.getInstance().log("Either no Runnables or no CommonElements model existing");
            return;
        }
        HashMap<Tag, Integer> TagPPIndexMap = new HashMap<Tag, Integer>();
        int noTagIndex = -1;
        if (this.swm.getProcessPrototypes() == null || this.swm.getProcessPrototypes().size() < 1) {
            for (Runnable r : this.swm.getRunnables()) {
                if (r.getTags() == null || r.getTags().size() == 0) {
                    TaskRunnableCall trc = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                    trc.setRunnable(r);
                    if (noTagIndex == -1) {
                        ProcessPrototype pp = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                        if (r.getActivation() != null) {
                            pp.setActivation(r.getActivation());
                        }
                        pp.setName("NoTag");
                        pp.getRunnableCalls().add((Object)trc);
                        noTagIndex = this.swm.getProcessPrototypes().size();
                        this.swm.getProcessPrototypes().add((Object)pp);
                    } else if (r.getActivation().equals(((ProcessPrototype)this.swm.getProcessPrototypes().get(noTagIndex)).getActivation())) {
                        ((ProcessPrototype)this.swm.getProcessPrototypes().get(noTagIndex)).getRunnableCalls().add((Object)trc);
                    }
                }
                if (1 != r.getTags().size()) continue;
                Tag rt = (Tag)r.getTags().get(0);
                TaskRunnableCall trc = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                trc.setRunnable(r);
                if (!TagPPIndexMap.containsKey(rt)) {
                    ProcessPrototype pp = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                    pp.setName("Tag_" + rt.getName());
                    pp.getTags().add((Object)rt);
                    pp.getRunnableCalls().add((Object)trc);
                    TagPPIndexMap.put(rt, this.swm.getProcessPrototypes().size());
                    this.swm.getProcessPrototypes().add((Object)pp);
                    continue;
                }
                ((ProcessPrototype)this.swm.getProcessPrototypes().get(((Integer)TagPPIndexMap.get(rt)).intValue())).getRunnableCalls().add((Object)trc);
            }
        } else {
            ListIterator ppIt = this.swm.getProcessPrototypes().listIterator();
            while (ppIt.hasNext()) {
                ProcessPrototype pp = (ProcessPrototype)ppIt.next();
                Tag t = null;
                HashMap<Tag, Integer> indexMap = new HashMap<Tag, Integer>();
                Iterator trcIt = pp.getRunnableCalls().iterator();
                while (trcIt.hasNext()) {
                    TaskRunnableCall trc = (TaskRunnableCall)trcIt.next();
                    if (trc.getRunnable().getTags() == null || 1 != trc.getRunnable().getTags().size()) continue;
                    Tag currentTag = (Tag)trc.getRunnable().getTags().get(0);
                    if (t == null) {
                        t = currentTag;
                    }
                    if (currentTag == t) continue;
                    PartLog.getInstance().log("Different Tag within one ProcessPrototye " + pp.getName() + "(" + t.getName() + "," + currentTag.getName() + ") - Splitting into separate PPs");
                    if (indexMap.containsKey(currentTag)) {
                        trcIt.remove();
                        ((ProcessPrototype)this.swm.getProcessPrototypes().get(((Integer)indexMap.get(currentTag)).intValue())).getRunnableCalls().add((Object)trc);
                        continue;
                    }
                    ProcessPrototype pps = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                    pps.setName(String.valueOf(pp.getName()) + "_Tag" + currentTag.getName());
                    trcIt.remove();
                    pps.getRunnableCalls().add((Object)trc);
                    pps.getTags().add((Object)t);
                    indexMap.put(currentTag, this.swm.getProcessPrototypes().size());
                    ppIt.add(pps);
                }
            }
        }
    }
}

