/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters081.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters081.utils.ConstraintElementsCacheBuilder;
import org.eclipse.app4mc.amalthea.converters081.utils.ConstraintElementsCacheEnum;
import org.eclipse.app4mc.amalthea.converters081.utils.HelperUtils_080_081;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ConstraintsConverter
extends AbstractConverter {
    private ConstraintElementsCacheBuilder constraintElementsCacheBuilder;
    private List<ICache> caches;

    public ConstraintsConverter() {
        this.helper = HelperUtils_080_081.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.8.0 to 0.8.1  : Executing Constraints converter for model file : " + targetFile.getName()));
        this.caches = caches;
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateEventChainElementDefinitions_and_references(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateEventChainElementDefinitions_and_references(Element rootElement) {
        List rootEventChainElements = this.helper.getXpathResult(rootElement, "./constraintsModel/eventChains", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        List<String> allRootEventChainElements = this.getAllRootEventChainElements();
        if (rootEventChainElements.size() > 0) {
            for (Element rootEventChainElement : rootEventChainElements) {
                List subEventChainElements = this.helper.getXpathResult(rootEventChainElement, ".//*[@xsi:type=\"am:SubEventChain\"]", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
                for (Element subEventChainElement : subEventChainElements) {
                    Attribute typeAttribute = subEventChainElement.getAttribute("type", this.helper.getGenericNS("xsi"));
                    if (typeAttribute == null) continue;
                    typeAttribute.setValue("am:EventChainContainer");
                }
                this.updateEventChainReferences(allRootEventChainElements, rootEventChainElement);
            }
        }
        this.updateEventChainReferences_in_TimingConstraints(allRootEventChainElements, rootElement);
    }

    private void updateEventChainReferences_in_TimingConstraints(List<String> allRootEventChainElements, Element rootElement) {
        List eventChainReferenceEleemnts = this.helper.getXpathResult(rootElement, "./constraintsModel/timingConstraints[@xsi:type=\"am:EventChainLatencyConstraint\" or @xsi:type=\"am:EventChainSynchronizationConstraint\"]", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element timingConstraint : eventChainReferenceEleemnts) {
            List eventChains;
            String refEventChainName;
            ArrayList<String> invalidEventChainRefs = new ArrayList<String>();
            Attribute eventChainsAttribute = timingConstraint.getAttribute("scope");
            if (eventChainsAttribute != null) {
                boolean isRefEventChainStringsUpdated = false;
                String refEventChainStrings = eventChainsAttribute.getValue();
                StringTokenizer stringTokenizer = new StringTokenizer(refEventChainStrings);
                while (stringTokenizer.hasMoreTokens()) {
                    String refEventChainString = stringTokenizer.nextToken();
                    refEventChainName = refEventChainString.substring(0, refEventChainString.lastIndexOf("?"));
                    if (allRootEventChainElements.contains(refEventChainName)) continue;
                    isRefEventChainStringsUpdated = true;
                    refEventChainStrings = refEventChainStrings.replace(refEventChainString, "");
                    invalidEventChainRefs.add(refEventChainString);
                    if (refEventChainStrings.trim().length() == 0) {
                        timingConstraint.removeAttribute(eventChainsAttribute);
                    }
                    this.logEventChainMessage_TimingConstraint(timingConstraint, refEventChainName);
                }
                if (isRefEventChainStringsUpdated) {
                    eventChainsAttribute.setValue(refEventChainStrings.trim());
                }
            }
            if ((eventChains = timingConstraint.getChildren("scope")) != null) {
                for (Element eventChainElement : eventChains) {
                    String hrefValue = eventChainElement.getAttributeValue("href");
                    if (hrefValue == null || !hrefValue.contains("amlt:/#") || allRootEventChainElements.contains(refEventChainName = hrefValue.substring(hrefValue.indexOf("#") + 1, hrefValue.indexOf("?")))) continue;
                    timingConstraint.removeContent((Content)eventChainElement);
                    invalidEventChainRefs.add(hrefValue);
                    this.logEventChainMessage_TimingConstraint(timingConstraint, refEventChainName);
                }
            }
            if (invalidEventChainRefs.size() <= 0) continue;
            Element customPropertyElement = new Element("customProperties");
            customPropertyElement.setAttribute("key", "scope");
            Element valueElement = new Element("value");
            valueElement.setAttribute("type", "am:ListObject", this.helper.getGenericNS("xsi"));
            for (String invalidEventChainRef : invalidEventChainRefs) {
                Element valuesElement = new Element("values");
                valuesElement.setAttribute("type", "am:StringObject", this.helper.getGenericNS("xsi"));
                valuesElement.setAttribute("value", invalidEventChainRef);
                valueElement.addContent((Content)valuesElement);
            }
            customPropertyElement.addContent((Content)valueElement);
            timingConstraint.addContent((Content)customPropertyElement);
        }
    }

    private void updateEventChainReferences(List<String> allRootEventChainElements, Element rootEventChainElement) {
        List eventChainReferenceEleemnts = this.helper.getXpathResult(rootEventChainElement, ".//*[@xsi:type=\"am:EventChainReference\"]", Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element eventChainReferenceElement : eventChainReferenceEleemnts) {
            String refEventChainName;
            String hrefValue;
            Element eventChainElement;
            String refEventChainName2;
            String refEventChainString;
            Attribute eventChainReferenceAttribute = eventChainReferenceElement.getAttribute("eventChain");
            if (eventChainReferenceAttribute != null && (refEventChainString = eventChainReferenceAttribute.getValue()) != null && refEventChainString.contains("?") && !allRootEventChainElements.contains(refEventChainName2 = refEventChainString.substring(0, refEventChainString.lastIndexOf("?")))) {
                eventChainReferenceElement.removeAttribute(eventChainReferenceAttribute);
                this.logEventChainMessage_and_Create_CustomProperty(rootEventChainElement, eventChainReferenceElement, refEventChainString, refEventChainName2);
            }
            if ((eventChainElement = eventChainReferenceElement.getChild("eventChain")) == null || (hrefValue = eventChainElement.getAttributeValue("href")) == null || !hrefValue.contains("amlt:/#") || allRootEventChainElements.contains(refEventChainName = hrefValue.substring(hrefValue.indexOf("#") + 1, hrefValue.indexOf("?")))) continue;
            eventChainReferenceElement.removeContent((Content)eventChainElement);
            this.logEventChainMessage_and_Create_CustomProperty(rootEventChainElement, eventChainReferenceElement, hrefValue, refEventChainName);
        }
    }

    private void logEventChainMessage_TimingConstraint(Element timingConstraintElement, String refEventChainName) {
        this.logger.warn((Object)("Sub EventChain : " + refEventChainName + " is referred inside TimingConstraint as \"Scope\": " + timingConstraintElement.getAttributeValue("name") + ". As per 0.8.0, it is not valid to refer sub EventChain elements directly." + System.getProperty("line.separator") + " EventChain " + refEventChainName + "'s association is removed from TimingConstraint object, and corresponding information is stored as a CustomProperty"));
    }

    private void logEventChainMessage_and_Create_CustomProperty(Element rootEventChainElement, Element eventChainReferenceElement, String refEventChainString, String refEventChainName) {
        this.logger.warn((Object)("Sub EventChain : " + refEventChainName + " is referred inside EventChainReference of EventChain : " + rootEventChainElement.getAttributeValue("name") + ". As per 0.8.0, it is not valid to refer sub EventChain elements inside EventChainReference." + System.getProperty("line.separator") + " eventChain association is removed from EventChainReference object, and corresponding information is stored as a CustomProperty"));
        Element customPropertyElement = new Element("customProperties");
        customPropertyElement.setAttribute("key", "eventChain");
        Element valueElement = new Element("value");
        valueElement.setAttribute("type", "am:StringObject", this.helper.getGenericNS("xsi"));
        valueElement.setAttribute("value", refEventChainString);
        customPropertyElement.addContent((Content)valueElement);
        eventChainReferenceElement.addContent((Content)customPropertyElement);
    }

    private List<String> getAllRootEventChainElements() {
        ArrayList<String> rootEventChainNames = new ArrayList<String>();
        if (this.getConstraintElementsCacheBuilder() != null) {
            Map<File, Map<String, Object>> cacheMap = this.getConstraintElementsCacheBuilder().getCacheMap();
            Collection<Map<String, Object>> values = cacheMap.values();
            for (Map<String, Object> map : values) {
                Object value = map.get(ConstraintElementsCacheEnum.ROOT_EVENTCHAIN_NAMES.name());
                if (!(value instanceof List)) continue;
                rootEventChainNames.addAll((Collection)value);
            }
        }
        return rootEventChainNames;
    }

    private ConstraintElementsCacheBuilder getConstraintElementsCacheBuilder() {
        if (this.constraintElementsCacheBuilder == null) {
            for (ICache cache : this.caches) {
                if (!(cache instanceof ConstraintElementsCacheBuilder)) continue;
                this.constraintElementsCacheBuilder = (ConstraintElementsCacheBuilder)cache;
                return this.constraintElementsCacheBuilder;
            }
        }
        return this.constraintElementsCacheBuilder;
    }
}

