/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.app4mc.amalthea.converters.common.utils.BaseHelperUtils;
import org.eclipse.app4mc.amalthea.converters.ui.dialog.MigrationErrorDialog;
import org.eclipse.app4mc.amalthea.converters.ui.dialog.ModelMigrationDialog;
import org.eclipse.app4mc.amalthea.converters.ui.handlers.AbstractModelConverterHandler;
import org.eclipse.app4mc.amalthea.converters.ui.jobs.ModelLoaderJob;
import org.eclipse.app4mc.amalthea.converters.ui.log.utils.CustomEclipseLogAppender;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationSettings;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class AmaltheaModelMigrationHandler
extends AbstractModelConverterHandler {
    private MigrationSettings migrationSettings;
    private final String LATEST_MODEL_VERSION = "0.8.1";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
        this.logger.removeAllAppenders();
        CustomEclipseLogAppender customEclipseLogAppender = new CustomEclipseLogAppender();
        customEclipseLogAppender.addFilter(new Filter(){

            public int decide(LoggingEvent event) {
                Level level = event.getLevel();
                if (level == Level.INFO || level == Level.TRACE) {
                    return -1;
                }
                return 1;
            }
        });
        this.logger.addAppender((Appender)customEclipseLogAppender);
        this.logger.setAdditivity(false);
        this.logger.setLevel(Level.ALL);
        this.migrationSettings = new MigrationSettings();
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        this.helper = BaseHelperUtils.getInstance();
        String projectSegment = null;
        if (selection instanceof TreeSelection) {
            TreePath[] paths = ((TreeSelection)selection).getPaths();
            ArrayList<File> inputModels = new ArrayList<File>();
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IFile iFile;
                Object lastSegment;
                TreePath treePath = treePathArray[n2];
                Object firstSegment = treePath.getFirstSegment();
                if (projectSegment == null) {
                    projectSegment = firstSegment.toString();
                    IProject iProject = (IProject)((IAdaptable)firstSegment).getAdapter(IProject.class);
                    if (iProject != null) {
                        String path = iProject.getLocation().toOSString();
                        File file = new File(path);
                        this.migrationSettings.setProject(file);
                        this.migrationSettings.setiProject(iProject);
                    }
                } else if (!projectSegment.equals(firstSegment.toString())) {
                    MessageDialog.openError((Shell)activeShell, (String)"AMALTHEA Model Migration", (String)"Model files across the projects should not be selected for migration");
                    return null;
                }
                if ((lastSegment = treePath.getLastSegment()) instanceof IAdaptable && (iFile = (IFile)((IAdaptable)lastSegment).getAdapter(IFile.class)) != null) {
                    String path = iFile.getRawLocation().toOSString();
                    File file = new File(path);
                    try {
                        inputModels.add(file.getCanonicalFile());
                    }
                    catch (IOException e) {
                        this.logger.error((Object)("Error fetching the file : " + iFile.toString()), (Throwable)e);
                    }
                }
                ++n2;
            }
            ModelLoaderJob job = new ModelLoaderJob("Parsing selected files to obtain referred AMALTHEA models and corresponding Model versions", this.migrationSettings, inputModels, this.helper);
            job.setUser(true);
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(final IJobChangeEvent event) {
                    super.done(event);
                    if (event.getResult().equals(Status.OK_STATUS)) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                List<MigrationInputFile> modelsWithInvalidVersionInfo = this.getModelsWithInvalidVersionInfo(AmaltheaModelMigrationHandler.this.getMigrationSettings());
                                if (modelsWithInvalidVersionInfo.size() > 0) {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("Invalid model versions found for the below files ->");
                                    stringBuffer.append(System.getProperty("line.separator"));
                                    stringBuffer.append(System.getProperty("line.separator"));
                                    for (MigrationInputFile migrationFile : modelsWithInvalidVersionInfo) {
                                        stringBuffer.append(migrationFile.getFile().getAbsolutePath());
                                        stringBuffer.append(System.getProperty("line.separator"));
                                    }
                                    Shell shell = new Shell(Display.getDefault());
                                    MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)stringBuffer.toString());
                                } else {
                                    boolean status = this.setInputModelVersion(AmaltheaModelMigrationHandler.this.getMigrationSettings());
                                    Shell shell = new Shell(Display.getDefault());
                                    if (!status) {
                                        MigrationErrorDialog errorDialog = new MigrationErrorDialog(shell, AmaltheaModelMigrationHandler.this.getMigrationSettings());
                                        errorDialog.open();
                                    } else if (AmaltheaModelMigrationHandler.this.getMigrationSettings().getInputModelVersion() != null && AmaltheaModelMigrationHandler.this.getMigrationSettings().getInputModelVersion().equals("0.8.1")) {
                                        MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA Model Migration", (String)("Selected models are compatible to latest AMALTHEA meta-model version (" + "0.8.1" + ")\nIt is not required to migrate these models !!"));
                                    } else {
                                        ModelMigrationDialog dialog = new ModelMigrationDialog(shell, AmaltheaModelMigrationHandler.this.getMigrationSettings());
                                        dialog.open();
                                    }
                                }
                            }

                            private boolean setInputModelVersion(MigrationSettings migrationSettings) {
                                boolean status = true;
                                String inputModelVersion = null;
                                for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
                                    if (inputModelVersion == null) {
                                        inputModelVersion = migModelFile.getModelVersion();
                                        continue;
                                    }
                                    if (inputModelVersion.equals(migModelFile.getModelVersion())) continue;
                                    migModelFile.setVersionDifferent(true);
                                    status = false;
                                }
                                if (!status) {
                                    return status;
                                }
                                migrationSettings.setInputModelVersion(inputModelVersion);
                                return true;
                            }

                            private List<MigrationInputFile> getModelsWithInvalidVersionInfo(MigrationSettings migrationSettings) {
                                ArrayList<MigrationInputFile> list = new ArrayList<MigrationInputFile>();
                                for (MigrationInputFile migModelFile : migrationSettings.getMigModelFiles()) {
                                    String inputModelVersion = migModelFile.getModelVersion();
                                    if (inputModelVersion != null && (inputModelVersion.equals("itea.103") || inputModelVersion.equals("itea.110") || inputModelVersion.equals("itea.111") || inputModelVersion.equals("0.7.0") || inputModelVersion.equals("0.7.1") || inputModelVersion.equals("0.7.2") || inputModelVersion.equals("0.8.0") || inputModelVersion.equals("0.8.1"))) continue;
                                    list.add(migModelFile);
                                }
                                return list;
                            }
                        });
                    } else if (event.getResult().getCode() == Status.CANCEL_STATUS.getCode()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = new Shell(Display.getDefault());
                                MessageDialog.openError((Shell)shell, (String)"AMALTHEA Model Migration", (String)event.getResult().getMessage());
                            }
                        });
                    }
                }
            });
        }
        return null;
    }

    public MigrationSettings getMigrationSettings() {
        return this.migrationSettings;
    }
}

