/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableModeSwitch;
import org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch;

public class SoftwareUtil {
    public static List<CallSequenceItem> collectCalls(Process process) {
        return SoftwareUtil.collectCalls(process, null);
    }

    public static List<CallSequenceItem> collectCalls(Process process, List<ModeLiteral> modes) {
        ArrayList<CallSequenceItem> itemList = new ArrayList<CallSequenceItem>();
        if (process.getCallGraph() != null) {
            SoftwareUtil.collectCallSequenceItems(process.getCallGraph().getGraphEntries(), modes, itemList);
        }
        return itemList;
    }

    private static void collectCallSequenceItems(List<GraphEntryBase> input, List<ModeLiteral> modes, List<CallSequenceItem> itemList) {
        for (GraphEntryBase entry : input) {
            if (entry instanceof ProbabilitySwitch) {
                ProbabilitySwitch propSwitch = (ProbabilitySwitch)entry;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectCallSequenceItems(pse.getItems(), modes, itemList);
                }
                continue;
            }
            if (entry instanceof ModeSwitch) {
                ModeSwitch modeSwitch = (ModeSwitch)entry;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectCallSequenceItems(mse.getItems(), modes, itemList);
                        continue;
                    }
                    if (Collections.disjoint(mse.getValues(), modes)) continue;
                    SoftwareUtil.collectCallSequenceItems(mse.getItems(), modes, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectCallSequenceItems(modeSwitch.getDefaultEntry().getItems(), modes, itemList);
                continue;
            }
            if (!(entry instanceof CallSequence)) continue;
            itemList.addAll((Collection<CallSequenceItem>)((CallSequence)entry).getCalls());
        }
    }

    public static List<RunnableItem> collectRunnableItems(Runnable run) {
        return SoftwareUtil.collectRunnableItems(run, null);
    }

    public static List<RunnableItem> collectRunnableItems(Runnable run, List<ModeLiteral> modes) {
        ArrayList<RunnableItem> itemList = new ArrayList<RunnableItem>();
        SoftwareUtil.collectRunnableItems(run.getRunnableItems(), modes, itemList);
        return itemList;
    }

    private static void collectRunnableItems(List<RunnableItem> input, List<ModeLiteral> modes, List<RunnableItem> itemList) {
        for (RunnableItem item : input) {
            if (item instanceof Group) {
                SoftwareUtil.collectRunnableItems(((Group)item).getItems(), modes, itemList);
                continue;
            }
            if (item instanceof RunnableProbabilitySwitch) {
                RunnableProbabilitySwitch propSwitch = (RunnableProbabilitySwitch)item;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectRunnableItems(pse.getItems(), modes, itemList);
                }
                continue;
            }
            if (item instanceof RunnableModeSwitch) {
                RunnableModeSwitch modeSwitch = (RunnableModeSwitch)item;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectRunnableItems(mse.getItems(), modes, itemList);
                        continue;
                    }
                    if (Collections.disjoint(mse.getValues(), modes)) continue;
                    SoftwareUtil.collectRunnableItems(mse.getItems(), modes, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectRunnableItems(modeSwitch.getDefaultEntry().getItems(), modes, itemList);
                continue;
            }
            itemList.add(item);
        }
    }
}

