/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.Arrays;
import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Distribution;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.WeibullEstimators;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.checks.impl.BasicCheckValidatorImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BasicValidationTests {
    private BasicCheckValidatorImpl classUnderTest;
    private IssueCreator issueCreator;
    private IEObjectHelper eObjectHelper;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.eObjectHelper = (IEObjectHelper)EasyMock.createMock(IEObjectHelper.class);
        this.classUnderTest = new BasicCheckValidatorImpl(this.issueCreator, this.eObjectHelper);
    }

    @Test
    public void testCustomPropertyNoDuplicateKey() {
        AmaltheaFactory factory = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = factory.createAmalthea();
        SWModel swModel = factory.createSWModel();
        amalthea.setSwModel(swModel);
        Label label = factory.createLabel();
        swModel.getLabels().add((Object)label);
        amalthea.getCustomProperties().put((Object)"SW", null);
        swModel.getCustomProperties().put((Object)"SW", null);
        label.getCustomProperties().put((Object)"custom1", null);
        label.getCustomProperties().put((Object)"custom2", null);
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesAndInheritedOf((EObject)amalthea, IAnnotatable.class)).andReturn(Arrays.asList(amalthea, swModel, label));
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkForCustomPropertyDuplicateKey(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testCustomPropertyDuplicateKey() {
        AmaltheaFactory factory = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = factory.createAmalthea();
        SWModel swModel = factory.createSWModel();
        amalthea.setSwModel(swModel);
        Label label = factory.createLabel();
        label.setName("TestLabel");
        swModel.getLabels().add((Object)label);
        amalthea.getCustomProperties().put((Object)"SW", null);
        swModel.getCustomProperties().put((Object)"SW", null);
        label.getCustomProperties().put((Object)"different", null);
        label.getCustomProperties().put((Object)"custom", null);
        EObject prop = factory.create(AmaltheaPackage.eINSTANCE.getCustomProperty());
        prop.eSet(prop.eClass().getEStructuralFeature("key"), (Object)"custom");
        EStructuralFeature propFeature = label.eClass().getEStructuralFeature(0);
        ((EList)label.eGet(propFeature)).add((Object)prop);
        EasyMock.expect((Object)this.eObjectHelper.getName((EObject)label)).andReturn((Object)"TestLabel");
        EasyMock.expect((Object)this.eObjectHelper.getClassName((EObject)label)).andReturn((Object)"Label");
        EasyMock.expect((Object)this.eObjectHelper.getAllInstancesAndInheritedOf((EObject)amalthea, IAnnotatable.class)).andReturn(Arrays.asList(amalthea, swModel, label));
        this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCustomProperty_Key(), new Object[]{"Label", "TestLabel", "custom"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        EasyMock.replay((Object[])new Object[]{this.eObjectHelper});
        this.classUnderTest.checkForCustomPropertyDuplicateKey(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        EasyMock.verify((Object[])new Object[]{this.eObjectHelper});
    }

    @Test
    public void testWeiblullParametersGood() {
        AmaltheaFactory factory = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = factory.createAmalthea();
        SWModel swModel = factory.createSWModel();
        Runnable runnable = factory.createRunnable();
        RunnableInstructions runInst = factory.createRunnableInstructions();
        InstructionsDeviation instDev = factory.createInstructionsDeviation();
        Deviation deviation = factory.createDeviation();
        LongObject lower = factory.createLongObject();
        LongObject upper = factory.createLongObject();
        WeibullEstimators weibullEstimator = factory.createWeibullEstimators();
        LongObject mean = factory.createLongObject();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)runInst);
        runInst.setDefault((Instructions)instDev);
        instDev.setDeviation(deviation);
        deviation.setLowerBound((Object)lower);
        deviation.setUpperBound((Object)upper);
        lower.setValue(72000L);
        upper.setValue(88000L);
        deviation.setDistribution((Distribution)weibullEstimator);
        weibullEstimator.setMean((Object)mean);
        mean.setValue(80000L);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullParameters(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        Runnable run = (Runnable)amalthea.getSwModel().getRunnables().get(0);
        RunnableInstructions instr = (RunnableInstructions)run.getRunnableItems().get(0);
        Deviation dev = ((InstructionsDeviation)instr.getDefault()).getDeviation();
        long meanValue = ((LongObject)((WeibullEstimators)dev.getDistribution()).getMean()).getValue();
        Assert.assertEquals((long)((LongObject)dev.getLowerBound()).getValue(), (long)72000L);
        Assert.assertEquals((long)((LongObject)dev.getUpperBound()).getValue(), (long)88000L);
        Assert.assertEquals((long)meanValue, (long)80000L);
        Assert.assertTrue((((LongObject)dev.getLowerBound()).getValue() < meanValue ? 1 : 0) != 0);
        Assert.assertTrue((meanValue < ((LongObject)dev.getUpperBound()).getValue() ? 1 : 0) != 0);
    }

    @Test
    public void testWeiblullParametersBad() {
        AmaltheaFactory factory = AmaltheaFactory.eINSTANCE;
        Amalthea amalthea = factory.createAmalthea();
        SWModel swModel = factory.createSWModel();
        Runnable runnable = factory.createRunnable();
        RunnableInstructions runInst = factory.createRunnableInstructions();
        InstructionsDeviation instDev = factory.createInstructionsDeviation();
        Deviation deviation = factory.createDeviation();
        LongObject lower = factory.createLongObject();
        LongObject upper = factory.createLongObject();
        WeibullEstimators weibullEstimator = factory.createWeibullEstimators();
        LongObject mean = factory.createLongObject();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)runInst);
        runInst.setDefault((Instructions)instDev);
        instDev.setDeviation(deviation);
        deviation.setLowerBound((Object)lower);
        deviation.setUpperBound((Object)upper);
        lower.setValue(88000L);
        upper.setValue(88000L);
        deviation.setDistribution((Distribution)weibullEstimator);
        weibullEstimator.setMean((Object)mean);
        mean.setValue(88000L);
        this.issueCreator.issue((EObject)deviation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getDeviation_Distribution(), new Object[]{lower.getValue(), upper.getValue()});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkWeibullParameters(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
        Runnable run = (Runnable)amalthea.getSwModel().getRunnables().get(0);
        RunnableInstructions instr = (RunnableInstructions)run.getRunnableItems().get(0);
        Deviation dev = ((InstructionsDeviation)instr.getDefault()).getDeviation();
        long meanValue = ((LongObject)((WeibullEstimators)dev.getDistribution()).getMean()).getValue();
        Assert.assertEquals((long)((LongObject)dev.getLowerBound()).getValue(), (long)88000L);
        Assert.assertEquals((long)((LongObject)dev.getLowerBound()).getValue(), (long)((LongObject)dev.getUpperBound()).getValue());
        Assert.assertEquals((long)((LongObject)dev.getLowerBound()).getValue(), (long)meanValue);
        Assert.assertEquals((long)((LongObject)dev.getUpperBound()).getValue(), (long)meanValue);
    }
}

