/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventChain;
import org.eclipse.app4mc.amalthea.model.EventChainContainer;
import org.eclipse.app4mc.amalthea.model.LabelEvent;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.checks.impl.ConstraintsModelCheckValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class ConstraintsModelTests {
    private ConstraintsModelCheckValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new ConstraintsModelCheckValidatorImpl(this.issueCreator);
    }

    @Test
    public void testEventChainSimpleGood() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = this.createLabelEvent("in");
        LabelEvent mid = this.createLabelEvent("mid");
        LabelEvent out = this.createLabelEvent("out");
        EventChain simpleEC = this.createEventChain("BasicEventChain", (Event)in, (Event)out);
        EventChainContainer subEC1 = this.createContainedSubChain("SubEvent1", (Event)in, (Event)mid);
        EventChainContainer subEC2 = this.createContainedSubChain("SubEvent2", (Event)mid, (Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().add((Object)subEC1);
        simpleEC.getSegments().add((Object)subEC2);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChains(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    public void testEventChainSimple_UnmatchingStimulusEventAtChainStart() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = this.createLabelEvent("in");
        LabelEvent mid = this.createLabelEvent("mid");
        LabelEvent in_false = this.createLabelEvent("in_false");
        LabelEvent out = this.createLabelEvent("out");
        EventChain simpleEC = this.createEventChain("BasicEventChain", (Event)in_false, (Event)out);
        EventChainContainer subEC1 = this.createContainedSubChain("SubEvent1", (Event)in, (Event)mid);
        EventChainContainer subEC2 = this.createContainedSubChain("SubEvent2", (Event)mid, (Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().add((Object)subEC1);
        simpleEC.getSegments().add((Object)subEC2);
        this.issueCreator.issue((EObject)simpleEC, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainReference_EventChain(), new Object[]{"Beginning SubEventChain not found; EventChain's stimulus does not match with SubEventChain's stimulus BasicEventChain"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChains(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimple_UnmatchingResponseEventAtChainEnd() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = this.createLabelEvent("in");
        LabelEvent mid = this.createLabelEvent("mid");
        LabelEvent out_false = this.createLabelEvent("out_false");
        LabelEvent out = this.createLabelEvent("out");
        EventChain simpleEC = this.createEventChain("BasicEventChain", (Event)in, (Event)out_false);
        EventChainContainer subEC1 = this.createContainedSubChain("SubEvent1", (Event)in, (Event)mid);
        EventChainContainer subEC2 = this.createContainedSubChain("SubEvent2", (Event)mid, (Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().add((Object)subEC1);
        simpleEC.getSegments().add((Object)subEC2);
        this.issueCreator.issue((EObject)subEC2.getEventChain(), (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent2'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChains(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimpleBadWrongStimulusInSubEvent() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = this.createLabelEvent("in");
        LabelEvent mid = this.createLabelEvent("mid");
        LabelEvent mid_false = this.createLabelEvent("mid_false");
        LabelEvent out = this.createLabelEvent("out");
        EventChain simpleEC = this.createEventChain("BasicEventChain", (Event)in, (Event)out);
        EventChainContainer subEC1 = this.createContainedSubChain("SubEvent1", (Event)in, (Event)mid);
        EventChainContainer subEC2 = this.createContainedSubChain("SubEvent2", (Event)mid_false, (Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().add((Object)subEC1);
        simpleEC.getSegments().add((Object)subEC2);
        this.issueCreator.issue((EObject)subEC1.getEventChain(), (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent1'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChains(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimpleBadWrongResponseInSubEvent() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = this.createLabelEvent("in");
        LabelEvent mid = this.createLabelEvent("mid");
        LabelEvent mid_false = this.createLabelEvent("mid_false");
        LabelEvent out = this.createLabelEvent("out");
        EventChain simpleEC = this.createEventChain("BasicEventChain", (Event)in, (Event)out);
        EventChainContainer subEC1 = this.createContainedSubChain("SubEvent1", (Event)in, (Event)mid_false);
        EventChainContainer subEC2 = this.createContainedSubChain("SubEvent2", (Event)mid, (Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().add((Object)subEC1);
        simpleEC.getSegments().add((Object)subEC2);
        this.issueCreator.issue((EObject)subEC1.getEventChain(), (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent1'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChains(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimpleBadMissingStimulusInSubEvent() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = this.createLabelEvent("in");
        LabelEvent mid = this.createLabelEvent("mid");
        LabelEvent out = this.createLabelEvent("out");
        EventChain simpleEC = this.createEventChain("BasicEventChain", (Event)in, (Event)out);
        EventChainContainer subEC1 = this.createContainedSubChain("SubEvent1", (Event)in, (Event)mid);
        EventChainContainer subEC2 = this.createContainedSubChain("SubEvent2", null, (Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().add((Object)subEC1);
        simpleEC.getSegments().add((Object)subEC2);
        this.issueCreator.issue((EObject)subEC1.getEventChain(), (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent1'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChains(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void testEventChainSimpleBadMissingResponseInSubEvent() {
        ConstraintsModel constraintsModel = AmaltheaFactory.eINSTANCE.createConstraintsModel();
        LabelEvent in = this.createLabelEvent("in");
        LabelEvent mid = this.createLabelEvent("mid");
        LabelEvent out = this.createLabelEvent("out");
        EventChain simpleEC = this.createEventChain("BasicEventChain", (Event)in, (Event)out);
        EventChainContainer subEC1 = this.createContainedSubChain("SubEvent1", (Event)in, null);
        EventChainContainer subEC2 = this.createContainedSubChain("SubEvent2", (Event)mid, (Event)out);
        constraintsModel.getEventChains().add((Object)simpleEC);
        simpleEC.getSegments().add((Object)subEC1);
        simpleEC.getSegments().add((Object)subEC2);
        this.issueCreator.issue((EObject)subEC1.getEventChain(), (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventChainContainer_EventChain(), new Object[]{"No successor found for EventChain 'SubEvent1'"});
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEventChains(constraintsModel);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    private LabelEvent createLabelEvent(String name) {
        LabelEvent event = AmaltheaFactory.eINSTANCE.createLabelEvent();
        event.setName(name);
        return event;
    }

    private EventChain createEventChain(String name, Event stimulus, Event response) {
        EventChain chain = AmaltheaFactory.eINSTANCE.createEventChain();
        chain.setName(name);
        chain.setStimulus(stimulus);
        chain.setResponse(response);
        return chain;
    }

    private EventChainContainer createContainedSubChain(String name, Event stimulus, Event response) {
        SubEventChain subchain = AmaltheaFactory.eINSTANCE.createSubEventChain();
        subchain.setName(name);
        subchain.setStimulus(stimulus);
        subchain.setResponse(response);
        EventChainContainer container = AmaltheaFactory.eINSTANCE.createEventChainContainer();
        container.setEventChain(subchain);
        return container;
    }
}

