/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwSystem;
import org.eclipse.app4mc.amalthea.model.Prescaler;
import org.eclipse.app4mc.amalthea.model.Quartz;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.HWModelValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class HWModelValidatorTests {
    private HWModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new HWModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkQuartzFrequency_unset() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        hwSystem.getQuartzes().add((Object)quartz);
        this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzFrequency(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzFrequency_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        Frequency frequency = null;
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        quartz.setFrequency(frequency);
        hwSystem.getQuartzes().add((Object)quartz);
        this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzFrequency(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzFrequency_negativeValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        Frequency frequency = AmaltheaFactory.eINSTANCE.createFrequency();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        frequency.setValue(-1000.0);
        frequency.setUnit(FrequencyUnit.MHZ);
        quartz.setFrequency(frequency);
        hwSystem.getQuartzes().add((Object)quartz);
        this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzFrequency(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzFrequency_zeroValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        Frequency frequency = AmaltheaFactory.eINSTANCE.createFrequency();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        hwSystem.getQuartzes().add((Object)quartz);
        frequency.setValue(0.0);
        frequency.setUnit(FrequencyUnit.MHZ);
        quartz.setFrequency(frequency);
        this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzFrequency(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzFrequency_positiveValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        Frequency frequency = AmaltheaFactory.eINSTANCE.createFrequency();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        hwSystem.getQuartzes().add((Object)quartz);
        frequency.setValue(1000.0);
        frequency.setUnit(FrequencyUnit.MHZ);
        quartz.setFrequency(frequency);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzFrequency(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzFrequency_unsetValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        Frequency frequency = AmaltheaFactory.eINSTANCE.createFrequency();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        hwSystem.getQuartzes().add((Object)quartz);
        frequency.setUnit(FrequencyUnit.MHZ);
        this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzFrequency(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzFrequency_undefinedUnit() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        Frequency frequency = AmaltheaFactory.eINSTANCE.createFrequency();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        frequency.setValue(10.0);
        frequency.setUnit(FrequencyUnit._UNDEFINED_);
        quartz.setFrequency(frequency);
        hwSystem.getQuartzes().add((Object)quartz);
        this.issueCreator.issue((EObject)quartz, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getQuartz_Frequency(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzFrequency(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCoreTypeInstructionsPerCycle_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        CoreType coreType = AmaltheaFactory.eINSTANCE.createCoreType();
        amalthea.setHwModel(hwModel);
        hwModel.getCoreTypes().add((Object)coreType);
        coreType.setInstructionsPerCycle(-2.0f);
        this.issueCreator.issue((EObject)coreType, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCoreType_InstructionsPerCycle(), new Object[]{Float.valueOf(-2.0f)});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCoreTypeInstructionsPerCycle(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCoreTypeInstructionsPerCycle_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        CoreType coreType = AmaltheaFactory.eINSTANCE.createCoreType();
        amalthea.setHwModel(hwModel);
        hwModel.getCoreTypes().add((Object)coreType);
        coreType.setInstructionsPerCycle(0.0f);
        this.issueCreator.issue((EObject)coreType, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCoreType_InstructionsPerCycle(), new Object[]{Float.valueOf(0.0f)});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCoreTypeInstructionsPerCycle(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCoreTypeInstructionsPerCycle_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        CoreType coreType = AmaltheaFactory.eINSTANCE.createCoreType();
        amalthea.setHwModel(hwModel);
        hwModel.getCoreTypes().add((Object)coreType);
        coreType.setInstructionsPerCycle(2.0f);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCoreTypeInstructionsPerCycle(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Prescaler prescaler = AmaltheaFactory.eINSTANCE.createPrescaler();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        hwSystem.setPrescaler(prescaler);
        this.issueCreator.issue((EObject)prescaler, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPrescaler_Quartz(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzReferenceOfPrescaler(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        Prescaler prescaler = AmaltheaFactory.eINSTANCE.createPrescaler();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        hwSystem.setPrescaler(prescaler);
        prescaler.setQuartz(quartz);
        this.issueCreator.issue((EObject)prescaler, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPrescaler_Quartz(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzReferenceOfPrescaler(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_Existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        Quartz quartz = AmaltheaFactory.eINSTANCE.createQuartz();
        Prescaler prescaler = AmaltheaFactory.eINSTANCE.createPrescaler();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        hwSystem.getQuartzes().add((Object)quartz);
        hwSystem.setPrescaler(prescaler);
        prescaler.setQuartz(quartz);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkQuartzReferenceOfPrescaler(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

