/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.math.BigInteger;
import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.ClearEvent;
import org.eclipse.app4mc.amalthea.model.Counter;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.DataSizeUnit;
import org.eclipse.app4mc.amalthea.model.EnforcedMigration;
import org.eclipse.app4mc.amalthea.model.EventMask;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.Mode;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.OsEvent;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleActivation;
import org.eclipse.app4mc.amalthea.model.SynchronousServerCall;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.SWModelValidatorImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class SWModelValidatorTests {
    private SWModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new SWModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkLabelSize_unset() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        swModel.getLabels().add((Object)label);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkLabelSize(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkLabelSize_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        DataSize size = null;
        label.setSize(size);
        swModel.getLabels().add((Object)label);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkLabelSize(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkLabelSize_negativeValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        DataSize size = AmaltheaFactory.eINSTANCE.createDataSize();
        BigInteger value = new BigInteger("-10");
        size.setUnit(DataSizeUnit.BIT);
        size.setValue(value);
        label.setSize(size);
        swModel.getLabels().add((Object)label);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractMemoryElement_Size(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkLabelSize(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkLabelSize_zeroValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        DataSize size = AmaltheaFactory.eINSTANCE.createDataSize();
        BigInteger value = new BigInteger("0");
        size.setUnit(DataSizeUnit.BIT);
        size.setValue(value);
        label.setSize(size);
        swModel.getLabels().add((Object)label);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractMemoryElement_Size(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkLabelSize(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkLabelSize_positiveValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        DataSize size = AmaltheaFactory.eINSTANCE.createDataSize();
        BigInteger value = new BigInteger("10");
        size.setUnit(DataSizeUnit.BIT);
        size.setValue(value);
        label.setSize(size);
        swModel.getLabels().add((Object)label);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkLabelSize(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkLabelSize_unsetValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        DataSize size = AmaltheaFactory.eINSTANCE.createDataSize();
        size.setUnit(DataSizeUnit.BIT);
        label.setSize(size);
        swModel.getLabels().add((Object)label);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractMemoryElement_Size(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkLabelSize(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkLabelSize_undefinedUnit() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Label label = AmaltheaFactory.eINSTANCE.createLabel();
        DataSize size = AmaltheaFactory.eINSTANCE.createDataSize();
        BigInteger value = new BigInteger("10");
        size.setUnit(DataSizeUnit._UNDEFINED_);
        size.setValue(value);
        label.setSize(size);
        swModel.getLabels().add((Object)label);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)label, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getAbstractMemoryElement_Size(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkLabelSize(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableReferenceOfTaskRunnableCall_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        TaskRunnableCall runnableCall = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
        callSequence.getCalls().add((Object)runnableCall);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)runnableCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskRunnableCall_Runnable(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableReferenceOfTaskRunnableCall(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableReferenceOfTaskRunnableCall_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        TaskRunnableCall runnableCall = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnableCall.setRunnable(runnable);
        callSequence.getCalls().add((Object)runnableCall);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)runnableCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskRunnableCall_Runnable(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableReferenceOfTaskRunnableCall(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableReferenceOfTaskRunnableCall_existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        TaskRunnableCall runnableCall = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        runnableCall.setRunnable(runnable);
        callSequence.getCalls().add((Object)runnableCall);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getRunnables().add((Object)runnable);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableReferenceOfTaskRunnableCall(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableReferenceOfRunnableCall_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        RunnableCall runnableCall = AmaltheaFactory.eINSTANCE.createRunnableCall();
        runnable.getRunnableCalls().add((Object)runnableCall);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)runnableCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableCall_Runnable(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableReferenceOfRunnableCall(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableReferenceOfRunnableCall_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Runnable runnable2 = AmaltheaFactory.eINSTANCE.createRunnable();
        RunnableCall runnableCall = AmaltheaFactory.eINSTANCE.createRunnableCall();
        runnableCall.setRunnable(runnable2);
        runnable.getRunnableCalls().add((Object)runnableCall);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)runnableCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableCall_Runnable(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableReferenceOfRunnableCall(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableReferenceOfRunnableCall_existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Runnable runnable2 = AmaltheaFactory.eINSTANCE.createRunnable();
        RunnableCall runnableCall = AmaltheaFactory.eINSTANCE.createRunnableCall();
        runnableCall.setRunnable(runnable2);
        runnable.getRunnableCalls().add((Object)runnableCall);
        swModel.getRunnables().add((Object)runnable);
        swModel.getRunnables().add((Object)runnable2);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableReferenceOfRunnableCall(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableReferenceOfRunnableCall_selfReference() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        RunnableCall runnableCall = AmaltheaFactory.eINSTANCE.createRunnableCall();
        runnableCall.setRunnable(runnable);
        runnable.getRunnableCalls().add((Object)runnableCall);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)runnableCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnableCall_Runnable(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableReferenceOfRunnableCall(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkOsEventReferenceOfEventMask_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        SetEvent setEvent = AmaltheaFactory.eINSTANCE.createSetEvent();
        EventMask eventMask = AmaltheaFactory.eINSTANCE.createEventMask();
        setEvent.setEventMask(eventMask);
        callSequence.getCalls().add((Object)setEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)eventMask, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventMask_Events(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkOsEventReferenceOfEventMask(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkOsEventReferenceOfEventMask_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        SetEvent setEvent = AmaltheaFactory.eINSTANCE.createSetEvent();
        OsEvent event = AmaltheaFactory.eINSTANCE.createOsEvent();
        EventMask eventMask = AmaltheaFactory.eINSTANCE.createEventMask();
        eventMask.getEvents().add((Object)event);
        setEvent.setEventMask(eventMask);
        callSequence.getCalls().add((Object)setEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)eventMask, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEventMask_Events(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkOsEventReferenceOfEventMask(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkOsEventReferenceOfEventMask_existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        SetEvent setEvent = AmaltheaFactory.eINSTANCE.createSetEvent();
        OsEvent event = AmaltheaFactory.eINSTANCE.createOsEvent();
        EventMask eventMask = AmaltheaFactory.eINSTANCE.createEventMask();
        eventMask.getEvents().add((Object)event);
        setEvent.setEventMask(eventMask);
        callSequence.getCalls().add((Object)setEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getEvents().add((Object)event);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkOsEventReferenceOfEventMask(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventMaskEvents_invalid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        WaitEvent waitEvent = AmaltheaFactory.eINSTANCE.createWaitEvent();
        OsEvent event = AmaltheaFactory.eINSTANCE.createOsEvent();
        EventMask eventMask = AmaltheaFactory.eINSTANCE.createEventMask();
        eventMask.getEvents().add((Object)event);
        waitEvent.setEventMask(eventMask);
        callSequence.getCalls().add((Object)waitEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getEvents().add((Object)event);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkOsEventReferenceOfEventMask(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEventMaskEvents_valid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        WaitEvent waitEvent = AmaltheaFactory.eINSTANCE.createWaitEvent();
        SetEvent setEvent = AmaltheaFactory.eINSTANCE.createSetEvent();
        OsEvent event = AmaltheaFactory.eINSTANCE.createOsEvent();
        EventMask eventMask = AmaltheaFactory.eINSTANCE.createEventMask();
        eventMask.getEvents().add((Object)event);
        waitEvent.setEventMask(eventMask);
        setEvent.setEventMask(eventMask);
        callSequence.getCalls().add((Object)waitEvent);
        callSequence.getCalls().add((Object)setEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getEvents().add((Object)event);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkOsEventReferenceOfEventMask(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeSwitchValueProvider_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)modeSwitch, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeSwitch_ValueProvider(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeSwitchValueProvider(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeSwitchValueProvider_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        modeSwitch.setValueProvider(modeLabel);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)modeSwitch, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeSwitch_ValueProvider(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeSwitchValueProvider(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeSwitchValueProvider_existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        modeSwitch.setValueProvider(modeLabel);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getModeLabels().add((Object)modeLabel);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeSwitchValueProvider(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeSwitchEntryValue_once() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeSwitchEntry modeSwitchEntry = AmaltheaFactory.eINSTANCE.createModeSwitchEntry();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        mode.getLiterals().add((Object)modeLiteral);
        swModel.getModes().add((Object)mode);
        EList valueList = modeSwitchEntry.getValues();
        valueList.add((Object)modeLiteral);
        modeSwitch.getEntries().add((Object)modeSwitchEntry);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeSwitchEntryValue1(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeSwitchEntryValue_twice() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeSwitchEntry modeSwitchEntry1 = AmaltheaFactory.eINSTANCE.createModeSwitchEntry();
        ModeSwitchEntry modeSwitchEntry2 = AmaltheaFactory.eINSTANCE.createModeSwitchEntry();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        mode.getLiterals().add((Object)modeLiteral);
        swModel.getModes().add((Object)mode);
        EList valueList1 = modeSwitchEntry1.getValues();
        valueList1.add((Object)modeLiteral);
        modeSwitch.getEntries().add((Object)modeSwitchEntry1);
        EList valueList2 = modeSwitchEntry2.getValues();
        valueList2.add((Object)modeLiteral);
        modeSwitch.getEntries().add((Object)modeSwitchEntry2);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)modeSwitchEntry1, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeSwitchEntry_Values(), new Object[0]);
        this.issueCreator.issue((EObject)modeSwitchEntry2, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeSwitchEntry_Values(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeSwitchEntryValue1(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeValueProviderValue_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeSwitchEntry modeSwitchEntry = AmaltheaFactory.eINSTANCE.createModeSwitchEntry();
        modeSwitch.getEntries().add((Object)modeSwitchEntry);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)modeSwitchEntry, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeSwitchEntry_Values(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeSwitchEntryValue2(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    public void test_checkModeValueProviderValue_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeSwitchEntry modeSwitchEntry = AmaltheaFactory.eINSTANCE.createModeSwitchEntry();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        EList valueList = modeSwitchEntry.getValues();
        valueList.add((Object)modeLiteral);
        modeSwitch.setValueProvider(modeLabel);
        modeSwitch.getEntries().add((Object)modeSwitchEntry);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)modeSwitchEntry, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeSwitchEntry_Values(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeSwitchEntryValue2(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeValueProviderMode_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        modeSwitch.setValueProvider(modeLabel);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)modeLabel, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabel_Mode(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelMode(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeValueProviderMode_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        modeSwitch.setValueProvider(modeLabel);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)modeLabel, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabel_Mode(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelMode(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    public void test_checkModeLabelMode_existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        modeSwitch.setValueProvider(modeLabel);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        swModel.getModes().add((Object)mode);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelMode(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    public void test_checkModeLabelInitialValue_invalid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        modeLabel.setInitialValue(modeLiteral);
        modeSwitch.setValueProvider(modeLabel);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        swModel.getModes().add((Object)mode);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)modeLabel, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabel_InitialValue(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelInitialValue(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLabelInitialValue_valid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        ModeSwitch modeSwitch = AmaltheaFactory.eINSTANCE.createModeSwitch();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        modeLabel.setInitialValue(modeLiteral);
        mode.getLiterals().add((Object)modeLiteral);
        modeSwitch.setValueProvider(modeLabel);
        callGraph.getGraphEntries().add((Object)modeSwitch);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        swModel.getModes().add((Object)mode);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelInitialValue(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCounterOffset_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        ClearEvent clearEvent = AmaltheaFactory.eINSTANCE.createClearEvent();
        Counter counter = AmaltheaFactory.eINSTANCE.createCounter();
        clearEvent.setCounter(counter);
        callSequence.getCalls().add((Object)clearEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)counter, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCounter_Offset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCounterOffset(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCounterOffset_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        ClearEvent clearEvent = AmaltheaFactory.eINSTANCE.createClearEvent();
        Counter counter = AmaltheaFactory.eINSTANCE.createCounter();
        counter.setOffset(-1L);
        clearEvent.setCounter(counter);
        callSequence.getCalls().add((Object)clearEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)counter, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCounter_Offset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCounterOffset(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCounterOffset_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        ClearEvent clearEvent = AmaltheaFactory.eINSTANCE.createClearEvent();
        Counter counter = AmaltheaFactory.eINSTANCE.createCounter();
        counter.setOffset(0L);
        clearEvent.setCounter(counter);
        callSequence.getCalls().add((Object)clearEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)counter, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getCounter_Offset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCounterOffset(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCounterOffset_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        ClearEvent clearEvent = AmaltheaFactory.eINSTANCE.createClearEvent();
        Counter counter = AmaltheaFactory.eINSTANCE.createCounter();
        counter.setOffset(1L);
        clearEvent.setCounter(counter);
        callSequence.getCalls().add((Object)clearEvent);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCounterOffset(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCounterOffset_Null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        SynchronousServerCall serverCall = AmaltheaFactory.eINSTANCE.createSynchronousServerCall();
        runnable.getRunnableItems().add((Object)serverCall);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)serverCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getServerCall_ServerRunnable(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkServerCallServerRunnable(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCounterOffset_NotExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        SynchronousServerCall serverCall = AmaltheaFactory.eINSTANCE.createSynchronousServerCall();
        Runnable serverRunnable = AmaltheaFactory.eINSTANCE.createRunnable();
        serverCall.setServerRunnable(serverRunnable);
        runnable.getRunnableItems().add((Object)serverCall);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)serverCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getServerCall_ServerRunnable(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkServerCallServerRunnable(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCounterOffset_SelfReference() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        SynchronousServerCall serverCall = AmaltheaFactory.eINSTANCE.createSynchronousServerCall();
        serverCall.setServerRunnable(runnable);
        runnable.getRunnableItems().add((Object)serverCall);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)serverCall, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getServerCall_ServerRunnable(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkServerCallServerRunnable(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCounterOffset_Existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        SynchronousServerCall serverCall = AmaltheaFactory.eINSTANCE.createSynchronousServerCall();
        Runnable serverRunnable = AmaltheaFactory.eINSTANCE.createRunnable();
        serverCall.setServerRunnable(serverRunnable);
        runnable.getRunnableItems().add((Object)serverCall);
        swModel.getRunnables().add((Object)runnable);
        swModel.getRunnables().add((Object)serverRunnable);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkServerCallServerRunnable(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEnforcedMigrationResourceOwner_Null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        EnforcedMigration enforcedMigration = AmaltheaFactory.eINSTANCE.createEnforcedMigration();
        enforcedMigration.setResourceOwner(null);
        callSequence.getCalls().add((Object)enforcedMigration);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)enforcedMigration, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEnforcedMigration_ResourceOwner(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEnforcedMigrationResourceOwner(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEnforcedMigrationResourceOwner_Unset() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        EnforcedMigration enforcedMigration = AmaltheaFactory.eINSTANCE.createEnforcedMigration();
        callSequence.getCalls().add((Object)enforcedMigration);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)enforcedMigration, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEnforcedMigration_ResourceOwner(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEnforcedMigrationResourceOwner(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEnforcedMigrationResourceOwner_Invalid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        EnforcedMigration enforcedMigration = AmaltheaFactory.eINSTANCE.createEnforcedMigration();
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        enforcedMigration.setResourceOwner((Scheduler)taskScheduler);
        callSequence.getCalls().add((Object)enforcedMigration);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        this.issueCreator.issue((EObject)enforcedMigration, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getEnforcedMigration_ResourceOwner(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEnforcedMigrationResourceOwner(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkEnforcedMigrationResourceOwner_Valid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        OperatingSystem os = AmaltheaFactory.eINSTANCE.createOperatingSystem();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Task task = AmaltheaFactory.eINSTANCE.createTask();
        CallGraph callGraph = AmaltheaFactory.eINSTANCE.createCallGraph();
        CallSequence callSequence = AmaltheaFactory.eINSTANCE.createCallSequence();
        EnforcedMigration enforcedMigration = AmaltheaFactory.eINSTANCE.createEnforcedMigration();
        TaskScheduler taskScheduler = AmaltheaFactory.eINSTANCE.createTaskScheduler();
        os.getTaskSchedulers().add((Object)taskScheduler);
        osModel.getOperatingSystems().add((Object)os);
        amalthea.setOsModel(osModel);
        enforcedMigration.setResourceOwner((Scheduler)taskScheduler);
        callSequence.getCalls().add((Object)enforcedMigration);
        callGraph.getGraphEntries().add((Object)callSequence);
        task.setCallGraph(callGraph);
        swModel.getTasks().add((Object)task);
        amalthea.setSwModel(swModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkEnforcedMigrationResourceOwner(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableDeadlineUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Time deadline = null;
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.setDeadline(deadline);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableDeadlineUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableDeadlineUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Time deadline = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.setDeadline(deadline);
        deadline.setValue(value);
        deadline.setUnit(unit);
        this.issueCreator.issue((EObject)deadline, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getRunnable_Deadline(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableDeadlineUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableDeadlineUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Time deadline = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.setDeadline(deadline);
        deadline.setValue(value);
        deadline.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableDeadlineUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkRunnableDeadlineUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Time deadline = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.setDeadline(deadline);
        deadline.setValue(value);
        deadline.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableDeadlineUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationMinUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time min = null;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setMin(min);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationMinUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationMinUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time min = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setMin(min);
        min.setValue(value);
        min.setUnit(unit);
        this.issueCreator.issue((EObject)min, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicActivation_Min(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationMinUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationMinUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time min = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setMin(min);
        min.setValue(value);
        min.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkRunnableDeadlineUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationMinUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time min = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setMin(min);
        min.setValue(value);
        min.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationMinUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationMaxUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time max = null;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setMax(max);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationMaxUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationMaxUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time max = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setMax(max);
        max.setValue(value);
        max.setUnit(unit);
        this.issueCreator.issue((EObject)max, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicActivation_Max(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationMaxUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationMaxUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time max = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setMax(max);
        max.setValue(value);
        max.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationMaxUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationMaxUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time max = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setMax(max);
        max.setValue(value);
        max.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationMaxUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationOffsetUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time offset = null;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setOffset(offset);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationOffsetUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicActivation_Offset(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationOffsetUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicActivationOffsetUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        PeriodicActivation periodicActivation = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)periodicActivation);
        periodicActivation.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicActivationOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationMinUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        SingleActivation singleActivation = AmaltheaFactory.eINSTANCE.createSingleActivation();
        Time min = null;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)singleActivation);
        singleActivation.setMin(min);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationMinUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationMinUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        SingleActivation singleActivation = AmaltheaFactory.eINSTANCE.createSingleActivation();
        Time min = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)singleActivation);
        singleActivation.setMin(min);
        min.setValue(value);
        min.setUnit(unit);
        this.issueCreator.issue((EObject)min, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSingleActivation_Min(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationMinUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationMinUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        SingleActivation singleActivation = AmaltheaFactory.eINSTANCE.createSingleActivation();
        Time min = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)singleActivation);
        singleActivation.setMin(min);
        min.setValue(value);
        min.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationMinUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationMinUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        SingleActivation singleActivation = AmaltheaFactory.eINSTANCE.createSingleActivation();
        Time min = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)singleActivation);
        singleActivation.setMin(min);
        min.setValue(value);
        min.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationMinUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationMaxUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        SingleActivation singleActivation = AmaltheaFactory.eINSTANCE.createSingleActivation();
        Time max = null;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)singleActivation);
        singleActivation.setMax(max);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationMaxUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationMaxUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        SingleActivation singleActivation = AmaltheaFactory.eINSTANCE.createSingleActivation();
        Time max = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)singleActivation);
        singleActivation.setMax(max);
        max.setValue(value);
        max.setUnit(unit);
        this.issueCreator.issue((EObject)max, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSingleActivation_Max(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationMaxUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationMaxUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        SingleActivation singleActivation = AmaltheaFactory.eINSTANCE.createSingleActivation();
        Time max = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)singleActivation);
        singleActivation.setMax(max);
        max.setValue(value);
        max.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationMaxUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationMaxUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        SingleActivation singleActivation = AmaltheaFactory.eINSTANCE.createSingleActivation();
        Time max = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setSwModel(swModel);
        swModel.getActivations().add((Object)singleActivation);
        singleActivation.setMax(max);
        max.setValue(value);
        max.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationMaxUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLabelAccessModeEqual_ValueNull() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        ModeLabelAccess modeLabelAccess = AmaltheaFactory.eINSTANCE.createModeLabelAccess();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)modeLabelAccess);
        modeLabelAccess.setData(modeLabel);
        modeLabelAccess.setModeValue(null);
        modeLabel.setInitialValue(modeLiteral);
        mode.getLiterals().add((Object)modeLiteral);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelAccessModeEqual(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLabelAccessModeEqual_DataNull() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        ModeLabelAccess modeLabelAccess = AmaltheaFactory.eINSTANCE.createModeLabelAccess();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)modeLabelAccess);
        modeLabelAccess.setData(null);
        mode.getLiterals().add((Object)modeLiteral);
        modeLabelAccess.setModeValue(modeLiteral);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelAccessModeEqual(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLabelAccessModeEqual_DataModeNull() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        ModeLabelAccess modeLabelAccess = AmaltheaFactory.eINSTANCE.createModeLabelAccess();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)modeLabelAccess);
        modeLabelAccess.setAccess(LabelAccessEnum.READ);
        modeLabelAccess.setData(modeLabel);
        mode.getLiterals().add((Object)modeLiteral);
        modeLabelAccess.setModeValue(modeLiteral);
        this.issueCreator.issue((EObject)modeLabelAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabelAccess_Data(), new Object[]{null, mode});
        this.issueCreator.issue((EObject)modeLabelAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabelAccess_ModeValue(), new Object[]{null, mode});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelAccessModeEqual(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLabelAccessModeEqual_ValueModeNull() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        ModeLabelAccess modeLabelAccess = AmaltheaFactory.eINSTANCE.createModeLabelAccess();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral1 = AmaltheaFactory.eINSTANCE.createModeLiteral();
        ModeLiteral modeLiteral2 = AmaltheaFactory.eINSTANCE.createModeLiteral();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)modeLabelAccess);
        modeLabelAccess.setAccess(LabelAccessEnum.READ);
        modeLabelAccess.setData(modeLabel);
        modeLabel.setInitialValue(modeLiteral1);
        mode.getLiterals().add((Object)modeLiteral1);
        modeLabelAccess.setModeValue(modeLiteral2);
        this.issueCreator.issue((EObject)modeLabelAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabelAccess_Data(), new Object[]{mode, null});
        this.issueCreator.issue((EObject)modeLabelAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabelAccess_ModeValue(), new Object[]{mode, null});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelAccessModeEqual(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLabelAccessModeEqual_ModeUnequal() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        ModeLabelAccess modeLabelAccess = AmaltheaFactory.eINSTANCE.createModeLabelAccess();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        Mode mode1 = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral1 = AmaltheaFactory.eINSTANCE.createModeLiteral();
        Mode mode2 = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral2 = AmaltheaFactory.eINSTANCE.createModeLiteral();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)modeLabelAccess);
        modeLabelAccess.setAccess(LabelAccessEnum.READ);
        modeLabelAccess.setData(modeLabel);
        mode1.getLiterals().add((Object)modeLiteral1);
        modeLabel.setInitialValue(modeLiteral1);
        mode2.getLiterals().add((Object)modeLiteral2);
        modeLabelAccess.setModeValue(modeLiteral2);
        this.issueCreator.issue((EObject)modeLabelAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabelAccess_Data(), new Object[]{mode1, mode2});
        this.issueCreator.issue((EObject)modeLabelAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeLabelAccess_ModeValue(), new Object[]{mode1, mode2});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelAccessModeEqual(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLabelAccessModeEqual_ModeEqual() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        ModeLabelAccess modeLabelAccess = AmaltheaFactory.eINSTANCE.createModeLabelAccess();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral1 = AmaltheaFactory.eINSTANCE.createModeLiteral();
        ModeLiteral modeLiteral2 = AmaltheaFactory.eINSTANCE.createModeLiteral();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)modeLabelAccess);
        modeLabelAccess.setAccess(LabelAccessEnum.READ);
        modeLabelAccess.setData(modeLabel);
        mode.getLiterals().add((Object)modeLiteral1);
        modeLabel.setInitialValue(modeLiteral1);
        mode.getLiterals().add((Object)modeLiteral2);
        modeLabelAccess.setModeValue(modeLiteral2);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLabelAccessModeEqual(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLiteralMode_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        ModeLabelAccess modeLabelAccess = AmaltheaFactory.eINSTANCE.createModeLabelAccess();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)modeLabelAccess);
        modeLabelAccess.setModeValue(modeLiteral);
        this.issueCreator.issue((EObject)modeLiteral, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getMode_Literals(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLiteralMode(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkModeLiteralMode_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        ModeLabelAccess modeLabelAccess = AmaltheaFactory.eINSTANCE.createModeLabelAccess();
        Mode mode = AmaltheaFactory.eINSTANCE.createMode();
        ModeLiteral modeLiteral = AmaltheaFactory.eINSTANCE.createModeLiteral();
        amalthea.setSwModel(swModel);
        swModel.getRunnables().add((Object)runnable);
        runnable.getRunnableItems().add((Object)modeLabelAccess);
        modeLabelAccess.setAccess(LabelAccessEnum.READ);
        modeLabelAccess.setModeValue(modeLiteral);
        mode.getLiterals().add((Object)modeLiteral);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeLiteralMode(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

