/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.math.BigInteger;
import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveStimulus;
import org.eclipse.app4mc.amalthea.model.Clock;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierList;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry;
import org.eclipse.app4mc.amalthea.model.ClockSinusFunction;
import org.eclipse.app4mc.amalthea.model.ClockTriangleFunction;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.ModeValueList;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.SyntheticStimulus;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TimestampList;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.StimuliModelValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class StimuliModelValidatorTests {
    private StimuliModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new StimuliModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkPeriodicRecurrence_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(value);
        recurrence.setUnit(unit);
        this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Recurrence(), new Object[]{value, unit});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrence(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicRecurrence_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(value);
        recurrence.setUnit(unit);
        this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Recurrence(), new Object[]{value, unit});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrence(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicRecurrence_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(value);
        recurrence.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrence(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Clock(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockReferenceOfPeriodic(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setClock((Clock)clock);
        this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Clock(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockReferenceOfPeriodic(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkQuartzReferenceOfPrescaler_Existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clock);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setClock((Clock)clock);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockReferenceOfPeriodic(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_minNegative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMin(-1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_minPositive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMin(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_maxNegative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMax(-1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_maxPositive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMax(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_minMaxIncorrect() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMin(2.0);
        clock.setMax(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionConstraint_minMaxCorrect() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clock = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        clock.setMin(1.0);
        clock.setMax(2.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_amplitudeNegative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setAmplitude(-1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_amplitudePositive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setAmplitude(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_yOffsetNegative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setYOffset(-1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_yOffsetPositive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setYOffset(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_amplitudeYOffsetIncorrect() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setAmplitude(2.0);
        clock.setYOffset(1.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionConstraint_amplitudeYOffsetCorrect() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clock = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        clock.setAmplitude(1.0);
        clock.setYOffset(2.0);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunction(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListConstraint_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clock = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry entry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        clock.getEntries().add((Object)entry);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierList(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListConstraint_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clock = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry entry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        entry.setMultiplier(-1.0);
        clock.getEntries().add((Object)entry);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Multiplier(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierList(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListConstraint_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clock = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry entry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        entry.setMultiplier(1.0);
        clock.getEntries().add((Object)entry);
        stimuliModel.getClocks().add((Object)clock);
        amalthea.setStimuliModel(stimuliModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierList(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicOffsetUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time offset = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setOffset(offset);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicOffsetUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Offset(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicOffsetUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicOffsetUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicRecurrenceUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time recurrence = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrenceUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicRecurrenceUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(value);
        recurrence.setUnit(unit);
        this.issueCreator.issue((EObject)recurrence, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Recurrence(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrenceUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicRecurrenceUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(value);
        recurrence.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrenceUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkPeriodicRecurrenceUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        PeriodicStimulus periodic = AmaltheaFactory.eINSTANCE.createPeriodicStimulus();
        Time recurrence = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)periodic);
        periodic.setRecurrence(recurrence);
        recurrence.setValue(value);
        recurrence.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkPeriodicRecurrenceUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSyntheticOffsetUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        Time offset = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setOffset(offset);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSyntheticOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSyntheticOffsetUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSyntheticStimulus_Offset(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSyntheticOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSyntheticOffsetUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSyntheticOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSyntheticOffsetUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        Time offset = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setOffset(offset);
        offset.setValue(value);
        offset.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSyntheticOffsetUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSyntheticPeriodUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        Time period = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setPeriod(period);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSyntheticPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSyntheticPeriodUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSyntheticStimulus_Period(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSyntheticPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSyntheticPeriodUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSyntheticPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSyntheticPeriodUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSyntheticPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkTimestampListTimestampsUnsigned_empty() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        TimestampList timestampList = AmaltheaFactory.eINSTANCE.createTimestampList();
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setTriggerTimes(timestampList);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkTimestampListTimestampsUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkTimestampListTimestampsUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        TimestampList timestampList = AmaltheaFactory.eINSTANCE.createTimestampList();
        Time timestamp = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setTriggerTimes(timestampList);
        timestampList.getTimestamps().add((Object)timestamp);
        timestamp.setValue(value);
        timestamp.setUnit(unit);
        this.issueCreator.issue((EObject)timestamp, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimestampList_Timestamps(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkTimestampListTimestampsUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkTimestampListTimestampsUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        TimestampList timestampList = AmaltheaFactory.eINSTANCE.createTimestampList();
        Time timestamp = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setTriggerTimes(timestampList);
        timestampList.getTimestamps().add((Object)timestamp);
        timestamp.setValue(value);
        timestamp.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkTimestampListTimestampsUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkTimestampListTimestampsUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SyntheticStimulus synthetic = AmaltheaFactory.eINSTANCE.createSyntheticStimulus();
        TimestampList timestampList = AmaltheaFactory.eINSTANCE.createTimestampList();
        Time timestamp = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)synthetic);
        synthetic.setTriggerTimes(timestampList);
        timestampList.getTimestamps().add((Object)timestamp);
        timestamp.setValue(value);
        timestamp.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkTimestampListTimestampsUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SingleStimulus single = AmaltheaFactory.eINSTANCE.createSingleStimulus();
        Time activation = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)single);
        single.setActivation(activation);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SingleStimulus single = AmaltheaFactory.eINSTANCE.createSingleStimulus();
        Time activation = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)single);
        single.setActivation(activation);
        activation.setValue(value);
        activation.setUnit(unit);
        this.issueCreator.issue((EObject)activation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSingleStimulus_Activation(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SingleStimulus single = AmaltheaFactory.eINSTANCE.createSingleStimulus();
        Time activation = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)single);
        single.setActivation(activation);
        activation.setValue(value);
        activation.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSingleActivationUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SingleStimulus single = AmaltheaFactory.eINSTANCE.createSingleStimulus();
        Time activation = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)single);
        single.setActivation(activation);
        activation.setValue(value);
        activation.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSingleActivationUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkArrivalCurveEntryLowerUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ArrivalCurveStimulus arrivalCurve = AmaltheaFactory.eINSTANCE.createArrivalCurveStimulus();
        ArrivalCurveEntry entry = AmaltheaFactory.eINSTANCE.createArrivalCurveEntry();
        Time lower = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)arrivalCurve);
        arrivalCurve.getEntries().add((Object)entry);
        entry.setLowerTimeBorder(lower);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkArrivalCurveEntryLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkArrivalCurveEntryLowerUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ArrivalCurveStimulus arrivalCurve = AmaltheaFactory.eINSTANCE.createArrivalCurveStimulus();
        ArrivalCurveEntry entry = AmaltheaFactory.eINSTANCE.createArrivalCurveEntry();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)arrivalCurve);
        arrivalCurve.getEntries().add((Object)entry);
        entry.setLowerTimeBorder(lower);
        lower.setValue(value);
        lower.setUnit(unit);
        this.issueCreator.issue((EObject)lower, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getArrivalCurveEntry_LowerTimeBorder(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkArrivalCurveEntryLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkArrivalCurveEntryLowerUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ArrivalCurveStimulus arrivalCurve = AmaltheaFactory.eINSTANCE.createArrivalCurveStimulus();
        ArrivalCurveEntry entry = AmaltheaFactory.eINSTANCE.createArrivalCurveEntry();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)arrivalCurve);
        arrivalCurve.getEntries().add((Object)entry);
        entry.setLowerTimeBorder(lower);
        lower.setValue(value);
        lower.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkArrivalCurveEntryLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkArrivalCurveEntryLowerUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ArrivalCurveStimulus arrivalCurve = AmaltheaFactory.eINSTANCE.createArrivalCurveStimulus();
        ArrivalCurveEntry entry = AmaltheaFactory.eINSTANCE.createArrivalCurveEntry();
        Time lower = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)arrivalCurve);
        arrivalCurve.getEntries().add((Object)entry);
        entry.setLowerTimeBorder(lower);
        lower.setValue(value);
        lower.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkArrivalCurveEntryLowerUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkArrivalCurveEntryUpperUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ArrivalCurveStimulus arrivalCurve = AmaltheaFactory.eINSTANCE.createArrivalCurveStimulus();
        ArrivalCurveEntry entry = AmaltheaFactory.eINSTANCE.createArrivalCurveEntry();
        Time upper = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)arrivalCurve);
        arrivalCurve.getEntries().add((Object)entry);
        entry.setUpperTimeBorder(upper);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkArrivalCurveEntryUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkArrivalCurveEntryUpperUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ArrivalCurveStimulus arrivalCurve = AmaltheaFactory.eINSTANCE.createArrivalCurveStimulus();
        ArrivalCurveEntry entry = AmaltheaFactory.eINSTANCE.createArrivalCurveEntry();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)arrivalCurve);
        arrivalCurve.getEntries().add((Object)entry);
        entry.setUpperTimeBorder(upper);
        upper.setValue(value);
        upper.setUnit(unit);
        this.issueCreator.issue((EObject)upper, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getArrivalCurveEntry_UpperTimeBorder(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkArrivalCurveEntryUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkArrivalCurveEntryUpperUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ArrivalCurveStimulus arrivalCurve = AmaltheaFactory.eINSTANCE.createArrivalCurveStimulus();
        ArrivalCurveEntry entry = AmaltheaFactory.eINSTANCE.createArrivalCurveEntry();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)arrivalCurve);
        arrivalCurve.getEntries().add((Object)entry);
        entry.setUpperTimeBorder(upper);
        upper.setValue(value);
        upper.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkArrivalCurveEntryUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkArrivalCurveEntryUpperUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ArrivalCurveStimulus arrivalCurve = AmaltheaFactory.eINSTANCE.createArrivalCurveStimulus();
        ArrivalCurveEntry entry = AmaltheaFactory.eINSTANCE.createArrivalCurveEntry();
        Time upper = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)arrivalCurve);
        arrivalCurve.getEntries().add((Object)entry);
        entry.setUpperTimeBorder(upper);
        upper.setValue(value);
        upper.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkArrivalCurveEntryUpperUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionPeriodUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clockTriangleFunction = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        Time period = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockTriangleFunction);
        clockTriangleFunction.setPeriod(period);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunctionPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionPeriodUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clockTriangleFunction = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockTriangleFunction);
        clockTriangleFunction.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Period(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunctionPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionPeriodUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clockTriangleFunction = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockTriangleFunction);
        clockTriangleFunction.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunctionPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockTriangleFunctionPeriodUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockTriangleFunction clockTriangleFunction = AmaltheaFactory.eINSTANCE.createClockTriangleFunction();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockTriangleFunction);
        clockTriangleFunction.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockTriangleFunctionPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionPeriodUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clockSinusFunction = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        Time period = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockSinusFunction);
        clockSinusFunction.setPeriod(period);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunctionPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionPeriodUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clockSinusFunction = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockSinusFunction);
        clockSinusFunction.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Period(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunctionPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionPeriodUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clockSinusFunction = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockSinusFunction);
        clockSinusFunction.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunctionPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockSinusFunctionPeriodUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockSinusFunction clockSinusFunction = AmaltheaFactory.eINSTANCE.createClockSinusFunction();
        Time period = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockSinusFunction);
        clockSinusFunction.setPeriod(period);
        period.setValue(value);
        period.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockSinusFunctionPeriodUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListEntryTimeUnsigned_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clockMultiplierList = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry clockMultiplierListEntry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        Time time = null;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockMultiplierList);
        clockMultiplierList.getEntries().add((Object)clockMultiplierListEntry);
        clockMultiplierListEntry.setTime(time);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierListEntryTimeUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListEntryTimeUnsigned_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clockMultiplierList = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry clockMultiplierListEntry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.valueOf(-10L);
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockMultiplierList);
        clockMultiplierList.getEntries().add((Object)clockMultiplierListEntry);
        clockMultiplierListEntry.setTime(time);
        time.setValue(value);
        time.setUnit(unit);
        this.issueCreator.issue((EObject)time, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Time(), new Object[]{value});
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierListEntryTimeUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListEntryTimeUnsigned_zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clockMultiplierList = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry clockMultiplierListEntry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.ZERO;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockMultiplierList);
        clockMultiplierList.getEntries().add((Object)clockMultiplierListEntry);
        clockMultiplierListEntry.setTime(time);
        time.setValue(value);
        time.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierListEntryTimeUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkClockMultiplierListEntryTimeUnsigned_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        ClockMultiplierList clockMultiplierList = AmaltheaFactory.eINSTANCE.createClockMultiplierList();
        ClockMultiplierListEntry clockMultiplierListEntry = AmaltheaFactory.eINSTANCE.createClockMultiplierListEntry();
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        BigInteger value = BigInteger.TEN;
        TimeUnit unit = TimeUnit.MS;
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getClocks().add((Object)clockMultiplierList);
        clockMultiplierList.getEntries().add((Object)clockMultiplierListEntry);
        clockMultiplierListEntry.setTime(time);
        time.setValue(value);
        time.setUnit(unit);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkClockMultiplierListEntryTimeUnsigned(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_ModeValueListEntryModeLabelConstraint_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SingleStimulus single = AmaltheaFactory.eINSTANCE.createSingleStimulus();
        ModeValueList modeValueList = AmaltheaFactory.eINSTANCE.createModeValueList();
        ModeValue modeValue = AmaltheaFactory.eINSTANCE.createModeValue();
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)single);
        single.setSetModeValueList(modeValueList);
        modeValueList.getEntries().add((Object)modeValue);
        this.issueCreator.issue((EObject)modeValue, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeValue_ValueProvider(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeValueListEntryModeLabelConstraint(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_ModeValueListEntryModeLabelConstraint_positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        SingleStimulus single = AmaltheaFactory.eINSTANCE.createSingleStimulus();
        ModeValueList modeValueList = AmaltheaFactory.eINSTANCE.createModeValueList();
        ModeValue modeValue = AmaltheaFactory.eINSTANCE.createModeValue();
        amalthea.setSwModel(swModel);
        swModel.getModeLabels().add((Object)modeLabel);
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)single);
        single.setSetModeValueList(modeValueList);
        modeValueList.getEntries().add((Object)modeValue);
        modeValue.setValueProvider(modeLabel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeValueListEntryModeLabelConstraint(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_ModeValueListEntryModeLabelConstraint_negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        StimuliModel stimuliModel = AmaltheaFactory.eINSTANCE.createStimuliModel();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        ModeLabel modeLabel = AmaltheaFactory.eINSTANCE.createModeLabel();
        SingleStimulus single = AmaltheaFactory.eINSTANCE.createSingleStimulus();
        ModeValueList modeValueList = AmaltheaFactory.eINSTANCE.createModeValueList();
        ModeValue modeValue = AmaltheaFactory.eINSTANCE.createModeValue();
        amalthea.setSwModel(swModel);
        amalthea.setStimuliModel(stimuliModel);
        stimuliModel.getStimuli().add((Object)single);
        single.setSetModeValueList(modeValueList);
        modeValueList.getEntries().add((Object)modeValue);
        modeValue.setValueProvider(modeLabel);
        this.issueCreator.issue((EObject)modeValue, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeValue_ValueProvider(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkModeValueListEntryModeLabelConstraint(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

