/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.checks.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Algorithm;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.Grouping;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class MappingModelCheckValidatorImpl
extends AbstractValidatorImpl {
    public MappingModelCheckValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public MappingModelCheckValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkProcessToSchedulerToCoreMapping(MappingModel mappingModel) {
        ArrayList<ISR> allIsrs = new ArrayList<ISR>(this.getObjectHelper().getAllInstancesOf((EObject)mappingModel, ISR.class));
        ArrayList<Task> allTasks = new ArrayList<Task>(this.getObjectHelper().getAllInstancesOf((EObject)mappingModel, Task.class));
        ArrayList<ISRAllocation> allIsrAllocs = new ArrayList<ISRAllocation>(this.getObjectHelper().getAllInstancesOf((EObject)mappingModel, ISRAllocation.class));
        ArrayList<TaskAllocation> allTaskAllocs = new ArrayList<TaskAllocation>(this.getObjectHelper().getAllInstancesOf((EObject)mappingModel, TaskAllocation.class));
        ArrayList<Scheduler> allSchedulers = new ArrayList<Scheduler>(this.getObjectHelper().getAllInstancesAndInheritedOf((EObject)mappingModel, Scheduler.class));
        ArrayList<SchedulerAllocation> allCoreAllocs = new ArrayList<SchedulerAllocation>(this.getObjectHelper().getAllInstancesAndInheritedOf((EObject)mappingModel, SchedulerAllocation.class));
        this.checkTaskToSchedulerMappings(allTaskAllocs, allTasks);
        this.checkIsrToSchedulerMappings(allIsrAllocs, allIsrs);
        this.checkSchedulerToCoreMapping(allSchedulers, allCoreAllocs);
    }

    private void checkTaskToSchedulerMappings(List<TaskAllocation> taskAllocs, List<Task> tasks) {
        for (TaskAllocation taskAlloc : taskAllocs) {
            Task task = taskAlloc.getTask();
            TaskScheduler sched = taskAlloc.getScheduler();
            if (task == null && sched == null) {
                this.issueCreator.issue((EObject)taskAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskAllocation_Task(), new Object[]{"Task2Scheduler Mapping-Error: Task Allocation is left blank", taskAlloc});
                continue;
            }
            if (task != null && sched == null) {
                this.issueCreator.issue((EObject)taskAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskAllocation_Task(), new Object[]{"Task2Scheduler Mapping-Error: Task \"" + task.getName() + "\" is not mapped to any Scheduler", taskAlloc});
                continue;
            }
            if (sched != null && task == null) {
                this.issueCreator.issue((EObject)taskAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTaskAllocation_Scheduler(), new Object[]{"Task2Scheduler Mapping-Error: Scheduler \"" + sched.getName() + "\" is not mapped to any Task", taskAlloc});
                continue;
            }
            tasks.remove(task);
        }
        for (Task leftTask : tasks) {
            this.issueCreator.issue((EObject)leftTask, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTypeRef_TypeDef(), new Object[]{"Task2Scheduler Mapping-Error: Unmapped Task found: " + leftTask.getName(), leftTask});
        }
    }

    private void checkIsrToSchedulerMappings(List<ISRAllocation> isrAllocs, List<ISR> isrs) {
        for (ISRAllocation isrAlloc : isrAllocs) {
            ISR isr = isrAlloc.getIsr();
            InterruptController sched = isrAlloc.getController();
            if (isr == null && sched == null) {
                this.issueCreator.issue((EObject)isrAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getISRAllocation_Isr(), new Object[]{"Isr2Scheduler Mapping-Error: Interrupt Allocation is left blank", isrAlloc});
                continue;
            }
            if (isr != null && sched == null) {
                this.issueCreator.issue((EObject)isrAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getISRAllocation_Isr(), new Object[]{"Isr2Scheduler Mapping-Error: ISR \"" + isr.getName() + "\" is not mapped to any Scheduler", isrAlloc});
                continue;
            }
            if (sched != null && isr == null) {
                this.issueCreator.issue((EObject)isrAlloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getISRAllocation_Controller(), new Object[]{"Isr2Scheduler Mapping-Error: Scheduler \"" + sched.getName() + "\" is not mapped to any ISR", isrAlloc});
                continue;
            }
            isrs.remove(isr);
        }
        for (ISR leftIsr : isrs) {
            this.issueCreator.issue((EObject)leftIsr, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTypeRef_TypeDef(), new Object[]{"Isr2Scheduler Mapping-Error: Unmapped ISR found: " + leftIsr.getName(), leftIsr});
        }
    }

    private void checkSchedulerToCoreMapping(List<Scheduler> schedulers, List<SchedulerAllocation> schedAllocs) {
        for (SchedulerAllocation alloc : schedAllocs) {
            Scheduler sched = alloc.getScheduler();
            EList cores = alloc.getResponsibility();
            if (cores.isEmpty() && sched == null) {
                this.issueCreator.issue((EObject)alloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSchedulerAllocation_Responsibility(), new Object[]{"Scheduler2Core Mapping-Error: Scheduler and Responsibility are left blank", alloc});
                continue;
            }
            if (sched != null && cores.isEmpty()) {
                this.issueCreator.issue((EObject)alloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSchedulerAllocation_Scheduler(), new Object[]{"Scheduler2Core Mapping-Error: Scheduler \"" + sched.getName() + "\" is not responsible for any Core", alloc});
                continue;
            }
            if (!cores.isEmpty() && sched == null) {
                StringBuilder sb = new StringBuilder();
                for (Core core : cores) {
                    sb.append("\"" + core.getName() + "\",");
                }
                this.issueCreator.issue((EObject)alloc, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSchedulerAllocation_Responsibility(), new Object[]{"Scheduler2Core Mapping-Error: Core(s) " + sb.toString() + " is/are not mapped to any Scheduler", alloc});
                continue;
            }
            schedulers.remove(sched);
        }
        for (Scheduler leftScheduler : schedulers) {
            Algorithm algo = leftScheduler.getSchedulingAlgorithm();
            if (algo != null && algo instanceof Grouping) continue;
            this.issueCreator.issue((EObject)leftScheduler, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getIReferable_Name(), new Object[]{"Scheduler2Core Mapping-Error: Scheduler not responsible for any core: " + leftScheduler.getName(), leftScheduler});
        }
    }
}

