/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.ArrivalCurveEntry;
import org.eclipse.app4mc.amalthea.model.Clock;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierList;
import org.eclipse.app4mc.amalthea.model.ClockMultiplierListEntry;
import org.eclipse.app4mc.amalthea.model.ClockSinusFunction;
import org.eclipse.app4mc.amalthea.model.ClockTriangleFunction;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.ModeValueListEntry;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.SyntheticStimulus;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.app4mc.amalthea.model.TimestampList;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.AbstractValidatorImpl;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IEObjectHelper;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StimuliModelValidatorImpl
extends AbstractValidatorImpl {
    public StimuliModelValidatorImpl(IssueCreator issueCreator) {
        super(issueCreator);
    }

    public StimuliModelValidatorImpl(IssueCreator issueCreator, IEObjectHelper objectHelper) {
        super(issueCreator, objectHelper);
    }

    public void checkPeriodicRecurrence(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            PeriodicStimulus periodic;
            Time recurrence;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicStimulus) || (recurrence = (periodic = (PeriodicStimulus)elem).getRecurrence()) == null) continue;
            BigInteger value = recurrence.getValue();
            TimeUnit unit = recurrence.getUnit();
            if (value.signum() > 0 && TimeUnit._UNDEFINED_ != unit) continue;
            this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Recurrence(), new Object[]{value, unit});
        }
    }

    public void checkClockReferenceOfPeriodic(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        HashSet<PeriodicStimulus> periodics = new HashSet<PeriodicStimulus>();
        HashSet<Clock> clocks = new HashSet<Clock>();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof PeriodicStimulus) {
                PeriodicStimulus periodic = (PeriodicStimulus)elem;
                periodics.add(periodic);
                continue;
            }
            if (!(elem instanceof StimuliModel)) continue;
            StimuliModel stimuliModel = (StimuliModel)elem;
            EList clockList = stimuliModel.getClocks();
            for (Clock clock : clockList) {
                if (clock == null) continue;
                clocks.add(clock);
            }
        }
        for (PeriodicStimulus periodic : periodics) {
            Clock clock;
            if (periodic == null || (clock = periodic.getClock()) != null && clocks.contains(clock)) continue;
            this.issueCreator.issue((EObject)periodic, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Clock(), new Object[0]);
        }
    }

    public void checkClockTriangleFunction(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockTriangleFunction)) continue;
            ClockTriangleFunction clockTriangleFunction = (ClockTriangleFunction)elem;
            double min = clockTriangleFunction.getMin();
            double max = clockTriangleFunction.getMax();
            if (min < 0.0) {
                this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
                continue;
            }
            if (max <= 0.0) {
                this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Max(), new Object[0]);
                continue;
            }
            if (!(min > max)) continue;
            this.issueCreator.issue((EObject)clockTriangleFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Min(), new Object[0]);
        }
    }

    public void checkClockSinusFunction(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockSinusFunction)) continue;
            ClockSinusFunction clockSinusFunction = (ClockSinusFunction)elem;
            double amplitude = clockSinusFunction.getAmplitude();
            double yOffset = clockSinusFunction.getYOffset();
            if (amplitude < 0.0) {
                this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
                continue;
            }
            if (yOffset <= 0.0) {
                this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_YOffset(), new Object[0]);
                continue;
            }
            if (!(amplitude > yOffset)) continue;
            this.issueCreator.issue((EObject)clockSinusFunction, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Amplitude(), new Object[0]);
        }
    }

    public void checkClockMultiplierList(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockMultiplierList)) continue;
            ClockMultiplierList clock = (ClockMultiplierList)elem;
            for (ClockMultiplierListEntry entry : clock.getEntries()) {
                double value = entry.getMultiplier();
                if (!(value < 0.0)) continue;
                this.issueCreator.issue((EObject)clock, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Multiplier(), new Object[0]);
            }
        }
    }

    public void checkPeriodicOffsetUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicStimulus periodic;
            Time offset;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicStimulus) || (offset = (periodic = (PeriodicStimulus)elem).getOffset()) == null || (value = offset.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Offset(), new Object[]{value});
        }
    }

    public void checkPeriodicRecurrenceUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            PeriodicStimulus periodic;
            Time recurrence;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof PeriodicStimulus) || (recurrence = (periodic = (PeriodicStimulus)elem).getRecurrence()) == null || (value = recurrence.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)recurrence, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getPeriodicStimulus_Recurrence(), new Object[]{value});
        }
    }

    public void checkSyntheticOffsetUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            SyntheticStimulus synthetic;
            Time offset;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof SyntheticStimulus) || (offset = (synthetic = (SyntheticStimulus)elem).getOffset()) == null || (value = offset.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)offset, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSyntheticStimulus_Offset(), new Object[]{value});
        }
    }

    public void checkSyntheticPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            SyntheticStimulus synthetic;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof SyntheticStimulus) || (period = (synthetic = (SyntheticStimulus)elem).getPeriod()) == null || (value = period.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSyntheticStimulus_Period(), new Object[]{value});
        }
    }

    public void checkTimestampListTimestampsUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof TimestampList)) continue;
            TimestampList timestampList = (TimestampList)elem;
            for (Time timestamp : timestampList.getTimestamps()) {
                BigInteger value;
                if (timestamp == null || (value = timestamp.getValue()).signum() >= 0) continue;
                this.issueCreator.issue((EObject)timestamp, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getTimestampList_Timestamps(), new Object[]{value});
            }
        }
    }

    public void checkSingleActivationUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            SingleStimulus single;
            Time activation;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof SingleStimulus) || (activation = (single = (SingleStimulus)elem).getActivation()) == null || (value = activation.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)activation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSingleStimulus_Activation(), new Object[]{value});
        }
    }

    public void checkArrivalCurveEntryLowerUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ArrivalCurveEntry arrivalCurveEntry;
            Time lowerTimeBorder;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ArrivalCurveEntry) || (lowerTimeBorder = (arrivalCurveEntry = (ArrivalCurveEntry)elem).getLowerTimeBorder()) == null || (value = lowerTimeBorder.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)lowerTimeBorder, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getArrivalCurveEntry_LowerTimeBorder(), new Object[]{value});
        }
    }

    public void checkArrivalCurveEntryUpperUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ArrivalCurveEntry arrivalCurveEntry;
            Time upperTimeBorder;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ArrivalCurveEntry) || (upperTimeBorder = (arrivalCurveEntry = (ArrivalCurveEntry)elem).getUpperTimeBorder()) == null || (value = upperTimeBorder.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)upperTimeBorder, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getArrivalCurveEntry_UpperTimeBorder(), new Object[]{value});
        }
    }

    public void checkClockTriangleFunctionPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ClockTriangleFunction clockTriangleFunction;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockTriangleFunction) || (period = (clockTriangleFunction = (ClockTriangleFunction)elem).getPeriod()) == null || (value = period.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockTriangleFunction_Period(), new Object[]{value});
        }
    }

    public void checkClockSinusFunctionPeriodUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ClockSinusFunction clockSinusFunction;
            Time period;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockSinusFunction) || (period = (clockSinusFunction = (ClockSinusFunction)elem).getPeriod()) == null || (value = period.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)period, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockSinusFunction_Period(), new Object[]{value});
        }
    }

    public void checkClockMultiplierListEntryTimeUnsigned(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        while (amaIter.hasNext()) {
            BigInteger value;
            ClockMultiplierListEntry clockMultiplierListEntry;
            Time time;
            EObject elem = (EObject)amaIter.next();
            if (!(elem instanceof ClockMultiplierListEntry) || (time = (clockMultiplierListEntry = (ClockMultiplierListEntry)elem).getTime()) == null || (value = time.getValue()).signum() >= 0) continue;
            this.issueCreator.issue((EObject)time, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getClockMultiplierListEntry_Time(), new Object[]{value});
        }
    }

    public void checkModeValueListEntryModeLabelConstraint(Amalthea amalthea) {
        TreeIterator amaIter = amalthea.eAllContents();
        ArrayList modeLabels = new ArrayList();
        HashMap<ModeLabel, ModeValue> valueProviders = new HashMap<ModeLabel, ModeValue>();
        while (amaIter.hasNext()) {
            EObject elem = (EObject)amaIter.next();
            if (elem instanceof SWModel) {
                SWModel swModel = (SWModel)elem;
                modeLabels.addAll(swModel.getModeLabels());
            }
            if (!(elem instanceof ModeValue)) continue;
            ModeValue entry = (ModeValue)elem;
            ModeLabel valueProvider = entry.getValueProvider();
            if (valueProvider == null) {
                this.issueCreator.issue((EObject)entry, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeValue_ValueProvider(), new Object[0]);
                continue;
            }
            valueProviders.put(valueProvider, entry);
        }
        for (ModeLabel modeLabel : valueProviders.keySet()) {
            if (modeLabels.contains(modeLabel)) continue;
            ModeValueListEntry modeValueListEntry = (ModeValueListEntry)valueProviders.get(modeLabel);
            this.issueCreator.issue((EObject)modeValueListEntry, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getModeValue_ValueProvider(), new Object[0]);
        }
    }
}

