/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.openmapping.handlers;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.multicore.openmapping.OpenMappingPlugin;
import org.eclipse.app4mc.multicore.openmapping.algorithms.taskgen.pragmatic.PragmaticTaskGenerator;
import org.eclipse.app4mc.multicore.openmapping.model.description.OMModelDescriptionBuilder;
import org.eclipse.app4mc.multicore.sharelibs.OutputPathParser;
import org.eclipse.app4mc.multicore.sharelibs.SelectionUtil;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelDescription;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.ModelSpecLogger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CreateTasks
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        UniversalHandler.getInstance().setPluginId(OpenMappingPlugin.getPluginId());
        UniversalHandler.getInstance().setLog(OpenMappingPlugin.getDefault().getLog());
        ModelSpecLogger logger = ModelSpecLogger.of();
        UniversalHandler.getInstance().clearModelCheckerView();
        IStructuredSelection selection = SelectionUtil.getSelection((ExecutionEvent)event);
        IPreferenceStore store = OpenMappingPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("org.eclipse.app4mc.multicore.openmapping.logToConsole")) {
            UniversalHandler.getInstance().enableVerboseOutput();
        }
        if (!(selection.getFirstElement() instanceof IFile)) {
            return null;
        }
        IFile swModelFile = (IFile)selection.getFirstElement();
        URI uri = URI.createPlatformResourceURI((String)swModelFile.getFullPath().toOSString(), (boolean)true);
        ModelDescription inputModelChecker = OMModelDescriptionBuilder.ofTaskCreationInput(null).setLogger(logger);
        boolean modelOk = inputModelChecker.checkModel(uri);
        if (!modelOk) {
            logger.logToView();
            logger.openMessageBox();
            return null;
        }
        UniversalHandler.getInstance().dropCache();
        UniversalHandler.getInstance().readModels(uri, true);
        Amalthea centralModel = UniversalHandler.getInstance().getCentralModel();
        PragmaticTaskGenerator createTaskAlgorithm = new PragmaticTaskGenerator();
        createTaskAlgorithm.setAmaltheaModel(centralModel);
        createTaskAlgorithm.createTasks();
        Amalthea outModel = createTaskAlgorithm.getAmaltheaOutputModel();
        ModelDescription outputModelChecker = OMModelDescriptionBuilder.ofTaskCreationOutput((Amalthea)outModel).setLogger(logger);
        modelOk = outputModelChecker.checkModel("<Internal> Task Creation Output Model", outModel);
        if (!modelOk) {
            logger.logToView();
            logger.openMessageBox();
            return null;
        }
        OutputPathParser outputParser = new OutputPathParser("org.eclipse.app4mc.multicore.openmapping.outputLocation", "org.eclipse.app4mc.multicore.openmapping.outputLocationString", store);
        UniversalHandler.getInstance().writeModel(outputParser.parseOutputFileURI(swModelFile, "_withTasks"), (EObject)outModel);
        logger.logToView();
        logger.openMessageBox();
        return null;
    }
}

